/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.dromara.pdf.pdfbox.core.base.BorderData;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;
import org.dromara.pdf.pdfbox.core.enums.LineCapStyle;
import org.dromara.pdf.pdfbox.core.enums.LineStyle;
import org.dromara.pdf.pdfbox.util.BorderUtil;
import org.dromara.pdf.pdfbox.util.CommonUtil;

public class Line
extends AbstractComponent {
    protected Float angle;
    protected Float alpha;

    public Line(Page page) {
        super(page);
    }

    public void setLineColor(Color color) {
        if (Objects.nonNull(color)) {
            this.borderConfiguration.setBorderColor(color);
        }
    }

    public void setLineStyle(LineStyle style) {
        if (Objects.nonNull((Object)style)) {
            this.borderConfiguration.setBorderLineStyle(style);
        }
    }

    public void setLineCapStyle(LineCapStyle style) {
        if (Objects.nonNull((Object)style)) {
            this.borderConfiguration.setBorderLineCapStyle(style);
        }
    }

    public void setLineLength(Float length) {
        if (Objects.nonNull(length)) {
            this.borderConfiguration.setBorderLineLength(length.floatValue());
        }
    }

    public void setLineWidth(Float width) {
        if (Objects.nonNull(width)) {
            this.borderConfiguration.setBorderLineWidth(width.floatValue());
        }
    }

    public void setDottedSpacing(Float spacing) {
        if (Objects.nonNull(spacing)) {
            this.borderConfiguration.setBorderDottedSpacing(spacing.floatValue());
        }
    }

    @Override
    public ComponentType getType() {
        return ComponentType.SPLIT_LINE;
    }

    public Color getLineColor() {
        return this.borderConfiguration.getBorderTopColor();
    }

    public LineStyle getLineStyle() {
        return this.borderConfiguration.getBorderLineStyle();
    }

    public LineCapStyle getLineCapStyle() {
        return this.borderConfiguration.getBorderLineCapStyle();
    }

    public Float getLineLength() {
        return this.borderConfiguration.getBorderLineLength();
    }

    public Float getLineWidth() {
        return this.borderConfiguration.getBorderLineWidth();
    }

    public Float getDottedSpacing() {
        return this.borderConfiguration.getBorderDottedSpacing();
    }

    @Override
    protected void init() {
        super.init();
        if (Objects.isNull(this.getLineLength())) {
            this.setLineLength(Float.valueOf(this.getContext().getWrapWidth().floatValue() - this.getMarginLeft().floatValue() - this.getMarginRight().floatValue()));
        }
        if (Objects.isNull(this.angle)) {
            this.angle = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.alpha)) {
            this.alpha = Float.valueOf(1.0f);
        }
        this.borderConfiguration.setIsBorder(false);
        this.borderConfiguration.setIsBorderTop(true);
        this.initBeginXY(this.getLineLength().floatValue(), this.getLineWidth().floatValue());
    }

    @Override
    protected float getMinWidth() {
        return this.getLineLength().floatValue();
    }

    @Override
    protected void writeContents() {
        PDPageContentStream stream = this.initContentStream();
        CommonUtil.initMatrix(stream, this.getBeginX().floatValue(), this.getBeginY().floatValue(), this.getRelativeBeginX().floatValue(), this.getRelativeBeginY().floatValue(), this.getLineLength().floatValue(), this.getLineWidth().floatValue(), this.getAngle().floatValue(), this.getAlpha().floatValue());
        BorderUtil.drawNormalBorder(stream, CommonUtil.getRectangle(this.getLineLength().floatValue(), this.getLineWidth().floatValue()), BorderData.create(this, this.getBorderConfiguration()));
        stream.close();
    }

    @Override
    protected void reset() {
        float x = this.getBeginX().floatValue() + this.getLineLength().floatValue() + this.getMarginRight().floatValue();
        float y = this.getBeginY().floatValue();
        super.reset(this.getType(), x, y);
    }

    protected PDPageContentStream initContentStream() {
        PDPageContentStream stream = new PDPageContentStream(this.getContext().getTargetDocument(), this.getContext().getTargetPage(), this.getContentMode().getMode(), true, this.getIsResetContentStream().booleanValue());
        stream.setLineWidth(this.getLineWidth().floatValue());
        stream.setStrokingColor(this.getLineColor());
        stream.setLineCapStyle(this.getLineCapStyle().getType());
        return stream;
    }

    public Float getAngle() {
        return this.angle;
    }

    public Float getAlpha() {
        return this.alpha;
    }

    public void setAngle(Float angle) {
        this.angle = angle;
    }

    public void setAlpha(Float alpha) {
        this.alpha = alpha;
    }

    @Override
    public String toString() {
        return "Line(angle=" + this.getAngle() + ", alpha=" + this.getAlpha() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Line)) {
            return false;
        }
        Line other = (Line)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$angle = this.getAngle();
        Float other$angle = other.getAngle();
        if (this$angle == null ? other$angle != null : !((Object)this$angle).equals(other$angle)) {
            return false;
        }
        Float this$alpha = this.getAlpha();
        Float other$alpha = other.getAlpha();
        return !(this$alpha == null ? other$alpha != null : !((Object)this$alpha).equals(other$alpha));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Line;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $angle = this.getAngle();
        result = result * 59 + ($angle == null ? 43 : ((Object)$angle).hashCode());
        Float $alpha = this.getAlpha();
        result = result * 59 + ($alpha == null ? 43 : ((Object)$alpha).hashCode());
        return result;
    }
}

