/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.dromara.pdf.pdfbox.core.base.DefaultContainerPagingEvent;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PagingEvent;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;
import org.dromara.pdf.pdfbox.core.component.BorderInfo;
import org.dromara.pdf.pdfbox.core.component.TableRow;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;
import org.dromara.pdf.pdfbox.core.enums.HorizontalAlignment;
import org.dromara.pdf.pdfbox.core.enums.VerticalAlignment;
import org.dromara.pdf.pdfbox.util.CommonUtil;

public class Table
extends AbstractComponent {
    protected Color backgroundColor;
    protected List<TableRow> rows;
    protected List<Float> cellWidths;
    protected PagingEvent pagingEvent;
    protected Boolean isTogether;
    protected Boolean isPagingBorder;
    protected HorizontalAlignment contentHorizontalAlignment;
    protected VerticalAlignment contentVerticalAlignment;

    public Table(Page page) {
        super(page);
    }

    public void setCellWidths(float ... widths) {
        if (Objects.nonNull(widths)) {
            this.cellWidths = new ArrayList<Float>(widths.length);
            float[] fArray = widths;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                Float cellWidth = Float.valueOf(fArray[i]);
                if (Objects.isNull(cellWidth)) {
                    throw new IllegalArgumentException("the cell width can not be null");
                }
                if (cellWidth.floatValue() <= 0.0f) {
                    throw new IllegalArgumentException("the cell width must be greater than zero");
                }
                this.cellWidths.add(cellWidth);
            }
        } else {
            this.cellWidths = null;
        }
    }

    public void setCellWidths(List<Float> widths) {
        if (Objects.nonNull(widths)) {
            this.setCellWidths(CommonUtil.toFloatArray(widths));
        } else {
            this.cellWidths = null;
        }
    }

    public void setRows(List<TableRow> rows) {
        this.rows = rows;
    }

    public void setRows(TableRow ... rows) {
        if (Objects.nonNull(rows)) {
            this.rows = new ArrayList<TableRow>(rows.length);
            Collections.addAll(this.rows, rows);
        } else {
            this.rows = null;
        }
    }

    public void addRows(List<TableRow> rows) {
        if (Objects.nonNull(rows)) {
            if (Objects.isNull(this.rows)) {
                this.rows = new ArrayList<TableRow>(rows);
            } else {
                this.rows.addAll(rows);
            }
        }
    }

    public void addRows(TableRow ... rows) {
        if (Objects.nonNull(rows)) {
            if (Objects.isNull(this.rows)) {
                this.rows = new ArrayList<TableRow>(rows.length);
            }
            Collections.addAll(this.rows, rows);
        }
    }

    public Float getWidth() {
        if (Objects.isNull(this.cellWidths)) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf((float)this.cellWidths.stream().mapToDouble(Float::doubleValue).sum());
    }

    public Float getHeight() {
        if (Objects.isNull(this.rows)) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf((float)this.rows.stream().mapToDouble(TableRow::getHeight).sum());
    }

    @Override
    public ComponentType getType() {
        return ComponentType.TABLE;
    }

    @Override
    protected void init() {
        Objects.requireNonNull(this.cellWidths, "the cell widths can not be null");
        super.init();
        this.pagingEvent = new DefaultContainerPagingEvent();
        if (Objects.isNull(this.isTogether)) {
            this.isTogether = Boolean.FALSE;
        }
        if (Objects.isNull(this.isPagingBorder)) {
            this.isPagingBorder = Boolean.FALSE;
        }
        if (!this.isCustomPosition.booleanValue() && this.relativeBeginY.floatValue() == 0.0f) {
            this.relativeBeginY = Float.valueOf(this.getFirstRowHeight());
        }
        if (Objects.isNull((Object)this.contentHorizontalAlignment)) {
            this.contentHorizontalAlignment = HorizontalAlignment.LEFT;
        }
        if (Objects.isNull((Object)this.contentVerticalAlignment)) {
            this.contentVerticalAlignment = VerticalAlignment.TOP;
        }
        this.initRows();
        this.checkWrap(this.getFirstRowHeight());
        if (this.checkPaging()) {
            this.setIsWrap(true);
            this.wrap(this.getFirstRowHeight());
        }
        this.initBeginX(this.getWidth().floatValue());
        this.initBeginY(this.getHeight().floatValue());
    }

    protected void initRows() {
        if (Objects.nonNull(this.rows)) {
            int last = this.rows.size() - 1;
            for (int i = 0; i < this.rows.size(); ++i) {
                TableRow tableRow = this.rows.get(i);
                tableRow.setIndex(i);
                if (i > 0) {
                    tableRow.setPrevious(this.rows.get(i - 1));
                }
                if (i >= last) continue;
                tableRow.setNext(this.rows.get(i + 1));
            }
        }
    }

    @Override
    protected float getMinWidth() {
        return this.getWidth().floatValue();
    }

    @Override
    protected void writeContents() {
        float beginX = this.getBeginX().floatValue() + this.getRelativeBeginX().floatValue();
        float beginY = this.getBeginY().floatValue() + this.getRelativeBeginY().floatValue();
        if (Objects.nonNull(this.getRows())) {
            Page page = this.getPage();
            float top = this.getContext().getMaxBeginY();
            float bottom = this.getBottom() - this.getMarginBottom().floatValue();
            for (TableRow tableRow : this.getRows()) {
                if (this.getContext().getIsVirtualRender().booleanValue()) {
                    tableRow.virtualRender(page, Float.valueOf(beginX), Float.valueOf(beginY));
                } else {
                    tableRow.render(page, Float.valueOf(beginX), Float.valueOf(beginY));
                }
                float height = tableRow.getHeight().floatValue();
                float lastHeight = this.getLastHeight(beginY, height, top, bottom);
                if (tableRow.getIsBreak().booleanValue() || !Objects.equals(Float.valueOf(height), Float.valueOf(lastHeight)) || beginY == 0.0f) {
                    Integer pagingCount = this.getContext().getBorderInfo().getPagingCount();
                    page = pagingCount == 1 || tableRow.getIsBreak() != false ? page.getSubPage() : page.getLastSubPage();
                    beginY = this.getContext().getCursor().getY().floatValue();
                    continue;
                }
                beginY -= tableRow.getHeight().floatValue();
            }
        }
        this.reset(beginX, beginY);
    }

    @Override
    protected Page executeBreak() {
        Float beginX = this.getBeginX();
        PagingEvent borderPagingEvent = Optional.ofNullable(this.getContext().getBorderInfo()).map(BorderInfo::getPagingEvent).orElse(null);
        if (!this.getContext().getIsManualBreak().booleanValue()) {
            Optional.ofNullable(borderPagingEvent).ifPresent(event -> event.before(this));
        }
        Page page = super.executeBreak();
        if (!this.getContext().getIsManualBreak().booleanValue()) {
            Optional.ofNullable(borderPagingEvent).ifPresent(event -> event.after(this));
        }
        this.setBeginX(beginX);
        return page;
    }

    protected float getFirstRowHeight() {
        return Optional.ofNullable(this.rows).map(rows -> ((TableRow)rows.get(0)).getHeight()).orElse(Float.valueOf(0.0f)).floatValue();
    }

    protected float getLastHeight(float beginY, float height, float top, float bottom) {
        if (beginY - height >= bottom) {
            return height;
        }
        height -= beginY - bottom;
        beginY = top;
        return this.getLastHeight(beginY, height, top, bottom);
    }

    @Override
    protected void reset() {
        this.getContext().resetWrapWidth(null);
        this.getContext().resetHeight(null);
    }

    protected void reset(float x, float y) {
        super.reset(this.getType(), x, y);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public List<TableRow> getRows() {
        return this.rows;
    }

    public List<Float> getCellWidths() {
        return this.cellWidths;
    }

    public PagingEvent getPagingEvent() {
        return this.pagingEvent;
    }

    public Boolean getIsTogether() {
        return this.isTogether;
    }

    public Boolean getIsPagingBorder() {
        return this.isPagingBorder;
    }

    public HorizontalAlignment getContentHorizontalAlignment() {
        return this.contentHorizontalAlignment;
    }

    public VerticalAlignment getContentVerticalAlignment() {
        return this.contentVerticalAlignment;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setPagingEvent(PagingEvent pagingEvent) {
        this.pagingEvent = pagingEvent;
    }

    public void setIsTogether(Boolean isTogether) {
        this.isTogether = isTogether;
    }

    public void setIsPagingBorder(Boolean isPagingBorder) {
        this.isPagingBorder = isPagingBorder;
    }

    public void setContentHorizontalAlignment(HorizontalAlignment contentHorizontalAlignment) {
        this.contentHorizontalAlignment = contentHorizontalAlignment;
    }

    public void setContentVerticalAlignment(VerticalAlignment contentVerticalAlignment) {
        this.contentVerticalAlignment = contentVerticalAlignment;
    }

    @Override
    public String toString() {
        return "Table(backgroundColor=" + this.getBackgroundColor() + ", rows=" + this.getRows() + ", cellWidths=" + this.getCellWidths() + ", pagingEvent=" + this.getPagingEvent() + ", isTogether=" + this.getIsTogether() + ", isPagingBorder=" + this.getIsPagingBorder() + ", contentHorizontalAlignment=" + (Object)((Object)this.getContentHorizontalAlignment()) + ", contentVerticalAlignment=" + (Object)((Object)this.getContentVerticalAlignment()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isTogether = this.getIsTogether();
        Boolean other$isTogether = other.getIsTogether();
        if (this$isTogether == null ? other$isTogether != null : !((Object)this$isTogether).equals(other$isTogether)) {
            return false;
        }
        Boolean this$isPagingBorder = this.getIsPagingBorder();
        Boolean other$isPagingBorder = other.getIsPagingBorder();
        if (this$isPagingBorder == null ? other$isPagingBorder != null : !((Object)this$isPagingBorder).equals(other$isPagingBorder)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        List<TableRow> this$rows = this.getRows();
        List<TableRow> other$rows = other.getRows();
        if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
            return false;
        }
        List<Float> this$cellWidths = this.getCellWidths();
        List<Float> other$cellWidths = other.getCellWidths();
        if (this$cellWidths == null ? other$cellWidths != null : !((Object)this$cellWidths).equals(other$cellWidths)) {
            return false;
        }
        PagingEvent this$pagingEvent = this.getPagingEvent();
        PagingEvent other$pagingEvent = other.getPagingEvent();
        if (this$pagingEvent == null ? other$pagingEvent != null : !this$pagingEvent.equals(other$pagingEvent)) {
            return false;
        }
        HorizontalAlignment this$contentHorizontalAlignment = this.getContentHorizontalAlignment();
        HorizontalAlignment other$contentHorizontalAlignment = other.getContentHorizontalAlignment();
        if (this$contentHorizontalAlignment == null ? other$contentHorizontalAlignment != null : !((Object)((Object)this$contentHorizontalAlignment)).equals((Object)other$contentHorizontalAlignment)) {
            return false;
        }
        VerticalAlignment this$contentVerticalAlignment = this.getContentVerticalAlignment();
        VerticalAlignment other$contentVerticalAlignment = other.getContentVerticalAlignment();
        return !(this$contentVerticalAlignment == null ? other$contentVerticalAlignment != null : !((Object)((Object)this$contentVerticalAlignment)).equals((Object)other$contentVerticalAlignment));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Table;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isTogether = this.getIsTogether();
        result = result * 59 + ($isTogether == null ? 43 : ((Object)$isTogether).hashCode());
        Boolean $isPagingBorder = this.getIsPagingBorder();
        result = result * 59 + ($isPagingBorder == null ? 43 : ((Object)$isPagingBorder).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        List<TableRow> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        List<Float> $cellWidths = this.getCellWidths();
        result = result * 59 + ($cellWidths == null ? 43 : ((Object)$cellWidths).hashCode());
        PagingEvent $pagingEvent = this.getPagingEvent();
        result = result * 59 + ($pagingEvent == null ? 43 : $pagingEvent.hashCode());
        HorizontalAlignment $contentHorizontalAlignment = this.getContentHorizontalAlignment();
        result = result * 59 + ($contentHorizontalAlignment == null ? 43 : ((Object)((Object)$contentHorizontalAlignment)).hashCode());
        VerticalAlignment $contentVerticalAlignment = this.getContentVerticalAlignment();
        result = result * 59 + ($contentVerticalAlignment == null ? 43 : ((Object)((Object)$contentVerticalAlignment)).hashCode());
        return result;
    }
}

