/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.core.base.BorderData;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PagingEvent;
import org.dromara.pdf.pdfbox.core.base.config.BorderConfiguration;
import org.dromara.pdf.pdfbox.core.component.BorderInfo;
import org.dromara.pdf.pdfbox.core.component.Component;
import org.dromara.pdf.pdfbox.core.component.Table;
import org.dromara.pdf.pdfbox.core.component.TableRow;
import org.dromara.pdf.pdfbox.core.enums.HorizontalAlignment;
import org.dromara.pdf.pdfbox.core.enums.LineCapStyle;
import org.dromara.pdf.pdfbox.core.enums.LineStyle;
import org.dromara.pdf.pdfbox.core.enums.VerticalAlignment;
import org.dromara.pdf.pdfbox.util.BorderUtil;
import org.dromara.pdf.pdfbox.util.CommonUtil;

public class TableCell
extends BorderData {
    protected Color backgroundColor;
    protected TableRow row;
    protected Integer index;
    protected List<Component> components;
    protected Float width;
    protected Integer rowspan;
    protected Integer colspan;
    protected Float beginX;
    protected Float beginY;
    protected Boolean isPagingBorder;
    protected HorizontalAlignment contentHorizontalAlignment;
    protected VerticalAlignment contentVerticalAlignment;

    public TableCell(TableRow row) {
        this.row = row;
        this.borderConfiguration = new BorderConfiguration(false);
    }

    @Override
    public void setBorderLineStyle(LineStyle style) {
        this.borderConfiguration.setBorderLineStyle(style);
    }

    @Override
    public void setBorderLineCapStyle(LineCapStyle style) {
        this.borderConfiguration.setBorderLineCapStyle(style);
    }

    @Override
    public void setBorderLineLength(float length) {
        this.borderConfiguration.setBorderLineLength(length);
    }

    @Override
    public void setBorderLineWidth(float width) {
        this.borderConfiguration.setBorderLineWidth(width);
    }

    @Override
    public void setBorderDottedSpacing(float spacing) {
        this.borderConfiguration.setBorderDottedSpacing(spacing);
    }

    public void setBorderColor(Color color) {
        this.borderConfiguration.setBorderColor(color);
    }

    @Override
    public void setBorderTopColor(Color color) {
        this.borderConfiguration.setBorderTopColor(color);
    }

    @Override
    public void setBorderBottomColor(Color color) {
        this.borderConfiguration.setBorderBottomColor(color);
    }

    @Override
    public void setBorderLeftColor(Color color) {
        this.borderConfiguration.setBorderLeftColor(color);
    }

    @Override
    public void setBorderRightColor(Color color) {
        this.borderConfiguration.setBorderRightColor(color);
    }

    public void setBorderRightColor(boolean flag) {
        this.borderConfiguration.setIsBorderTop(flag);
    }

    @Override
    public void setIsBorder(boolean flag) {
        this.borderConfiguration.setIsBorder(flag);
    }

    @Override
    public void setIsBorderTop(boolean flag) {
        this.borderConfiguration.setIsBorderTop(flag);
    }

    @Override
    public void setIsBorderBottom(boolean flag) {
        this.borderConfiguration.setIsBorderBottom(flag);
    }

    @Override
    public void setIsBorderLeft(boolean flag) {
        this.borderConfiguration.setIsBorderLeft(flag);
    }

    @Override
    public void setIsBorderRight(boolean flag) {
        this.borderConfiguration.setIsBorderRight(flag);
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    public void setComponents(Component ... components) {
        this.components = Objects.nonNull(components) ? new ArrayList<Component>(Arrays.asList(components)) : null;
    }

    public void addComponents(List<Component> components) {
        if (Objects.nonNull(components)) {
            if (Objects.isNull(this.components)) {
                this.components = new ArrayList<Component>(components);
            } else {
                this.components.addAll(components);
            }
        }
    }

    public void addComponents(Component ... components) {
        if (Objects.nonNull(components)) {
            if (Objects.isNull(this.components)) {
                this.components = new ArrayList<Component>(components.length);
            }
            Collections.addAll(this.components, components);
        }
    }

    public Float getWidth() {
        if (this.getColspan() == 0) {
            return this.width;
        }
        int lastIndex = this.index + this.colspan;
        float total = this.width.floatValue();
        List<Float> cellWidths = this.getRow().getTable().getCellWidths();
        for (int i = this.index + 1; i <= lastIndex; ++i) {
            total += cellWidths.get(i).floatValue();
        }
        return Float.valueOf(total);
    }

    protected Float getHeight() {
        if (this.getRowspan() == 0) {
            return this.row.getHeight();
        }
        int lastIndex = this.row.getIndex() + this.rowspan;
        float total = this.row.getHeight().floatValue();
        TableRow tableRow = Optional.ofNullable(this.row.getNext()).orElse(this.row);
        for (int i = this.row.getIndex() + 1; i <= lastIndex; ++i) {
            total += tableRow.getHeight().floatValue();
            tableRow = Optional.ofNullable(tableRow.getNext()).orElse(this.row);
        }
        return Float.valueOf(total);
    }

    public Integer getRowspan() {
        return Optional.ofNullable(this.rowspan).orElse(0);
    }

    public Integer getColspan() {
        return Optional.ofNullable(this.colspan).orElse(0);
    }

    public Page getPage() {
        return this.row.getPage();
    }

    public void virtualRender(Float beginX, Float beginY) {
        this.processRender(beginX, beginY, false);
    }

    public void render(Float beginX, Float beginY) {
        this.processRender(beginX, beginY, true);
    }

    protected PagingEvent getPagingEvent() {
        return this.row.getPagingEvent();
    }

    protected void init(Float beginX, Float beginY) {
        try {
            this.width = this.row.getTable().getCellWidths().get(this.index);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("the index['" + this.index + "'] of cell width is undefined");
        }
        if (Objects.isNull(this.backgroundColor)) {
            this.backgroundColor = this.row.getBackgroundColor();
        }
        if (Objects.isNull((Object)this.contentHorizontalAlignment)) {
            this.contentHorizontalAlignment = this.row.getContentHorizontalAlignment();
        }
        if (Objects.isNull((Object)this.contentVerticalAlignment)) {
            this.contentVerticalAlignment = this.row.getContentVerticalAlignment();
        }
        this.beginX = beginX;
        this.beginY = beginY;
        this.initBorder();
        this.getContext().setBorderInfo(new BorderInfo(this, this.getBorderConfiguration(), this.getBackgroundColor(), this.getWidth().floatValue(), this.getHeight().floatValue(), this.getBeginX().floatValue(), this.getBeginY().floatValue(), this.getPagingEvent(), this.getIsPagingBorder()));
    }

    protected void initBorder() {
        super.init(this.row, this.row.getBorderConfiguration());
        if (Objects.isNull(this.isPagingBorder)) {
            this.isPagingBorder = this.row.getIsPagingBorder();
        }
    }

    protected void processRender(Float beginX, Float beginY, boolean isRender) {
        this.init(beginX, beginY);
        BorderInfo borderInfo = this.getContext().getBorderInfo();
        Page page = this.getRow().getPage();
        Context context = page.getContext();
        context.setPage(page);
        context.getCursor().reset(beginX.floatValue(), beginY.floatValue());
        float tempY = this.addBorder(beginX, Float.valueOf(beginY.floatValue() - borderInfo.getHeight().floatValue()), borderInfo);
        if (Objects.nonNull(this.getComponents())) {
            context.setPage(page);
            context.setIsFirstComponent(true);
            context.setHeight(this.getHeight());
            context.getCursor().reset(beginX.floatValue(), beginY.floatValue());
            for (Component component : this.getComponents()) {
                context.setWrapBeginX(beginX);
                context.setWrapWidth(this.getWidth());
                component.setHorizontalAlignment(this.getContentHorizontalAlignment());
                component.setVerticalAlignment(this.getContentVerticalAlignment());
                if (isRender) {
                    component.render();
                    continue;
                }
                component.virtualRender();
            }
        }
        context.resetCursor(Float.valueOf(beginX.floatValue() + this.getWidth().floatValue()), Float.valueOf(tempY));
    }

    protected float addBorder(Float beginX, Float beginY, BorderInfo info) {
        Table table = this.getRow().getTable();
        info.setBeginX(beginX);
        if (info.isPaging() && !this.getIsPagingBorder().booleanValue()) {
            info.setIsBorderTop(Boolean.FALSE);
        }
        if (table.isPaging(table, beginY.floatValue())) {
            return this.addBorder(beginX, Float.valueOf(info.getBeginY().floatValue() - info.getHeight().floatValue()), info);
        }
        PDRectangle rectangle = new PDRectangle(info.getBeginX().floatValue(), info.getBeginY().floatValue() - info.getHeight().floatValue(), info.getWidth().floatValue(), info.getHeight().floatValue());
        CommonUtil.addBackgroundColor(info.getContext(), info.getContentMode(), info.getIsResetContentStream(), rectangle, info.getBackgroundColor());
        BorderUtil.drawBorderWithData(info, rectangle);
        return rectangle.getLowerLeftY();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public TableRow getRow() {
        return this.row;
    }

    public Integer getIndex() {
        return this.index;
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public Boolean getIsPagingBorder() {
        return this.isPagingBorder;
    }

    public HorizontalAlignment getContentHorizontalAlignment() {
        return this.contentHorizontalAlignment;
    }

    public VerticalAlignment getContentVerticalAlignment() {
        return this.contentVerticalAlignment;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setRow(TableRow row) {
        this.row = row;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public void setWidth(Float width) {
        this.width = width;
    }

    public void setRowspan(Integer rowspan) {
        this.rowspan = rowspan;
    }

    public void setColspan(Integer colspan) {
        this.colspan = colspan;
    }

    public void setBeginX(Float beginX) {
        this.beginX = beginX;
    }

    public void setBeginY(Float beginY) {
        this.beginY = beginY;
    }

    public void setIsPagingBorder(Boolean isPagingBorder) {
        this.isPagingBorder = isPagingBorder;
    }

    public void setContentHorizontalAlignment(HorizontalAlignment contentHorizontalAlignment) {
        this.contentHorizontalAlignment = contentHorizontalAlignment;
    }

    public void setContentVerticalAlignment(VerticalAlignment contentVerticalAlignment) {
        this.contentVerticalAlignment = contentVerticalAlignment;
    }

    @Override
    public String toString() {
        return "TableCell(backgroundColor=" + this.getBackgroundColor() + ", row=" + this.getRow() + ", index=" + this.getIndex() + ", components=" + this.getComponents() + ", width=" + this.getWidth() + ", rowspan=" + this.getRowspan() + ", colspan=" + this.getColspan() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", isPagingBorder=" + this.getIsPagingBorder() + ", contentHorizontalAlignment=" + (Object)((Object)this.getContentHorizontalAlignment()) + ", contentVerticalAlignment=" + (Object)((Object)this.getContentVerticalAlignment()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableCell)) {
            return false;
        }
        TableCell other = (TableCell)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$index = this.getIndex();
        Integer other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        Float this$width = this.getWidth();
        Float other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$rowspan = this.getRowspan();
        Integer other$rowspan = other.getRowspan();
        if (this$rowspan == null ? other$rowspan != null : !((Object)this$rowspan).equals(other$rowspan)) {
            return false;
        }
        Integer this$colspan = this.getColspan();
        Integer other$colspan = other.getColspan();
        if (this$colspan == null ? other$colspan != null : !((Object)this$colspan).equals(other$colspan)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Boolean this$isPagingBorder = this.getIsPagingBorder();
        Boolean other$isPagingBorder = other.getIsPagingBorder();
        if (this$isPagingBorder == null ? other$isPagingBorder != null : !((Object)this$isPagingBorder).equals(other$isPagingBorder)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        TableRow this$row = this.getRow();
        TableRow other$row = other.getRow();
        if (this$row == null ? other$row != null : !((Object)this$row).equals(other$row)) {
            return false;
        }
        List<Component> this$components = this.getComponents();
        List<Component> other$components = other.getComponents();
        if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
            return false;
        }
        HorizontalAlignment this$contentHorizontalAlignment = this.getContentHorizontalAlignment();
        HorizontalAlignment other$contentHorizontalAlignment = other.getContentHorizontalAlignment();
        if (this$contentHorizontalAlignment == null ? other$contentHorizontalAlignment != null : !((Object)((Object)this$contentHorizontalAlignment)).equals((Object)other$contentHorizontalAlignment)) {
            return false;
        }
        VerticalAlignment this$contentVerticalAlignment = this.getContentVerticalAlignment();
        VerticalAlignment other$contentVerticalAlignment = other.getContentVerticalAlignment();
        return !(this$contentVerticalAlignment == null ? other$contentVerticalAlignment != null : !((Object)((Object)this$contentVerticalAlignment)).equals((Object)other$contentVerticalAlignment));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TableCell;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        Float $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $rowspan = this.getRowspan();
        result = result * 59 + ($rowspan == null ? 43 : ((Object)$rowspan).hashCode());
        Integer $colspan = this.getColspan();
        result = result * 59 + ($colspan == null ? 43 : ((Object)$colspan).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Boolean $isPagingBorder = this.getIsPagingBorder();
        result = result * 59 + ($isPagingBorder == null ? 43 : ((Object)$isPagingBorder).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        TableRow $row = this.getRow();
        result = result * 59 + ($row == null ? 43 : ((Object)$row).hashCode());
        List<Component> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        HorizontalAlignment $contentHorizontalAlignment = this.getContentHorizontalAlignment();
        result = result * 59 + ($contentHorizontalAlignment == null ? 43 : ((Object)((Object)$contentHorizontalAlignment)).hashCode());
        VerticalAlignment $contentVerticalAlignment = this.getContentVerticalAlignment();
        result = result * 59 + ($contentVerticalAlignment == null ? 43 : ((Object)((Object)$contentVerticalAlignment)).hashCode());
        return result;
    }
}

