/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.dromara.pdf.pdfbox.core.base.BorderData;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PagingEvent;
import org.dromara.pdf.pdfbox.core.base.config.BorderConfiguration;
import org.dromara.pdf.pdfbox.core.component.Table;
import org.dromara.pdf.pdfbox.core.component.TableCell;
import org.dromara.pdf.pdfbox.core.enums.HorizontalAlignment;
import org.dromara.pdf.pdfbox.core.enums.LineCapStyle;
import org.dromara.pdf.pdfbox.core.enums.LineStyle;
import org.dromara.pdf.pdfbox.core.enums.VerticalAlignment;

public class TableRow
extends BorderData {
    protected Color backgroundColor;
    protected Table table;
    protected Page page;
    protected Integer index;
    protected TableRow previous;
    protected TableRow next;
    protected List<TableCell> cells;
    protected Float height;
    protected Float beginX;
    protected Float beginY;
    protected Boolean isBreak;
    protected Boolean isTogether;
    protected Boolean isPagingBorder;
    protected HorizontalAlignment contentHorizontalAlignment;
    protected VerticalAlignment contentVerticalAlignment;

    public TableRow(Table table) {
        this.table = table;
        this.borderConfiguration = new BorderConfiguration(false);
    }

    public void setHeight(float height) {
        if (height <= 0.0f) {
            throw new IllegalArgumentException("height must be positive");
        }
        this.height = Float.valueOf(height);
    }

    @Override
    public void setBorderLineStyle(LineStyle style) {
        this.borderConfiguration.setBorderLineStyle(style);
    }

    @Override
    public void setBorderLineCapStyle(LineCapStyle style) {
        this.borderConfiguration.setBorderLineCapStyle(style);
    }

    @Override
    public void setBorderLineLength(float length) {
        this.borderConfiguration.setBorderLineLength(length);
    }

    @Override
    public void setBorderLineWidth(float width) {
        this.borderConfiguration.setBorderLineWidth(width);
    }

    @Override
    public void setBorderDottedSpacing(float spacing) {
        this.borderConfiguration.setBorderDottedSpacing(spacing);
    }

    public void setBorderColor(Color color) {
        this.borderConfiguration.setBorderColor(color);
    }

    @Override
    public void setBorderTopColor(Color color) {
        this.borderConfiguration.setBorderTopColor(color);
    }

    @Override
    public void setBorderBottomColor(Color color) {
        this.borderConfiguration.setBorderBottomColor(color);
    }

    @Override
    public void setBorderLeftColor(Color color) {
        this.borderConfiguration.setBorderLeftColor(color);
    }

    @Override
    public void setBorderRightColor(Color color) {
        this.borderConfiguration.setBorderRightColor(color);
    }

    public void setBorderRightColor(boolean flag) {
        this.borderConfiguration.setIsBorderTop(flag);
    }

    @Override
    public void setIsBorder(boolean flag) {
        this.borderConfiguration.setIsBorder(flag);
    }

    @Override
    public void setIsBorderTop(boolean flag) {
        this.borderConfiguration.setIsBorderTop(flag);
    }

    @Override
    public void setIsBorderBottom(boolean flag) {
        this.borderConfiguration.setIsBorderBottom(flag);
    }

    @Override
    public void setIsBorderLeft(boolean flag) {
        this.borderConfiguration.setIsBorderLeft(flag);
    }

    @Override
    public void setIsBorderRight(boolean flag) {
        this.borderConfiguration.setIsBorderRight(flag);
    }

    public void setCells(List<TableCell> cells) {
        this.cells = cells;
    }

    public void setCells(TableCell ... cells) {
        if (Objects.nonNull(cells)) {
            this.cells = new ArrayList<TableCell>(cells.length);
            Collections.addAll(this.cells, cells);
        } else {
            this.cells = null;
        }
    }

    public void addCells(List<TableCell> cells) {
        if (Objects.nonNull(cells)) {
            if (Objects.isNull(this.cells)) {
                this.cells = new ArrayList<TableCell>(cells);
            } else {
                this.cells.addAll(cells);
            }
        }
    }

    public void addCells(TableCell ... cells) {
        if (Objects.nonNull(cells)) {
            if (Objects.isNull(this.cells)) {
                this.cells = new ArrayList<TableCell>(Math.max(cells.length, 8));
            }
            Collections.addAll(this.cells, cells);
        }
    }

    public Float getWidth() {
        if (Objects.isNull(this.cells)) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf((float)this.cells.stream().mapToDouble(TableCell::getWidth).sum());
    }

    public void virtualRender(Page page, Float beginX, Float beginY) {
        this.init(page, beginX, beginY);
        if (Objects.nonNull(this.getCells())) {
            List<Float> cellWidths = this.getTable().getCellWidths();
            int index = 0;
            for (TableCell tableCell : this.getCells()) {
                if (Objects.nonNull(tableCell)) {
                    tableCell.virtualRender(beginX, beginY);
                }
                beginX = Float.valueOf(beginX.floatValue() + cellWidths.get(index).floatValue());
                ++index;
            }
        }
    }

    public void render(Page page, Float beginX, Float beginY) {
        this.init(page, beginX, beginY);
        if (Objects.nonNull(this.getCells())) {
            List<Float> cellWidths = this.getTable().getCellWidths();
            int index = 0;
            for (TableCell tableCell : this.getCells()) {
                if (Objects.nonNull(tableCell)) {
                    tableCell.render(beginX, this.getBeginY());
                }
                beginX = Float.valueOf(beginX.floatValue() + cellWidths.get(index).floatValue());
                ++index;
            }
        }
    }

    protected PagingEvent getPagingEvent() {
        return this.table.getPagingEvent();
    }

    protected void init(Page page, Float beginX, Float beginY) {
        Objects.requireNonNull(this.height, "the row height can not be null");
        this.page = page;
        this.beginX = beginX;
        this.beginY = beginY;
        if (Objects.isNull(this.backgroundColor)) {
            this.backgroundColor = this.table.getBackgroundColor();
        }
        if (Objects.isNull(this.isBreak)) {
            this.isBreak = Boolean.FALSE;
        }
        if (Objects.isNull(this.isTogether)) {
            this.isTogether = this.table.getIsTogether();
        }
        if (Objects.isNull((Object)this.contentHorizontalAlignment)) {
            this.contentHorizontalAlignment = this.table.getContentHorizontalAlignment();
        }
        if (Objects.isNull((Object)this.contentVerticalAlignment)) {
            this.contentVerticalAlignment = this.table.getContentVerticalAlignment();
        }
        this.initBorder();
        this.initCells();
        this.checkTogether();
        this.checkBreak();
    }

    protected void initBorder() {
        super.init(this.page, this.table.getBorderConfiguration());
        if (Objects.isNull(this.isPagingBorder)) {
            this.isPagingBorder = this.table.getIsPagingBorder();
        }
    }

    protected void initCells() {
        if (Objects.nonNull(this.cells)) {
            int index = 0;
            for (TableCell tableCell : this.cells) {
                if (Objects.nonNull(tableCell)) {
                    tableCell.setIndex(index);
                } else {
                    this.isTogether = false;
                }
                ++index;
            }
        }
    }

    protected void checkTogether() {
        if (this.isTogether.booleanValue() && !this.isBreak.booleanValue()) {
            this.isBreak = this.beginY.floatValue() - this.height.floatValue() < this.table.getBottom();
        }
    }

    protected void checkBreak() {
        if (this.isBreak.booleanValue()) {
            this.getContext().setIsAlreadyPaging(false);
            this.getContext().setIsManualBreak(true);
            this.table.processBreak();
            this.getContext().setIsManualBreak(false);
            this.page = this.getContext().getPage();
            this.beginY = this.getContext().getCursor().getY();
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Table getTable() {
        return this.table;
    }

    public Page getPage() {
        return this.page;
    }

    public Integer getIndex() {
        return this.index;
    }

    public TableRow getPrevious() {
        return this.previous;
    }

    public TableRow getNext() {
        return this.next;
    }

    public List<TableCell> getCells() {
        return this.cells;
    }

    public Float getHeight() {
        return this.height;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public Boolean getIsBreak() {
        return this.isBreak;
    }

    public Boolean getIsTogether() {
        return this.isTogether;
    }

    public Boolean getIsPagingBorder() {
        return this.isPagingBorder;
    }

    public HorizontalAlignment getContentHorizontalAlignment() {
        return this.contentHorizontalAlignment;
    }

    public VerticalAlignment getContentVerticalAlignment() {
        return this.contentVerticalAlignment;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public void setPrevious(TableRow previous) {
        this.previous = previous;
    }

    public void setNext(TableRow next) {
        this.next = next;
    }

    public void setBeginX(Float beginX) {
        this.beginX = beginX;
    }

    public void setBeginY(Float beginY) {
        this.beginY = beginY;
    }

    public void setIsBreak(Boolean isBreak) {
        this.isBreak = isBreak;
    }

    public void setIsTogether(Boolean isTogether) {
        this.isTogether = isTogether;
    }

    public void setIsPagingBorder(Boolean isPagingBorder) {
        this.isPagingBorder = isPagingBorder;
    }

    public void setContentHorizontalAlignment(HorizontalAlignment contentHorizontalAlignment) {
        this.contentHorizontalAlignment = contentHorizontalAlignment;
    }

    public void setContentVerticalAlignment(VerticalAlignment contentVerticalAlignment) {
        this.contentVerticalAlignment = contentVerticalAlignment;
    }

    @Override
    public String toString() {
        return "TableRow(backgroundColor=" + this.getBackgroundColor() + ", table=" + this.getTable() + ", page=" + this.getPage() + ", index=" + this.getIndex() + ", previous=" + this.getPrevious() + ", next=" + this.getNext() + ", cells=" + this.getCells() + ", height=" + this.getHeight() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", isBreak=" + this.getIsBreak() + ", isTogether=" + this.getIsTogether() + ", isPagingBorder=" + this.getIsPagingBorder() + ", contentHorizontalAlignment=" + (Object)((Object)this.getContentHorizontalAlignment()) + ", contentVerticalAlignment=" + (Object)((Object)this.getContentVerticalAlignment()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableRow)) {
            return false;
        }
        TableRow other = (TableRow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$index = this.getIndex();
        Integer other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Boolean this$isBreak = this.getIsBreak();
        Boolean other$isBreak = other.getIsBreak();
        if (this$isBreak == null ? other$isBreak != null : !((Object)this$isBreak).equals(other$isBreak)) {
            return false;
        }
        Boolean this$isTogether = this.getIsTogether();
        Boolean other$isTogether = other.getIsTogether();
        if (this$isTogether == null ? other$isTogether != null : !((Object)this$isTogether).equals(other$isTogether)) {
            return false;
        }
        Boolean this$isPagingBorder = this.getIsPagingBorder();
        Boolean other$isPagingBorder = other.getIsPagingBorder();
        if (this$isPagingBorder == null ? other$isPagingBorder != null : !((Object)this$isPagingBorder).equals(other$isPagingBorder)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        Table this$table = this.getTable();
        Table other$table = other.getTable();
        if (this$table == null ? other$table != null : !((Object)this$table).equals(other$table)) {
            return false;
        }
        Page this$page = this.getPage();
        Page other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        TableRow this$previous = this.getPrevious();
        TableRow other$previous = other.getPrevious();
        if (this$previous == null ? other$previous != null : !((Object)this$previous).equals(other$previous)) {
            return false;
        }
        TableRow this$next = this.getNext();
        TableRow other$next = other.getNext();
        if (this$next == null ? other$next != null : !((Object)this$next).equals(other$next)) {
            return false;
        }
        List<TableCell> this$cells = this.getCells();
        List<TableCell> other$cells = other.getCells();
        if (this$cells == null ? other$cells != null : !((Object)this$cells).equals(other$cells)) {
            return false;
        }
        HorizontalAlignment this$contentHorizontalAlignment = this.getContentHorizontalAlignment();
        HorizontalAlignment other$contentHorizontalAlignment = other.getContentHorizontalAlignment();
        if (this$contentHorizontalAlignment == null ? other$contentHorizontalAlignment != null : !((Object)((Object)this$contentHorizontalAlignment)).equals((Object)other$contentHorizontalAlignment)) {
            return false;
        }
        VerticalAlignment this$contentVerticalAlignment = this.getContentVerticalAlignment();
        VerticalAlignment other$contentVerticalAlignment = other.getContentVerticalAlignment();
        return !(this$contentVerticalAlignment == null ? other$contentVerticalAlignment != null : !((Object)((Object)this$contentVerticalAlignment)).equals((Object)other$contentVerticalAlignment));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TableRow;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Boolean $isBreak = this.getIsBreak();
        result = result * 59 + ($isBreak == null ? 43 : ((Object)$isBreak).hashCode());
        Boolean $isTogether = this.getIsTogether();
        result = result * 59 + ($isTogether == null ? 43 : ((Object)$isTogether).hashCode());
        Boolean $isPagingBorder = this.getIsPagingBorder();
        result = result * 59 + ($isPagingBorder == null ? 43 : ((Object)$isPagingBorder).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        Table $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        Page $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        TableRow $previous = this.getPrevious();
        result = result * 59 + ($previous == null ? 43 : ((Object)$previous).hashCode());
        TableRow $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
        List<TableCell> $cells = this.getCells();
        result = result * 59 + ($cells == null ? 43 : ((Object)$cells).hashCode());
        HorizontalAlignment $contentHorizontalAlignment = this.getContentHorizontalAlignment();
        result = result * 59 + ($contentHorizontalAlignment == null ? 43 : ((Object)((Object)$contentHorizontalAlignment)).hashCode());
        VerticalAlignment $contentVerticalAlignment = this.getContentVerticalAlignment();
        result = result * 59 + ($contentVerticalAlignment == null ? 43 : ((Object)((Object)$contentVerticalAlignment)).hashCode());
        return result;
    }
}

