/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.analyzer;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.pdfbox.contentstream.PDFStreamEngine;
import org.apache.pdfbox.contentstream.operator.DrawObject;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.contentstream.operator.state.Concatenate;
import org.apache.pdfbox.contentstream.operator.state.Restore;
import org.apache.pdfbox.contentstream.operator.state.Save;
import org.apache.pdfbox.contentstream.operator.state.SetGraphicsStateParameters;
import org.apache.pdfbox.contentstream.operator.state.SetMatrix;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.util.Matrix;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractAnalyzer;
import org.dromara.pdf.pdfbox.core.info.ImageInfo;

public abstract class AbstractImageAnalyzer
extends AbstractAnalyzer {
    protected DefaultStreamEngine streamEngine;
    protected final Set<ImageInfo> infoSet = new HashSet<ImageInfo>(16);

    public AbstractImageAnalyzer(Document document) {
        super(document);
    }

    public abstract void processImage(int var1, PDPage var2);

    public DefaultStreamEngine getStreamEngine() {
        return this.streamEngine;
    }

    public Set<ImageInfo> getInfoSet() {
        return this.infoSet;
    }

    protected static class DefaultStreamEngine
    extends PDFStreamEngine {
        protected Log log;
        protected Integer pageIndex;
        protected Integer imageIndex;
        protected Set<ImageInfo> infoSet;

        public DefaultStreamEngine(Log log) {
            this.addOperator((OperatorProcessor)new Concatenate((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new DrawObject((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetGraphicsStateParameters((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new Save((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new Restore((PDFStreamEngine)this));
            this.addOperator((OperatorProcessor)new SetMatrix((PDFStreamEngine)this));
            this.log = log;
            this.infoSet = new HashSet<ImageInfo>(16);
        }

        protected void processOperator(Operator operator, List<COSBase> operands) {
            if ("Do".equals(operator.getName())) {
                PDXObject xObject = this.getResources().getXObject((COSName)operands.get(0));
                if (xObject instanceof PDImageXObject) {
                    PDImageXObject image = (PDImageXObject)xObject;
                    PDRectangle rectangle = this.getCurrentPage().getMediaBox();
                    Matrix matrix = this.getGraphicsState().getCurrentTransformationMatrix();
                    ImageInfo imageInfo = ImageInfo.builder().pageIndex(this.pageIndex).pageWidth(Float.valueOf(rectangle.getWidth())).pageHeight(Float.valueOf(rectangle.getHeight())).imageIndex(this.imageIndex).imageType(image.getSuffix()).imageRealWidth(image.getWidth()).imageRealHeight(image.getHeight()).imageDisplayWidth((int)matrix.getScalingFactorX()).imageDisplayHeight((int)matrix.getScalingFactorY()).imagePosition(this.getPosition(matrix, image.getWidth() == (int)matrix.getScalingFactorX(), image.getHeight() == (int)matrix.getScalingFactorY())).image(image.getImage()).build();
                    this.infoSet.add(imageInfo);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("\n********************************************ANALYZE IMAGE BEGIN********************************************\npage index: " + imageInfo.getPageIndex() + "\npage width: " + imageInfo.getPageWidth() + "\npage height: " + imageInfo.getPageHeight() + "\nimage index: " + imageInfo.getImageIndex() + "\nimage type: " + imageInfo.getImageType() + "\nimage real width: " + imageInfo.getImageRealWidth() + "\nimage real height: " + imageInfo.getImageRealHeight() + "\nimage display width: " + imageInfo.getImageDisplayWidth() + "\nimage display height: " + imageInfo.getImageDisplayHeight() + "\nimage position: " + imageInfo.getImagePosition() + "\n*********************************************ANALYZE IMAGE END*********************************************"));
                    }
                    DefaultStreamEngine defaultStreamEngine = this;
                    Integer n = defaultStreamEngine.imageIndex;
                    Integer n2 = defaultStreamEngine.imageIndex = Integer.valueOf(defaultStreamEngine.imageIndex + 1);
                } else if (xObject instanceof PDFormXObject) {
                    this.showForm((PDFormXObject)xObject);
                }
            } else {
                super.processOperator(operator, operands);
            }
        }

        protected String getPosition(Matrix matrix, boolean equalWidth, boolean equalHeight) {
            StringBuilder builder = new StringBuilder();
            if (equalWidth && matrix.getTranslateX() < 0.0f) {
                builder.append("0.0");
            } else {
                builder.append(matrix.getTranslateX());
            }
            builder.append(',');
            if (equalHeight && matrix.getTranslateY() < 0.0f) {
                builder.append("0.0");
            } else {
                builder.append(matrix.getTranslateY());
            }
            return builder.toString();
        }

        public void setLog(Log log) {
            this.log = log;
        }

        public void setPageIndex(Integer pageIndex) {
            this.pageIndex = pageIndex;
        }

        public void setImageIndex(Integer imageIndex) {
            this.imageIndex = imageIndex;
        }

        public void setInfoSet(Set<ImageInfo> infoSet) {
            this.infoSet = infoSet;
        }

        public Log getLog() {
            return this.log;
        }

        public Integer getPageIndex() {
            return this.pageIndex;
        }

        public Integer getImageIndex() {
            return this.imageIndex;
        }

        public Set<ImageInfo> getInfoSet() {
            return this.infoSet;
        }
    }
}

