/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.extractor;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.extractor.AbstractBookmarkExtractor;
import org.dromara.pdf.pdfbox.core.ext.extractor.AbstractCommentExtractor;
import org.dromara.pdf.pdfbox.core.ext.extractor.AbstractExtractor;
import org.dromara.pdf.pdfbox.core.ext.extractor.AbstractFormExtractor;
import org.dromara.pdf.pdfbox.core.ext.extractor.AbstractImageExtractor;
import org.dromara.pdf.pdfbox.core.ext.extractor.AbstractTextExtractor;
import org.dromara.pdf.pdfbox.core.ext.extractor.BookmarkExtractor;
import org.dromara.pdf.pdfbox.core.ext.extractor.CommentExtractor;
import org.dromara.pdf.pdfbox.core.ext.extractor.FormExtractor;
import org.dromara.pdf.pdfbox.core.ext.extractor.ImageExtractor;
import org.dromara.pdf.pdfbox.core.ext.extractor.TextExtractor;

public class DocumentExtractor
extends AbstractExtractor
implements Closeable {
    protected AbstractTextExtractor textExtractor;
    protected AbstractImageExtractor imageExtractor;
    protected AbstractFormExtractor formExtractor;
    protected AbstractCommentExtractor commentExtractor;
    protected AbstractBookmarkExtractor bookmarkExtractor;

    public DocumentExtractor(Document document) {
        super(document);
    }

    public Map<Integer, List<String>> extractText(int ... pageIndexes) {
        return this.extractTextByRegex(null, pageIndexes);
    }

    public Map<Integer, List<String>> extractTextByRegex(String regex, int ... pageIndexes) {
        if (Objects.isNull(this.textExtractor)) {
            this.textExtractor = new TextExtractor(this.document);
        }
        return this.textExtractor.extractByRegex(regex, pageIndexes);
    }

    public Map<Integer, Map<String, String>> extractTextByRegionArea(Map<String, Rectangle> regionArea, int ... pageIndexes) {
        return this.extractTextByRegionArea(regionArea, " ", pageIndexes);
    }

    public Map<Integer, Map<String, String>> extractTextByRegionArea(Map<String, Rectangle> regionArea, String wordSeparator, int ... pageIndexes) {
        Objects.requireNonNull(regionArea, "the region area can not be null");
        Objects.requireNonNull(wordSeparator, "the word separator can not be null");
        if (Objects.isNull(this.textExtractor)) {
            this.textExtractor = new TextExtractor(this.document);
        }
        return this.textExtractor.extractByRegionArea(wordSeparator, regionArea, pageIndexes);
    }

    public Map<Integer, Map<String, List<List<String>>>> extractTextForTable(Map<String, Rectangle> regionArea, int ... pageIndexes) {
        return this.extractTextForTable(regionArea, " ", pageIndexes);
    }

    public Map<Integer, Map<String, List<List<String>>>> extractTextForTable(Map<String, Rectangle> regionArea, String wordSeparator, int ... pageIndexes) {
        Objects.requireNonNull(regionArea, "the region area can not be null");
        Objects.requireNonNull(wordSeparator, "the word separator can not be null");
        if (Objects.isNull(this.textExtractor)) {
            this.textExtractor = new TextExtractor(this.document);
        }
        return this.textExtractor.extractByTable(wordSeparator, regionArea, pageIndexes);
    }

    public Map<Integer, List<BufferedImage>> extractImage(int ... pageIndexes) {
        if (Objects.isNull(this.imageExtractor)) {
            this.imageExtractor = new ImageExtractor(this.document);
        }
        return this.imageExtractor.extract(pageIndexes);
    }

    public Map<String, String> extractFormText() {
        if (Objects.isNull(this.formExtractor)) {
            this.formExtractor = new FormExtractor(this.document);
        }
        return this.formExtractor.extractText();
    }

    public Map<String, BufferedImage> extractFormImage() {
        if (Objects.isNull(this.formExtractor)) {
            this.formExtractor = new FormExtractor(this.document);
        }
        return this.formExtractor.extractImage();
    }

    public Map<String, PDField> extractFormField() {
        if (Objects.isNull(this.formExtractor)) {
            this.formExtractor = new FormExtractor(this.document);
        }
        return this.formExtractor.extractField();
    }

    public Map<Integer, List<String>> extractComment(int ... pageIndexes) {
        return this.extractCommentByRegex(null, pageIndexes);
    }

    public Map<Integer, List<String>> extractCommentByRegex(String regex, int ... pageIndexes) {
        if (Objects.isNull(this.commentExtractor)) {
            this.commentExtractor = new CommentExtractor(this.document);
        }
        return this.commentExtractor.extract(regex, pageIndexes);
    }

    public Map<Integer, PDOutlineItem> extractBookmark(int ... bookmarkIndexes) {
        if (Objects.isNull(this.bookmarkExtractor)) {
            this.bookmarkExtractor = new BookmarkExtractor(this.document);
        }
        return this.bookmarkExtractor.extract(bookmarkIndexes);
    }

    @Override
    public void close() {
        this.textExtractor = null;
        this.imageExtractor = null;
        this.formExtractor = null;
        this.commentExtractor = null;
        this.bookmarkExtractor = null;
    }

    public void setTextExtractor(AbstractTextExtractor textExtractor) {
        this.textExtractor = textExtractor;
    }

    public void setImageExtractor(AbstractImageExtractor imageExtractor) {
        this.imageExtractor = imageExtractor;
    }

    public void setFormExtractor(AbstractFormExtractor formExtractor) {
        this.formExtractor = formExtractor;
    }

    public void setCommentExtractor(AbstractCommentExtractor commentExtractor) {
        this.commentExtractor = commentExtractor;
    }

    public void setBookmarkExtractor(AbstractBookmarkExtractor bookmarkExtractor) {
        this.bookmarkExtractor = bookmarkExtractor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentExtractor)) {
            return false;
        }
        DocumentExtractor other = (DocumentExtractor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractTextExtractor this$textExtractor = this.textExtractor;
        AbstractTextExtractor other$textExtractor = other.textExtractor;
        if (this$textExtractor == null ? other$textExtractor != null : !this$textExtractor.equals(other$textExtractor)) {
            return false;
        }
        AbstractImageExtractor this$imageExtractor = this.imageExtractor;
        AbstractImageExtractor other$imageExtractor = other.imageExtractor;
        if (this$imageExtractor == null ? other$imageExtractor != null : !this$imageExtractor.equals(other$imageExtractor)) {
            return false;
        }
        AbstractFormExtractor this$formExtractor = this.formExtractor;
        AbstractFormExtractor other$formExtractor = other.formExtractor;
        if (this$formExtractor == null ? other$formExtractor != null : !this$formExtractor.equals(other$formExtractor)) {
            return false;
        }
        AbstractCommentExtractor this$commentExtractor = this.commentExtractor;
        AbstractCommentExtractor other$commentExtractor = other.commentExtractor;
        if (this$commentExtractor == null ? other$commentExtractor != null : !this$commentExtractor.equals(other$commentExtractor)) {
            return false;
        }
        AbstractBookmarkExtractor this$bookmarkExtractor = this.bookmarkExtractor;
        AbstractBookmarkExtractor other$bookmarkExtractor = other.bookmarkExtractor;
        return !(this$bookmarkExtractor == null ? other$bookmarkExtractor != null : !this$bookmarkExtractor.equals(other$bookmarkExtractor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocumentExtractor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AbstractTextExtractor $textExtractor = this.textExtractor;
        result = result * 59 + ($textExtractor == null ? 43 : $textExtractor.hashCode());
        AbstractImageExtractor $imageExtractor = this.imageExtractor;
        result = result * 59 + ($imageExtractor == null ? 43 : $imageExtractor.hashCode());
        AbstractFormExtractor $formExtractor = this.formExtractor;
        result = result * 59 + ($formExtractor == null ? 43 : $formExtractor.hashCode());
        AbstractCommentExtractor $commentExtractor = this.commentExtractor;
        result = result * 59 + ($commentExtractor == null ? 43 : $commentExtractor.hashCode());
        AbstractBookmarkExtractor $bookmarkExtractor = this.bookmarkExtractor;
        result = result * 59 + ($bookmarkExtractor == null ? 43 : $bookmarkExtractor.hashCode());
        return result;
    }
}

