/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.extractor;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.pdfbox.text.PDFTextStripper;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.extractor.AbstractTextExtractor;

public class TextExtractor
extends AbstractTextExtractor {
    public TextExtractor(Document document) {
        super(document);
    }

    @Override
    public Map<Integer, List<String>> extractByRegex(String regex, int ... pageIndexes) {
        HashMap<Integer, List<String>> data = new HashMap<Integer, List<String>>(32);
        PDFTextStripper stripper = new PDFTextStripper();
        if (Objects.nonNull(pageIndexes) && pageIndexes.length > 0) {
            for (int index : pageIndexes) {
                stripper.setStartPage(index + 1);
                stripper.setEndPage(index + 1);
                data.put(index, this.processTextByRegex(regex, stripper));
            }
        } else {
            for (int index = 0; index < this.getDocument().getNumberOfPages(); ++index) {
                stripper.setStartPage(index + 1);
                stripper.setEndPage(index + 1);
                data.put(index, this.processTextByRegex(regex, stripper));
            }
        }
        return data;
    }

    @Override
    public Map<Integer, Map<String, String>> extractByRegionArea(String wordSeparator, Map<String, Rectangle> regionArea, int ... pageIndexes) {
        return this.extractText(this::processTextByRegionArea, wordSeparator, regionArea, pageIndexes);
    }

    @Override
    public Map<Integer, Map<String, List<List<String>>>> extractByTable(String wordSeparator, Map<String, Rectangle> regionArea, int ... pageIndexes) {
        return this.extractText(this::processTextByTable, wordSeparator, regionArea, pageIndexes);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextExtractor)) {
            return false;
        }
        TextExtractor other = (TextExtractor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof TextExtractor;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

