/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;

public class MergeProcessor
extends AbstractProcessor {
    public MergeProcessor(Document document) {
        super(document);
    }

    public void merge(List<Document> documents) {
        this.merge(documents.toArray(new Document[0]));
    }

    public void merge(Document ... documents) {
        Objects.requireNonNull(documents, "the documents can not be null");
        for (Document document : documents) {
            this.importPage(this.getDocument(), document.getTarget());
        }
    }

    protected void importPage(PDDocument target, PDDocument source) {
        PDPageTree pageTree = source.getPages();
        for (PDPage sourcePage : pageTree) {
            PDPage importPage = target.importPage(sourcePage);
            importPage.setResources(sourcePage.getResources());
            this.document.getPages().add(new Page(this.document, sourcePage));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MergeProcessor)) {
            return false;
        }
        MergeProcessor other = (MergeProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof MergeProcessor;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

