/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PageSize;
import org.dromara.pdf.pdfbox.core.enums.RotationAngle;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;

public class PageProcessor
extends AbstractProcessor {
    public PageProcessor(Document document) {
        super(document);
    }

    public List<Page> getPages() {
        return this.document.getPages();
    }

    public void insert(int index, Page page) {
        Objects.requireNonNull(page, "the page can not be null");
        try {
            this.document.getPages().add(index, page);
            while (true) {
                ++index;
                if (!Objects.isNull(page = page.getSubPage())) {
                    this.document.getPages().add(index, page);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
        }
    }

    public void append(Page page) {
        Objects.requireNonNull(page, "the page can not be null");
        this.document.getPages().add(page);
        while (!Objects.isNull(page = page.getSubPage())) {
            this.document.getPages().add(page);
        }
    }

    public void set(int index, Page page) {
        Objects.requireNonNull(page, "the page can not be null");
        try {
            this.document.getPages().set(index, page);
            while (true) {
                ++index;
                if (!Objects.isNull(page = page.getSubPage())) {
                    this.document.getPages().add(index, page);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
        }
    }

    public void remove(int ... indexes) {
        Objects.requireNonNull(indexes, "the indexes can not be null");
        ArrayList<Page> temp = new ArrayList<Page>(this.document.getPages());
        for (int index : indexes) {
            try {
                this.document.getPages().remove(temp.get(index));
            }
            catch (Exception e) {
                this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
            }
        }
    }

    public void restructure(int ... indexes) {
        Objects.requireNonNull(indexes, "the indexes can not be null");
        List<Page> pages = this.document.getPages();
        ArrayList<Page> newPages = new ArrayList<Page>(indexes.length);
        for (int index : indexes) {
            try {
                newPages.add(pages.get(index));
            }
            catch (Exception e) {
                this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
            }
        }
        this.document.setPages(newPages);
    }

    public void resort(int ... indexes) {
        Objects.requireNonNull(indexes, "the indexes can not be null");
        List<Page> pages = this.document.getPages();
        ArrayList<Page> orderPages = new ArrayList<Page>(pages.size());
        for (int index : indexes) {
            try {
                orderPages.add(pages.remove(index));
            }
            catch (Exception e) {
                this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
            }
        }
        orderPages.addAll(pages);
        this.document.setPages(orderPages);
    }

    public void rotation(RotationAngle angle, int ... pageIndexes) {
        Objects.requireNonNull(angle, "the rotation angle can not be null");
        List<Page> pages = this.getPages();
        if (Objects.nonNull(pageIndexes) && pageIndexes.length > 0) {
            for (int index : pageIndexes) {
                try {
                    pages.get(index).rotation(angle);
                }
                catch (Exception e) {
                    this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
                }
            }
        } else {
            for (Page page : pages) {
                page.rotation(angle);
            }
        }
    }

    public void scale(PageSize rectangle, int ... pageIndexes) {
        Objects.requireNonNull(rectangle, "the rectangle can not be null");
        List<Page> pages = this.document.getPages();
        if (Objects.nonNull(pageIndexes) && pageIndexes.length > 0) {
            for (int index : pageIndexes) {
                try {
                    pages.get(index).scale(rectangle);
                }
                catch (Exception e) {
                    this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
                }
            }
        } else {
            for (Page page : pages) {
                page.scale(rectangle);
            }
        }
    }

    public void crop(PageSize rectangle, int ... pageIndexes) {
        Objects.requireNonNull(rectangle, "the rectangle can not be null");
        List<Page> pages = this.document.getPages();
        if (Objects.nonNull(pageIndexes) && pageIndexes.length > 0) {
            for (int index : pageIndexes) {
                try {
                    pages.get(index).crop(rectangle);
                }
                catch (Exception e) {
                    this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
                }
            }
        } else {
            for (Page page : pages) {
                page.crop(rectangle);
            }
        }
    }

    public void resetSize() {
        this.document.getPages().forEach(Page::resetRectangle);
    }

    public void flush() {
        for (int i = 0; i < this.document.getPages().size(); ++i) {
            this.document.getPages().get(i).setIndex(i);
        }
        PDPageTree pageTree = this.getDocument().getPages();
        pageTree.forEach(arg_0 -> ((PDPageTree)pageTree).remove(arg_0));
        this.document.getPages().forEach(page -> this.getDocument().addPage(page.getTarget()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageProcessor)) {
            return false;
        }
        PageProcessor other = (PageProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageProcessor;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

