/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.util;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.core.base.BorderData;
import org.dromara.pdf.pdfbox.core.base.Context;

public class BorderUtil {
    public static void drawBorderWithData(BorderData data, PDRectangle rectangle) {
        Context context = data.getContext();
        PDPageContentStream stream = new PDPageContentStream(context.getTargetDocument(), context.getTargetPage(), data.getContentMode().getMode(), true, data.getIsResetContentStream().booleanValue());
        BorderUtil.drawNormalBorder(stream, rectangle, data);
        stream.close();
    }

    public static void drawNormalBorder(PDPageContentStream stream, PDRectangle rectangle, BorderData data) {
        stream.setLineWidth(data.getBorderLineWidth().floatValue());
        stream.setLineCapStyle(data.getBorderLineCapStyle().getType());
        BorderUtil.line(stream, rectangle, data);
    }

    private static void line(PDPageContentStream stream, PDRectangle rectangle, BorderData data) {
        switch (data.getBorderLineStyle()) {
            case SOLID: {
                BorderUtil.drawSolidLine(stream, rectangle, data);
                break;
            }
            case DOTTED: {
                BorderUtil.drawDottedLine(stream, rectangle, data);
            }
        }
    }

    private static void drawSolidLine(PDPageContentStream stream, PDRectangle rectangle, BorderData data) {
        if (data.getIsBorderTop().booleanValue()) {
            stream.setStrokingColor(data.getBorderTopColor());
            stream.moveTo(rectangle.getLowerLeftX(), rectangle.getUpperRightY());
            stream.lineTo(rectangle.getUpperRightX(), rectangle.getUpperRightY());
            stream.stroke();
        }
        if (data.getIsBorderBottom().booleanValue()) {
            stream.setStrokingColor(data.getBorderBottomColor());
            stream.moveTo(rectangle.getLowerLeftX(), rectangle.getLowerLeftY());
            stream.lineTo(rectangle.getUpperRightX(), rectangle.getLowerLeftY());
            stream.stroke();
        }
        if (data.getIsBorderLeft().booleanValue()) {
            stream.setStrokingColor(data.getBorderLeftColor());
            stream.moveTo(rectangle.getLowerLeftX(), rectangle.getLowerLeftY());
            stream.lineTo(rectangle.getLowerLeftX(), rectangle.getUpperRightY());
            stream.stroke();
        }
        if (data.getIsBorderRight().booleanValue()) {
            stream.setStrokingColor(data.getBorderRightColor());
            stream.moveTo(rectangle.getUpperRightX(), rectangle.getLowerLeftY());
            stream.lineTo(rectangle.getUpperRightX(), rectangle.getUpperRightY());
            stream.stroke();
        }
    }

    private static void drawDottedLine(PDPageContentStream stream, PDRectangle rectangle, BorderData data) {
        if (data.getIsBorderTop().booleanValue()) {
            BorderUtil.drawDottedLine(stream, data.getBorderTopColor(), data.getBorderLineWidth().floatValue(), data.getBorderDottedSpacing().floatValue(), rectangle.getLowerLeftX(), rectangle.getUpperRightY(), rectangle.getUpperRightX(), rectangle.getUpperRightY());
        }
        if (data.getIsBorderBottom().booleanValue()) {
            BorderUtil.drawDottedLine(stream, data.getBorderBottomColor(), data.getBorderLineWidth().floatValue(), data.getBorderDottedSpacing().floatValue(), rectangle.getLowerLeftX(), rectangle.getLowerLeftY(), rectangle.getUpperRightX(), rectangle.getLowerLeftY());
        }
        if (data.getIsBorderLeft().booleanValue()) {
            BorderUtil.drawDottedLine(stream, data.getBorderLeftColor(), data.getBorderLineWidth().floatValue(), data.getBorderDottedSpacing().floatValue(), rectangle.getLowerLeftX(), rectangle.getUpperRightY(), rectangle.getLowerLeftX(), rectangle.getLowerLeftY());
        }
        if (data.getIsBorderRight().booleanValue()) {
            BorderUtil.drawDottedLine(stream, data.getBorderRightColor(), data.getBorderLineWidth().floatValue(), data.getBorderDottedSpacing().floatValue(), rectangle.getUpperRightX(), rectangle.getUpperRightY(), rectangle.getUpperRightX(), rectangle.getLowerLeftY());
        }
    }

    private static void drawDottedLine(PDPageContentStream contentStream, Color color, float dottedLength, float dottedSpacing, float beginX, float beginY, float endX, float endY) {
        boolean isHorizontal;
        contentStream.setStrokingColor(color);
        float totalLength = endX - beginX;
        boolean bl = isHorizontal = totalLength > 0.0f;
        if (!isHorizontal) {
            totalLength = beginY - endY;
        }
        float lineWidth = dottedLength + dottedSpacing;
        int count = Math.max((int)(totalLength / lineWidth), 1);
        float offset = Math.abs((totalLength - (float)count * lineWidth + dottedSpacing) / 2.0f);
        if (dottedLength > totalLength) {
            dottedLength = totalLength;
            offset = 0.0f;
        }
        if (isHorizontal) {
            beginX += offset;
        } else {
            beginY -= offset;
        }
        for (int i = 0; i < count; ++i) {
            contentStream.moveTo(beginX, beginY);
            if (isHorizontal) {
                contentStream.lineTo(beginX, beginY);
                beginX = beginX + dottedLength + dottedSpacing;
                continue;
            }
            contentStream.lineTo(beginX, beginY);
            beginY = beginY - dottedLength - dottedSpacing;
        }
        contentStream.stroke();
    }
}

