/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.enums.ContentMode;
import org.dromara.pdf.pdfbox.core.enums.FontStyle;

public class CommonUtil {
    public static void initFontColorAndAlpha(PDPageContentStream stream, Color backgroundColor, FontStyle fontStyle, Color fontColor, float fontAlpha) {
        PDExtendedGraphicsState state = new PDExtendedGraphicsState();
        stream.setGraphicsStateParameters(state);
        if (fontStyle.isFill()) {
            stream.setNonStrokingColor(fontColor);
            state.setNonStrokingAlphaConstant(Float.valueOf(fontAlpha));
        }
        if (fontStyle.isStroke()) {
            stream.setStrokingColor(fontColor);
            state.setStrokingAlphaConstant(Float.valueOf(fontAlpha));
        }
        if (fontStyle.isLight()) {
            stream.setStrokingColor(backgroundColor);
            stream.setNonStrokingColor(fontColor);
            state.setNonStrokingAlphaConstant(Float.valueOf(fontAlpha));
        }
    }

    public static void initMatrix(PDPageContentStream stream, float beginX, float beginY, float relativeBeginX, float relativeBeginY, float width, float height, float angle, float alpha) {
        float offsetX = 0.5f * width;
        float offsetY = 0.5f * height;
        stream.saveGraphicsState();
        PDExtendedGraphicsState state = new PDExtendedGraphicsState();
        state.setNonStrokingAlphaConstant(Float.valueOf(alpha));
        stream.setGraphicsStateParameters(state);
        stream.transform(Matrix.getTranslateInstance((float)(beginX + relativeBeginX + offsetX), (float)(beginY - relativeBeginY + offsetY)));
        stream.transform(Matrix.getRotateInstance((double)Math.toRadians(angle), (float)0.0f, (float)0.0f));
        stream.transform(Matrix.getTranslateInstance((float)(-offsetX), (float)(-offsetY)));
    }

    public static void extractImage(List<BufferedImage> imageList, PDResources resources) {
        Iterable objectNames = resources.getXObjectNames();
        for (COSName objectName : objectNames) {
            PDXObject xObject = resources.getXObject(objectName);
            if (xObject instanceof PDImage) {
                imageList.add(((PDImage)xObject).getImage());
                continue;
            }
            if (!(xObject instanceof PDFormXObject)) continue;
            CommonUtil.extractImage(imageList, ((PDFormXObject)xObject).getResources());
        }
    }

    public static void addBackgroundColor(Context context, ContentMode mode, boolean isResetContentStream, PDRectangle rectangle, Color backgroundColor) {
        if (Objects.nonNull(backgroundColor)) {
            PDPageContentStream stream = new PDPageContentStream(context.getTargetDocument(), context.getTargetPage(), mode.getMode(), true, isResetContentStream);
            stream.addRect(rectangle);
            stream.setNonStrokingColor(backgroundColor);
            stream.fill();
            stream.close();
        }
    }

    public static PDRectangle getRectangle(float width, float height) {
        PDRectangle rectangle = new PDRectangle();
        rectangle.setLowerLeftX(0.0f);
        rectangle.setUpperRightX(width);
        rectangle.setLowerLeftY(0.0f);
        rectangle.setUpperRightY(height);
        return rectangle;
    }

    public static int[] toIntArray(List<Integer> list) {
        return list.stream().mapToInt(Integer::intValue).toArray();
    }

    public static float[] toFloatArray(List<Float> list) {
        float[] array = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i).floatValue();
        }
        return array;
    }

    public static double[] toDoubleArray(List<Double> list) {
        return list.stream().mapToDouble(Double::doubleValue).toArray();
    }
}

