/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.io.RandomAccessStreamCache;
import org.apache.pdfbox.pdfwriter.compress.CompressParameters;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.ResourceCache;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyRecipient;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.pdfbox.core.base.AbstractBase;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.MemoryPolicy;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.config.FontConfiguration;
import org.dromara.pdf.pdfbox.core.base.config.MarginConfiguration;
import org.dromara.pdf.pdfbox.core.enums.FontStyle;
import org.dromara.pdf.pdfbox.core.enums.PWLength;
import org.dromara.pdf.pdfbox.core.ext.processor.MetadataProcessor;
import org.dromara.pdf.pdfbox.core.ext.processor.PageProcessor;
import org.dromara.pdf.pdfbox.core.info.CatalogInfo;
import org.dromara.pdf.pdfbox.support.Constants;
import org.dromara.pdf.pdfbox.support.DefaultResourceCache;
import org.dromara.pdf.pdfbox.util.FileUtil;

public class Document
extends AbstractBase
implements Closeable {
    protected MarginConfiguration marginConfiguration;
    protected FontConfiguration fontConfiguration;
    protected Color backgroundColor;
    protected PDDocument target;
    protected List<Page> pages;
    protected AccessPermission accessPermission;
    protected Float version;
    protected Integer totalPageNumber;
    protected Boolean isFlushMetadata;

    public Document() {
        this.init();
    }

    public Document(MemoryPolicy policy) {
        Objects.requireNonNull(policy, "the policy can not be null");
        this.init(policy);
    }

    public Document(File file, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        this.init(file, password, keyStore, alias, policy);
    }

    public Document(byte[] bytes, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        this.init(bytes, password, keyStore, alias, policy);
    }

    public Document(InputStream inputStream, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        this.init(inputStream, password, keyStore, alias, policy);
    }

    public void setVersion(float version) {
        float maxVersion = 1.7f;
        float minVersion = 1.0f;
        if (version < minVersion || version > maxVersion) {
            throw new IllegalArgumentException("the version must be between 1.0 and 1.7");
        }
        this.version = Float.valueOf(version);
    }

    public void setResourceCache(ResourceCache cache) {
        Objects.requireNonNull(cache, "the cache can not be null");
        this.target.setResourceCache(cache);
    }

    public void setMargin(float margin) {
        this.marginConfiguration.setMargin(margin);
    }

    public void setMarginTop(float margin) {
        this.marginConfiguration.setMarginTop(margin);
    }

    public void setMarginBottom(float margin) {
        this.marginConfiguration.setMarginBottom(margin);
    }

    public void setMarginLeft(float margin) {
        this.marginConfiguration.setMarginLeft(margin);
    }

    public void setMarginRight(float margin) {
        this.marginConfiguration.setMarginRight(margin);
    }

    public void setFontName(String fontName) {
        this.fontConfiguration.setFontName(fontName);
        this.getContext().addFontCache(fontName);
    }

    public void setSpecialFontNames(String ... fontNames) {
        this.getContext().addFontCache(fontNames);
        if (Objects.isNull(this.fontConfiguration.getSpecialFontNames())) {
            this.fontConfiguration.setSpecialFontNames(new ArrayList<String>(10));
        }
        Collections.addAll(this.fontConfiguration.getSpecialFontNames(), fontNames);
    }

    public void setFontSize(float size) {
        this.fontConfiguration.setFontSize(size);
    }

    public void setFontColor(Color color) {
        this.fontConfiguration.setFontColor(color);
    }

    public void setStrokColor(Color color) {
        this.fontConfiguration.setStrokColor(color);
    }

    public void setFontAlpha(float alpha) {
        this.fontConfiguration.setFontAlpha(Float.valueOf(alpha));
    }

    public void setFontStyle(FontStyle style) {
        this.fontConfiguration.setFontStyle(style);
        if (Objects.nonNull((Object)style)) {
            if (style.isItalic()) {
                this.fontConfiguration.setFontSlope(Constants.DEFAULT_FONT_ITALIC_SLOPE);
            } else {
                this.fontConfiguration.setFontSlope(Constants.DEFAULT_FONT_SLOPE);
            }
        }
    }

    public void setFontSlope(float slope) {
        this.fontConfiguration.setFontSlope(Float.valueOf(slope));
    }

    public void setCharacterSpacing(float spacing) {
        this.fontConfiguration.setCharacterSpacing(spacing);
    }

    public void setLeading(float leading) {
        this.fontConfiguration.setLeading(leading);
    }

    public PDFont getFont() {
        return this.getContext().getFont(this.fontConfiguration.getFontName());
    }

    public Float getMarginTop() {
        return this.marginConfiguration.getMarginTop();
    }

    public Float getMarginBottom() {
        return this.marginConfiguration.getMarginBottom();
    }

    public Float getMarginLeft() {
        return this.marginConfiguration.getMarginLeft();
    }

    public Float getMarginRight() {
        return this.marginConfiguration.getMarginRight();
    }

    public String getFontName() {
        return this.fontConfiguration.getFontName();
    }

    public List<String> getSpecialFontNames() {
        return this.fontConfiguration.getSpecialFontNames();
    }

    public Float getFontSize() {
        return this.fontConfiguration.getFontSize();
    }

    public Color getFontColor() {
        return this.fontConfiguration.getFontColor();
    }

    public Color getStrokColor() {
        return this.fontConfiguration.getStrokColor();
    }

    public Float getFontAlpha() {
        return this.fontConfiguration.getFontAlpha();
    }

    public FontStyle getFontStyle() {
        return this.fontConfiguration.getFontStyle();
    }

    public Float getFontSlope() {
        return this.fontConfiguration.getFontSlope();
    }

    public Float getCharacterSpacing() {
        return this.fontConfiguration.getCharacterSpacing();
    }

    public Float getLeading() {
        return this.fontConfiguration.getLeading();
    }

    public int getTotalPageNumber() {
        return Optional.ofNullable(this.totalPageNumber).orElse(this.context.getPageCount());
    }

    public Page getCurrentPage() {
        return this.getContext().getPage();
    }

    public Page getPage(int index) {
        if (Objects.isNull(this.pages) || this.pages.size() <= index) {
            return null;
        }
        return this.pages.get(index);
    }

    public List<CatalogInfo> getCatalogs() {
        return this.getContext().getCatalogs();
    }

    public void encryption() {
        this.encryption(false, PWLength.LENGTH_40, "", "");
    }

    public void encryption(boolean preferAES, PWLength length, String ownerPassword, String userPassword) {
        StandardProtectionPolicy policy = new StandardProtectionPolicy(ownerPassword, userPassword, this.getAccessPermission());
        policy.setPreferAES(preferAES);
        policy.setEncryptionKeyLength(Optional.ofNullable(length).orElse(PWLength.LENGTH_40).getLength());
        this.getTarget().protect((ProtectionPolicy)policy);
    }

    public void encryption(InputStream certificateInputStream) {
        PublicKeyRecipient recipient = new PublicKeyRecipient();
        recipient.setPermission(this.getAccessPermission());
        recipient.setX509((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(certificateInputStream));
        PublicKeyProtectionPolicy policy = new PublicKeyProtectionPolicy();
        policy.addRecipient(recipient);
        this.getTarget().protect((ProtectionPolicy)policy);
    }

    public void decrypt() {
        this.getTarget().setAllSecurityToBeRemoved(true);
    }

    public void insertPage(int index, Page page) {
        PageProcessor processor = new PageProcessor(this);
        processor.insert(index, page);
        processor.flush();
    }

    public void appendPage(Page ... pages) {
        PageProcessor processor = new PageProcessor(this);
        for (Page page : pages) {
            processor.append(page);
        }
        processor.flush();
    }

    public void appendPage(List<Page> pages) {
        this.appendPage(pages.toArray(new Page[0]));
    }

    public void setPage(int index, Page page) {
        PageProcessor processor = new PageProcessor(this);
        processor.set(index, page);
        processor.flush();
    }

    public void save(File file) {
        Objects.requireNonNull(file, "the file can not be null");
        this.save(file.getAbsolutePath());
    }

    public void saveAndClose(File file) {
        Objects.requireNonNull(file, "the file can not be null");
        this.saveAndClose(file.getAbsolutePath());
    }

    public void save(String path) {
        Objects.requireNonNull(path, "the path can not be null");
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(FileUtil.createDirectories(Paths.get(path, new String[0])), new OpenOption[0]));){
            this.save(outputStream);
        }
    }

    public void saveAndClose(String path) {
        Objects.requireNonNull(path, "the path can not be null");
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(FileUtil.createDirectories(Paths.get(path, new String[0])), new OpenOption[0]));){
            this.saveAndClose(outputStream);
        }
    }

    public void save(OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "the output stream can not be null");
        int number = this.getTarget().getNumberOfPages();
        if (number == 0) {
            this.log.error((Object)"the document has no page, please add a page before saving");
        }
        if (Optional.ofNullable(this.getIsFlushMetadata()).orElse(Boolean.TRUE).booleanValue()) {
            MetadataProcessor processor = new MetadataProcessor(this);
            processor.flush();
        }
        this.getTarget().setVersion(this.getVersion().floatValue());
        this.getTarget().save(outputStream, new CompressParameters(number));
    }

    public void saveAndClose(OutputStream outputStream) {
        this.save(outputStream);
        this.close();
    }

    @Override
    public void close() {
        this.getPages().forEach(Page::close);
        this.getContext().clear();
        try {
            this.getTarget().close();
        }
        catch (Exception e) {
            this.log.warn((Object)"an error occurred when the document was closed", (Throwable)e);
        }
    }

    public void initBase() {
        super.init(new Context(this));
        this.marginConfiguration = new MarginConfiguration();
        this.fontConfiguration = new FontConfiguration();
        this.initOtherParams();
    }

    protected void init() {
        this.init(MemoryPolicy.setupMainMemoryOnly());
    }

    protected void init(MemoryPolicy policy) {
        this.target = new PDDocument(policy.getSetting().streamCache);
        this.target.setVersion(Constants.DEFAULT_VERSION.floatValue());
        this.target.setResourceCache(new DefaultResourceCache());
        this.initBase();
        this.initPages();
    }

    protected void init(File file, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        Objects.requireNonNull(policy, "the policy can not be null");
        this.target = Loader.loadPDF((File)file, (String)password, (InputStream)keyStore, (String)alias, (RandomAccessStreamCache.StreamCacheCreateFunction)policy.getSetting().streamCache);
        this.initLoad();
    }

    protected void init(byte[] bytes, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        this.initLoad(new RandomAccessReadBuffer(bytes), password, keyStore, alias, policy);
    }

    protected void init(InputStream inputStream, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        this.initLoad(new RandomAccessReadBuffer(inputStream), password, keyStore, alias, policy);
    }

    protected void initLoad(RandomAccessReadBuffer buffer, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        Objects.requireNonNull(policy, "the policy can not be null");
        this.target = Loader.loadPDF((RandomAccessRead)buffer, (String)password, (InputStream)keyStore, (String)alias, (RandomAccessStreamCache.StreamCacheCreateFunction)policy.getSetting().streamCache);
        this.initLoad();
    }

    protected void initLoad() {
        this.target.setResourceCache(new DefaultResourceCache());
        this.initBase();
        this.initPages();
    }

    protected void initPages() {
        int count = this.getTarget().getNumberOfPages();
        this.pages = new ArrayList<Page>(this.getTarget().getNumberOfPages());
        PDPageTree pageTree = this.getTarget().getPages();
        for (int i = 0; i < count; ++i) {
            this.pages.add(new Page(this, pageTree.get(i)));
        }
    }

    protected void initOtherParams() {
        this.accessPermission = this.target.getCurrentAccessPermission();
        this.version = Float.valueOf(this.target.getVersion());
        this.isFlushMetadata = Boolean.TRUE;
        this.backgroundColor = Color.WHITE;
        this.context.addFontCache(this.fontConfiguration.getFontName());
        if (Objects.nonNull(this.fontConfiguration.getSpecialFontNames())) {
            for (String specialFontName : this.fontConfiguration.getSpecialFontNames()) {
                this.getContext().addFontCache(specialFontName);
            }
        }
    }

    public MarginConfiguration getMarginConfiguration() {
        return this.marginConfiguration;
    }

    public FontConfiguration getFontConfiguration() {
        return this.fontConfiguration;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public PDDocument getTarget() {
        return this.target;
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public AccessPermission getAccessPermission() {
        return this.accessPermission;
    }

    public Float getVersion() {
        return this.version;
    }

    public Boolean getIsFlushMetadata() {
        return this.isFlushMetadata;
    }

    public void setMarginConfiguration(MarginConfiguration marginConfiguration) {
        this.marginConfiguration = marginConfiguration;
    }

    public void setFontConfiguration(FontConfiguration fontConfiguration) {
        this.fontConfiguration = fontConfiguration;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setTarget(PDDocument target) {
        this.target = target;
    }

    public void setPages(List<Page> pages) {
        this.pages = pages;
    }

    public void setAccessPermission(AccessPermission accessPermission) {
        this.accessPermission = accessPermission;
    }

    public void setTotalPageNumber(Integer totalPageNumber) {
        this.totalPageNumber = totalPageNumber;
    }

    public void setIsFlushMetadata(Boolean isFlushMetadata) {
        this.isFlushMetadata = isFlushMetadata;
    }

    @Override
    public String toString() {
        return "Document(marginConfiguration=" + this.getMarginConfiguration() + ", fontConfiguration=" + this.getFontConfiguration() + ", backgroundColor=" + this.getBackgroundColor() + ", target=" + this.getTarget() + ", pages=" + this.getPages() + ", accessPermission=" + this.getAccessPermission() + ", version=" + this.getVersion() + ", totalPageNumber=" + this.getTotalPageNumber() + ", isFlushMetadata=" + this.getIsFlushMetadata() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document other = (Document)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$version = this.getVersion();
        Float other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        if (this.getTotalPageNumber() != other.getTotalPageNumber()) {
            return false;
        }
        Boolean this$isFlushMetadata = this.getIsFlushMetadata();
        Boolean other$isFlushMetadata = other.getIsFlushMetadata();
        if (this$isFlushMetadata == null ? other$isFlushMetadata != null : !((Object)this$isFlushMetadata).equals(other$isFlushMetadata)) {
            return false;
        }
        MarginConfiguration this$marginConfiguration = this.getMarginConfiguration();
        MarginConfiguration other$marginConfiguration = other.getMarginConfiguration();
        if (this$marginConfiguration == null ? other$marginConfiguration != null : !((Object)this$marginConfiguration).equals(other$marginConfiguration)) {
            return false;
        }
        FontConfiguration this$fontConfiguration = this.getFontConfiguration();
        FontConfiguration other$fontConfiguration = other.getFontConfiguration();
        if (this$fontConfiguration == null ? other$fontConfiguration != null : !((Object)this$fontConfiguration).equals(other$fontConfiguration)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        PDDocument this$target = this.getTarget();
        PDDocument other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        List<Page> this$pages = this.getPages();
        List<Page> other$pages = other.getPages();
        if (this$pages == null ? other$pages != null : !((Object)this$pages).equals(other$pages)) {
            return false;
        }
        AccessPermission this$accessPermission = this.getAccessPermission();
        AccessPermission other$accessPermission = other.getAccessPermission();
        return !(this$accessPermission == null ? other$accessPermission != null : !this$accessPermission.equals(other$accessPermission));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Document;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        result = result * 59 + this.getTotalPageNumber();
        Boolean $isFlushMetadata = this.getIsFlushMetadata();
        result = result * 59 + ($isFlushMetadata == null ? 43 : ((Object)$isFlushMetadata).hashCode());
        MarginConfiguration $marginConfiguration = this.getMarginConfiguration();
        result = result * 59 + ($marginConfiguration == null ? 43 : ((Object)$marginConfiguration).hashCode());
        FontConfiguration $fontConfiguration = this.getFontConfiguration();
        result = result * 59 + ($fontConfiguration == null ? 43 : ((Object)$fontConfiguration).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        PDDocument $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        List<Page> $pages = this.getPages();
        result = result * 59 + ($pages == null ? 43 : ((Object)$pages).hashCode());
        AccessPermission $accessPermission = this.getAccessPermission();
        result = result * 59 + ($accessPermission == null ? 43 : $accessPermission.hashCode());
        return result;
    }
}

