/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base;

import java.nio.file.Paths;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.dromara.pdf.pdfbox.support.Constants;

public class MemoryPolicy {
    private final MemoryUsageSetting setting;

    private MemoryPolicy(MemoryUsageSetting setting) {
        this.setting = setting;
    }

    public static MemoryPolicy setupMainMemoryOnly() {
        return new MemoryPolicy(MemoryUsageSetting.setupMainMemoryOnly());
    }

    public static MemoryPolicy setupMainMemoryOnly(long maxMemoryBytes) {
        return new MemoryPolicy(MemoryUsageSetting.setupMainMemoryOnly((long)maxMemoryBytes));
    }

    public static MemoryPolicy setupTempFileOnly() {
        return MemoryPolicy.setupTempFileOnly(Constants.TEMP_FILE_PATH);
    }

    public static MemoryPolicy setupTempFileOnly(String tempPath) {
        return new MemoryPolicy(MemoryUsageSetting.setupTempFileOnly().setTempDir(Paths.get(tempPath, new String[0]).toFile()));
    }

    public static MemoryPolicy setupMix(long maxMemoryBytes, String tempPath) {
        return new MemoryPolicy(MemoryUsageSetting.setupMainMemoryOnly((long)maxMemoryBytes).setTempDir(Paths.get(tempPath, new String[0]).toFile()));
    }

    MemoryUsageSetting getSetting() {
        return this.setting;
    }
}

