/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.dromara.pdf.pdfbox.core.base.AbstractBase;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PagingCondition;
import org.dromara.pdf.pdfbox.core.base.PagingEvent;
import org.dromara.pdf.pdfbox.core.base.config.BorderConfiguration;
import org.dromara.pdf.pdfbox.core.base.config.MarginConfiguration;
import org.dromara.pdf.pdfbox.core.component.Component;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;
import org.dromara.pdf.pdfbox.core.enums.HorizontalAlignment;
import org.dromara.pdf.pdfbox.core.enums.LineCapStyle;
import org.dromara.pdf.pdfbox.core.enums.LineStyle;
import org.dromara.pdf.pdfbox.core.enums.VerticalAlignment;

public abstract class AbstractComponent
extends AbstractBase
implements Component,
Closeable {
    protected MarginConfiguration marginConfiguration;
    protected BorderConfiguration borderConfiguration;
    protected LinkedHashSet<PagingEvent> pagingEvents;
    protected PagingCondition pagingCondition;
    protected Float beginX;
    protected Float beginY;
    protected Float relativeBeginX;
    protected Float relativeBeginY;
    protected Boolean isWrap;
    protected Boolean isBreak;
    protected Boolean isCustomPosition;
    protected HorizontalAlignment horizontalAlignment;
    protected VerticalAlignment verticalAlignment;

    protected abstract float getMinWidth();

    protected AbstractComponent() {
    }

    public AbstractComponent(Page page) {
        Page lastPage = page.getLastPage();
        super.init(lastPage);
        this.context.reset(lastPage);
        this.marginConfiguration = new MarginConfiguration();
        this.borderConfiguration = new BorderConfiguration();
        this.pagingEvents = new LinkedHashSet();
    }

    protected abstract void writeContents();

    protected abstract void reset();

    @Override
    public void setBeginX(Float x) {
        this.setBeginX(x, true);
    }

    @Override
    public void setBeginY(Float y) {
        this.setBeginY(y, true);
    }

    public void setMargin(float margin) {
        this.setMarginTop(margin);
        this.setMarginBottom(margin);
        this.setMarginLeft(margin);
        this.setMarginRight(margin);
    }

    public void setMarginTop(float margin) {
        this.marginConfiguration.setMarginTop(margin);
    }

    public void setMarginBottom(float margin) {
        this.marginConfiguration.setMarginBottom(margin);
    }

    public void setMarginLeft(float margin) {
        this.marginConfiguration.setMarginLeft(margin);
    }

    public void setMarginRight(float margin) {
        this.marginConfiguration.setMarginRight(margin);
    }

    public void setBorderLineStyle(LineStyle style) {
        this.borderConfiguration.setBorderLineStyle(style);
    }

    public void setBorderLineCapStyle(LineCapStyle style) {
        this.borderConfiguration.setBorderLineCapStyle(style);
    }

    public void setBorderLineLength(float length) {
        this.borderConfiguration.setBorderLineLength(length);
    }

    public void setBorderLineWidth(float width) {
        this.borderConfiguration.setBorderLineWidth(width);
    }

    public void setBorderDottedSpacing(float spacing) {
        this.borderConfiguration.setBorderDottedSpacing(spacing);
    }

    public void setBorderColor(Color color) {
        this.borderConfiguration.setBorderColor(color);
    }

    public void setBorderTopColor(Color color) {
        this.borderConfiguration.setBorderTopColor(color);
    }

    public void setBorderBottomColor(Color color) {
        this.borderConfiguration.setBorderBottomColor(color);
    }

    public void setBorderLeftColor(Color color) {
        this.borderConfiguration.setBorderLeftColor(color);
    }

    public void setBorderRightColor(Color color) {
        this.borderConfiguration.setBorderRightColor(color);
    }

    public void setBorderRightColor(boolean flag) {
        this.borderConfiguration.setIsBorderTop(flag);
    }

    public void setIsBorder(boolean flag) {
        this.borderConfiguration.setIsBorder(flag);
    }

    public void setIsBorderTop(boolean flag) {
        this.borderConfiguration.setIsBorderTop(flag);
    }

    public void setIsBorderBottom(boolean flag) {
        this.borderConfiguration.setIsBorderBottom(flag);
    }

    public void setIsBorderLeft(boolean flag) {
        this.borderConfiguration.setIsBorderLeft(flag);
    }

    public void setIsBorderRight(boolean flag) {
        this.borderConfiguration.setIsBorderRight(flag);
    }

    public Float getMarginTop() {
        return this.marginConfiguration.getMarginTop();
    }

    public Float getMarginBottom() {
        return this.marginConfiguration.getMarginBottom();
    }

    public Float getMarginLeft() {
        return this.marginConfiguration.getMarginLeft();
    }

    public Float getMarginRight() {
        return this.marginConfiguration.getMarginRight();
    }

    public LineStyle getBorderLineStyle() {
        return this.borderConfiguration.getBorderLineStyle();
    }

    public LineCapStyle getBorderLineCapStyle() {
        return this.borderConfiguration.getBorderLineCapStyle();
    }

    public Float getBorderLineLength() {
        return this.borderConfiguration.getBorderLineLength();
    }

    public Float getBorderLineWidth() {
        return this.borderConfiguration.getBorderLineWidth();
    }

    public Float getBorderDottedSpacing() {
        return this.borderConfiguration.getBorderDottedSpacing();
    }

    public Color getBorderTopColor() {
        return this.borderConfiguration.getBorderTopColor();
    }

    public Color getBorderBottomColor() {
        return this.borderConfiguration.getBorderBottomColor();
    }

    public Color getBorderLeftColor() {
        return this.borderConfiguration.getBorderLeftColor();
    }

    public Color getBorderRightColor() {
        return this.borderConfiguration.getBorderRightColor();
    }

    public Boolean getIsBorderTop() {
        return this.borderConfiguration.getIsBorderTop();
    }

    public Boolean getIsBorderBottom() {
        return this.borderConfiguration.getIsBorderBottom();
    }

    public Boolean getIsBorderLeft() {
        return this.borderConfiguration.getIsBorderLeft();
    }

    public Boolean getIsBorderRight() {
        return this.borderConfiguration.getIsBorderRight();
    }

    @Override
    public AbstractBase getBase() {
        return this;
    }

    public Page getPage() {
        return this.getContext().getPage();
    }

    @Override
    public float getBottom() {
        return this.getMarginBottom().floatValue() + this.getContext().getPageFooterHeight() + this.getPage().getMarginBottom().floatValue();
    }

    @Override
    public void virtualRender() {
        this.init();
        this.getContext().resetIsVirtualRender(true);
        this.writeContents();
        this.reset();
    }

    @Override
    public void render() {
        this.init();
        this.getContext().resetIsVirtualRender(false);
        this.writeContents();
        this.reset();
    }

    @Override
    public void close() {
        super.setContext(null);
    }

    protected void init() {
        if (Objects.isNull((Object)this.getContext().getExecutingComponentType())) {
            this.getContext().setExecutingComponentType(this.getType());
        }
        if (Objects.nonNull(this.getContext().getPageHeader()) && this.getContext().getExecutingComponentType().isNotPageHeaderOrFooter()) {
            LinkedHashSet<PagingEvent> events = new LinkedHashSet<PagingEvent>();
            events.add(this.getContext().getPageHeader().getPagingEvent());
            events.addAll(this.pagingEvents);
            this.pagingEvents = events;
        }
        if (Objects.nonNull(this.getContext().getPageFooter()) && this.getContext().getExecutingComponentType().isNotPageHeaderOrFooter()) {
            this.pagingEvents.add(this.getContext().getPageFooter().getPagingEvent());
        }
        if (Objects.isNull((Object)this.horizontalAlignment)) {
            this.horizontalAlignment = this.getPage().getHorizontalAlignment();
        }
        if (Objects.isNull((Object)this.verticalAlignment)) {
            this.verticalAlignment = this.getPage().getVerticalAlignment();
        }
        if (Objects.isNull(this.isWrap)) {
            this.isWrap = Boolean.FALSE;
        }
        if (Objects.isNull(this.isBreak)) {
            this.isBreak = Boolean.FALSE;
        }
        if (Objects.isNull(this.isCustomPosition)) {
            this.isCustomPosition = Boolean.FALSE;
        }
        if (Objects.isNull(this.relativeBeginX)) {
            this.relativeBeginX = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.relativeBeginY)) {
            this.relativeBeginY = Float.valueOf(0.0f);
        }
    }

    protected void initBeginX(float width) {
        if (width == 0.0f) {
            return;
        }
        switch (this.getHorizontalAlignment()) {
            case CENTER: {
                float offset = (this.getContext().getWrapWidth().floatValue() - width) / 2.0f;
                this.setBeginX(Float.valueOf(this.getBeginX().floatValue() + offset));
                break;
            }
            case RIGHT: {
                float offset = this.getContext().getWrapWidth().floatValue() - width - this.getMarginRight().floatValue();
                this.setBeginX(Float.valueOf(Math.min(this.getBeginX().floatValue() + offset, this.getContext().getMaxBeginX() - width)));
                break;
            }
        }
    }

    protected void initBeginY(float height) {
        if (height == 0.0f) {
            return;
        }
        float offset = 0.0f;
        switch (this.getVerticalAlignment()) {
            case CENTER: {
                offset = (this.getContext().getHeight().floatValue() - height) / 2.0f;
                break;
            }
            case BOTTOM: {
                offset = this.getContext().getHeight().floatValue() - height - this.getMarginBottom().floatValue();
                break;
            }
        }
        this.setBeginY(Float.valueOf(this.getBeginY().floatValue() - offset), this.getIsCustomPosition());
    }

    protected void initBeginYForPaging(float height) {
        this.initBeginY(height);
        float offsetY = this.getBeginY().floatValue() + (height - this.getContext().getOffsetY().floatValue());
        float maxBeginY = this.getContext().getMaxBeginY() - height;
        this.setBeginY(Float.valueOf(Math.min(maxBeginY, offsetY)), this.getIsCustomPosition());
    }

    protected void initBeginXY(float width, float height) {
        this.checkWrap(height);
        if (this.checkPaging()) {
            this.setIsWrap(true);
            this.wrap(height);
            this.initBeginYForPaging(height);
        } else {
            this.initBeginY(height);
        }
        this.initBeginX(width);
    }

    protected void checkWrap(float wrapHeight) {
        if (Objects.isNull(this.getIsCustomPosition())) {
            this.setIsCustomPosition(Boolean.FALSE);
        }
        if (!this.getIsCustomPosition().booleanValue()) {
            this.wrap(wrapHeight);
        } else {
            if (Objects.isNull(this.getBeginX())) {
                this.setBeginX(Float.valueOf(this.getContext().getCursor().getX().floatValue() + this.getMarginLeft().floatValue()), this.getIsCustomPosition());
            }
            if (Objects.isNull(this.getBeginY())) {
                this.setBeginY(Float.valueOf(this.getContext().getCursor().getY().floatValue() - this.getMarginTop().floatValue()), this.getIsCustomPosition());
            }
        }
    }

    protected void wrap(float wrapHeight) {
        this.setBeginX(Float.valueOf(this.getContext().getCursor().getX().floatValue() + this.getMarginLeft().floatValue()), this.getIsCustomPosition());
        if (this.isWrap()) {
            this.setIsWrap(false);
            this.getContext().resetCursor(Float.valueOf(Optional.ofNullable(this.getContext().getWrapBeginX()).orElse(this.getPage().getMarginLeft()).floatValue() + this.getMarginLeft().floatValue()), Float.valueOf(this.getContext().getCursor().getY().floatValue() - wrapHeight - this.getMarginTop().floatValue()));
            this.setBeginX(this.getContext().getCursor().getX(), this.getIsCustomPosition());
            this.setBeginY(this.getContext().getCursor().getY(), this.getIsCustomPosition());
        } else {
            this.setBeginY(Float.valueOf(this.getContext().getCursor().getY().floatValue() - this.getMarginTop().floatValue()), this.getIsCustomPosition());
        }
    }

    protected boolean isWrap() {
        return this.getIsWrap() != false || this.isNeedWrap();
    }

    protected boolean isNeedWrap() {
        return this.getContext().getIsFirstComponent() != false || this.getContext().getWrapWidth().floatValue() - this.getBeginX().floatValue() < this.getMinWidth();
    }

    protected boolean isPaging(Component component, float beginY) {
        boolean flag;
        boolean bl = flag = this.getIsBreak() != false || this.checkPaging(component, beginY);
        if (flag) {
            this.processBreak();
        }
        return flag;
    }

    protected boolean checkPaging() {
        if (!this.getIsCustomPosition().booleanValue()) {
            return this.isPaging(this, this.getBeginY().floatValue());
        }
        return false;
    }

    protected boolean checkPaging(Component component, float beginY) {
        return (this.checkPaging(beginY) || Optional.ofNullable(this.pagingCondition).map(condition -> condition.isPaging(component, beginY)).orElse(false) != false) && this.isPagingComponent();
    }

    protected boolean checkPaging(float beginY) {
        if (beginY < this.getBottom()) {
            this.getContext().resetOffsetY(Float.valueOf(this.getBottom() - beginY));
            return true;
        }
        return false;
    }

    protected boolean isPagingComponent() {
        return Optional.ofNullable(this.getContext().getExecutingComponentType()).map(ComponentType::isNotPageHeaderOrFooter).orElse(Boolean.FALSE);
    }

    protected void processBreak() {
        Optional.ofNullable(this.pagingEvents).ifPresent(events -> events.forEach(event -> Optional.ofNullable(event).ifPresent(v -> v.before(this))));
        this.executeBreak();
        Optional.ofNullable(this.pagingEvents).ifPresent(events -> events.forEach(event -> Optional.ofNullable(event).ifPresent(v -> v.after(this))));
    }

    protected Page executeBreak() {
        Page subPage = this.getPage().getSubPage();
        if (Objects.isNull(subPage)) {
            if (!this.getContext().getIsAlreadyPaging().booleanValue()) {
                subPage = this.getPage().createSubPage();
            }
        } else {
            this.getContext().setPage(subPage);
            this.getContext().resetCursor();
        }
        this.setIsBreak(false);
        this.resetXY();
        return subPage;
    }

    protected void reset(ComponentType type, float x, float y) {
        this.resetXY();
        Context context = this.getContext();
        context.resetWrapBeginX(null);
        context.resetCursor(Float.valueOf(x), Float.valueOf(y));
        context.resetExecutingComponentType(type);
        context.setIsFirstComponent(Boolean.FALSE);
    }

    protected void resetXY() {
        this.beginX = null;
        this.beginY = null;
        this.isCustomPosition = null;
        if (this.getContext().getExecutingComponentType().isNotPageHeaderOrFooter()) {
            this.relativeBeginX = Float.valueOf(0.0f);
            this.relativeBeginY = Float.valueOf(0.0f);
        }
    }

    protected void setBeginX(Float x, Boolean isCustomPosition) {
        this.beginX = x;
        this.isCustomPosition = Optional.ofNullable(isCustomPosition).orElse(Boolean.FALSE);
    }

    protected void setBeginY(Float y, Boolean isCustomPosition) {
        this.beginY = y;
        this.isCustomPosition = Optional.ofNullable(isCustomPosition).orElse(Boolean.FALSE);
    }

    public MarginConfiguration getMarginConfiguration() {
        return this.marginConfiguration;
    }

    public BorderConfiguration getBorderConfiguration() {
        return this.borderConfiguration;
    }

    public LinkedHashSet<PagingEvent> getPagingEvents() {
        return this.pagingEvents;
    }

    @Override
    public PagingCondition getPagingCondition() {
        return this.pagingCondition;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public Float getRelativeBeginX() {
        return this.relativeBeginX;
    }

    public Float getRelativeBeginY() {
        return this.relativeBeginY;
    }

    public Boolean getIsWrap() {
        return this.isWrap;
    }

    public Boolean getIsBreak() {
        return this.isBreak;
    }

    public Boolean getIsCustomPosition() {
        return this.isCustomPosition;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setMarginConfiguration(MarginConfiguration marginConfiguration) {
        this.marginConfiguration = marginConfiguration;
    }

    public void setBorderConfiguration(BorderConfiguration borderConfiguration) {
        this.borderConfiguration = borderConfiguration;
    }

    public void setPagingEvents(LinkedHashSet<PagingEvent> pagingEvents) {
        this.pagingEvents = pagingEvents;
    }

    public void setPagingCondition(PagingCondition pagingCondition) {
        this.pagingCondition = pagingCondition;
    }

    public void setRelativeBeginX(Float relativeBeginX) {
        this.relativeBeginX = relativeBeginX;
    }

    public void setRelativeBeginY(Float relativeBeginY) {
        this.relativeBeginY = relativeBeginY;
    }

    public void setIsWrap(Boolean isWrap) {
        this.isWrap = isWrap;
    }

    public void setIsBreak(Boolean isBreak) {
        this.isBreak = isBreak;
    }

    public void setIsCustomPosition(Boolean isCustomPosition) {
        this.isCustomPosition = isCustomPosition;
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    @Override
    public String toString() {
        return "AbstractComponent(marginConfiguration=" + this.getMarginConfiguration() + ", borderConfiguration=" + this.getBorderConfiguration() + ", pagingEvents=" + this.getPagingEvents() + ", pagingCondition=" + this.getPagingCondition() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", relativeBeginX=" + this.getRelativeBeginX() + ", relativeBeginY=" + this.getRelativeBeginY() + ", isWrap=" + this.getIsWrap() + ", isBreak=" + this.getIsBreak() + ", isCustomPosition=" + this.getIsCustomPosition() + ", horizontalAlignment=" + (Object)((Object)this.getHorizontalAlignment()) + ", verticalAlignment=" + (Object)((Object)this.getVerticalAlignment()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractComponent)) {
            return false;
        }
        AbstractComponent other = (AbstractComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Float this$relativeBeginX = this.getRelativeBeginX();
        Float other$relativeBeginX = other.getRelativeBeginX();
        if (this$relativeBeginX == null ? other$relativeBeginX != null : !((Object)this$relativeBeginX).equals(other$relativeBeginX)) {
            return false;
        }
        Float this$relativeBeginY = this.getRelativeBeginY();
        Float other$relativeBeginY = other.getRelativeBeginY();
        if (this$relativeBeginY == null ? other$relativeBeginY != null : !((Object)this$relativeBeginY).equals(other$relativeBeginY)) {
            return false;
        }
        Boolean this$isWrap = this.getIsWrap();
        Boolean other$isWrap = other.getIsWrap();
        if (this$isWrap == null ? other$isWrap != null : !((Object)this$isWrap).equals(other$isWrap)) {
            return false;
        }
        Boolean this$isBreak = this.getIsBreak();
        Boolean other$isBreak = other.getIsBreak();
        if (this$isBreak == null ? other$isBreak != null : !((Object)this$isBreak).equals(other$isBreak)) {
            return false;
        }
        Boolean this$isCustomPosition = this.getIsCustomPosition();
        Boolean other$isCustomPosition = other.getIsCustomPosition();
        if (this$isCustomPosition == null ? other$isCustomPosition != null : !((Object)this$isCustomPosition).equals(other$isCustomPosition)) {
            return false;
        }
        MarginConfiguration this$marginConfiguration = this.getMarginConfiguration();
        MarginConfiguration other$marginConfiguration = other.getMarginConfiguration();
        if (this$marginConfiguration == null ? other$marginConfiguration != null : !((Object)this$marginConfiguration).equals(other$marginConfiguration)) {
            return false;
        }
        BorderConfiguration this$borderConfiguration = this.getBorderConfiguration();
        BorderConfiguration other$borderConfiguration = other.getBorderConfiguration();
        if (this$borderConfiguration == null ? other$borderConfiguration != null : !((Object)this$borderConfiguration).equals(other$borderConfiguration)) {
            return false;
        }
        Set this$pagingEvents = this.getPagingEvents();
        Set other$pagingEvents = other.getPagingEvents();
        if (this$pagingEvents == null ? other$pagingEvents != null : !((Object)this$pagingEvents).equals(other$pagingEvents)) {
            return false;
        }
        PagingCondition this$pagingCondition = this.getPagingCondition();
        PagingCondition other$pagingCondition = other.getPagingCondition();
        if (this$pagingCondition == null ? other$pagingCondition != null : !this$pagingCondition.equals(other$pagingCondition)) {
            return false;
        }
        HorizontalAlignment this$horizontalAlignment = this.getHorizontalAlignment();
        HorizontalAlignment other$horizontalAlignment = other.getHorizontalAlignment();
        if (this$horizontalAlignment == null ? other$horizontalAlignment != null : !((Object)((Object)this$horizontalAlignment)).equals((Object)other$horizontalAlignment)) {
            return false;
        }
        VerticalAlignment this$verticalAlignment = this.getVerticalAlignment();
        VerticalAlignment other$verticalAlignment = other.getVerticalAlignment();
        return !(this$verticalAlignment == null ? other$verticalAlignment != null : !((Object)((Object)this$verticalAlignment)).equals((Object)other$verticalAlignment));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractComponent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Float $relativeBeginX = this.getRelativeBeginX();
        result = result * 59 + ($relativeBeginX == null ? 43 : ((Object)$relativeBeginX).hashCode());
        Float $relativeBeginY = this.getRelativeBeginY();
        result = result * 59 + ($relativeBeginY == null ? 43 : ((Object)$relativeBeginY).hashCode());
        Boolean $isWrap = this.getIsWrap();
        result = result * 59 + ($isWrap == null ? 43 : ((Object)$isWrap).hashCode());
        Boolean $isBreak = this.getIsBreak();
        result = result * 59 + ($isBreak == null ? 43 : ((Object)$isBreak).hashCode());
        Boolean $isCustomPosition = this.getIsCustomPosition();
        result = result * 59 + ($isCustomPosition == null ? 43 : ((Object)$isCustomPosition).hashCode());
        MarginConfiguration $marginConfiguration = this.getMarginConfiguration();
        result = result * 59 + ($marginConfiguration == null ? 43 : ((Object)$marginConfiguration).hashCode());
        BorderConfiguration $borderConfiguration = this.getBorderConfiguration();
        result = result * 59 + ($borderConfiguration == null ? 43 : ((Object)$borderConfiguration).hashCode());
        Set $pagingEvents = this.getPagingEvents();
        result = result * 59 + ($pagingEvents == null ? 43 : ((Object)$pagingEvents).hashCode());
        PagingCondition $pagingCondition = this.getPagingCondition();
        result = result * 59 + ($pagingCondition == null ? 43 : $pagingCondition.hashCode());
        HorizontalAlignment $horizontalAlignment = this.getHorizontalAlignment();
        result = result * 59 + ($horizontalAlignment == null ? 43 : ((Object)((Object)$horizontalAlignment)).hashCode());
        VerticalAlignment $verticalAlignment = this.getVerticalAlignment();
        result = result * 59 + ($verticalAlignment == null ? 43 : ((Object)((Object)$verticalAlignment)).hashCode());
        return result;
    }
}

