/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.apache.pdfbox.util.Matrix;
import org.dromara.pdf.pdfbox.core.base.BorderData;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.InnerDest;
import org.dromara.pdf.pdfbox.core.base.OuterDest;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.Position;
import org.dromara.pdf.pdfbox.core.base.config.FontConfiguration;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;
import org.dromara.pdf.pdfbox.core.enums.FontStyle;
import org.dromara.pdf.pdfbox.core.enums.HighlightMode;
import org.dromara.pdf.pdfbox.core.enums.VerticalAlignment;
import org.dromara.pdf.pdfbox.core.info.CatalogInfo;
import org.dromara.pdf.pdfbox.support.Constants;
import org.dromara.pdf.pdfbox.util.BorderUtil;
import org.dromara.pdf.pdfbox.util.CommonUtil;
import org.dromara.pdf.pdfbox.util.TextUtil;

public class Textarea
extends AbstractComponent {
    protected FontConfiguration fontConfiguration;
    protected CatalogInfo catalog;
    protected Integer tabSize;
    protected String text;
    protected List<String> textList;
    protected Float rise;
    protected Color highlightColor;
    protected Boolean isHighlight;
    protected Float underlineWidth;
    protected Color underlineColor;
    protected Boolean isUnderline;
    protected Float deleteLineWidth;
    protected Color deleteLineColor;
    protected Boolean isDeleteLine;
    protected InnerDest innerDest;
    protected OuterDest outerDest;

    public Textarea(Page page) {
        super(page);
        this.fontConfiguration = new FontConfiguration(page.getFontConfiguration());
    }

    public void setFontName(String fontName) {
        if (Objects.nonNull(fontName)) {
            this.getContext().addFontCache(fontName);
            this.fontConfiguration.setFontName(fontName);
        } else {
            this.fontConfiguration.setFontName(this.getPage().getFontName());
        }
    }

    public void setSpecialFontNames(String ... fontNames) {
        this.getContext().addFontCache(fontNames);
        Collections.addAll(this.fontConfiguration.getSpecialFontNames(), fontNames);
    }

    public void setFontSize(float size) {
        this.fontConfiguration.setFontSize(size);
    }

    public void setFontColor(Color color) {
        this.fontConfiguration.setFontColor(color);
    }

    public void setStrokColor(Color color) {
        this.fontConfiguration.setStrokColor(color);
    }

    public void setFontAlpha(float alpha) {
        this.fontConfiguration.setFontAlpha(Float.valueOf(alpha));
    }

    public void setFontStyle(FontStyle style) {
        this.fontConfiguration.setFontStyle(style);
        if (style.isItalic() && this.getFontSlope().floatValue() == 0.0f) {
            this.setFontSlope(Constants.DEFAULT_FONT_ITALIC_SLOPE.floatValue());
        }
    }

    public void setFontSlope(float slope) {
        this.fontConfiguration.setFontSlope(Float.valueOf(slope));
    }

    public void setCharacterSpacing(float spacing) {
        this.fontConfiguration.setCharacterSpacing(spacing);
    }

    public void setLeading(float leading) {
        this.fontConfiguration.setLeading(leading);
    }

    public void setTabSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("the size can not be less than 0");
        }
        this.tabSize = size;
    }

    public void setUnderlineWidth(float width) {
        if (width < 1.0f) {
            throw new IllegalArgumentException("the underline width can not be less than 1");
        }
        this.underlineWidth = Float.valueOf(width);
    }

    public void setDeleteLineWidth(float width) {
        if (width < 1.0f) {
            throw new IllegalArgumentException("the delete line width can not be less than 1");
        }
        this.deleteLineWidth = Float.valueOf(width);
    }

    @Override
    public ComponentType getType() {
        return ComponentType.TEXTAREA;
    }

    public String getPlaceholder() {
        return "${CPN}";
    }

    public PDFont getFont() {
        return this.getContext().getFont(this.fontConfiguration.getFontName());
    }

    public String getFontName() {
        return this.fontConfiguration.getFontName();
    }

    public List<String> getSpecialFontNames() {
        return this.fontConfiguration.getSpecialFontNames();
    }

    public Float getFontSize() {
        return this.fontConfiguration.getFontSize();
    }

    public Color getFontColor() {
        return this.fontConfiguration.getFontColor();
    }

    public Color getStrokColor() {
        return this.fontConfiguration.getStrokColor();
    }

    public Float getFontAlpha() {
        return this.fontConfiguration.getFontAlpha();
    }

    public FontStyle getFontStyle() {
        return this.fontConfiguration.getFontStyle();
    }

    public Float getFontSlope() {
        return this.fontConfiguration.getFontSlope();
    }

    public Float getCharacterSpacing() {
        return this.fontConfiguration.getCharacterSpacing();
    }

    public Float getLeading() {
        return this.fontConfiguration.getLeading();
    }

    @Override
    protected void init() {
        super.init();
        if (Objects.isNull(this.tabSize)) {
            this.tabSize = 4;
        }
        if (Objects.isNull(this.rise)) {
            this.rise = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.highlightColor)) {
            this.highlightColor = this.getContext().getPage().getBackgroundColor();
        }
        if (Objects.isNull(this.isHighlight)) {
            this.isHighlight = Boolean.FALSE;
        }
        if (Objects.isNull(this.underlineWidth)) {
            this.underlineWidth = Float.valueOf(1.0f);
        }
        if (Objects.isNull(this.underlineColor)) {
            this.underlineColor = this.getFontColor();
        }
        if (Objects.isNull(this.isUnderline)) {
            this.isUnderline = Boolean.FALSE;
        }
        if (Objects.isNull(this.deleteLineWidth)) {
            this.deleteLineWidth = Float.valueOf(1.0f);
        }
        if (Objects.isNull(this.deleteLineColor)) {
            this.deleteLineColor = this.getFontColor();
        }
        if (Objects.isNull(this.isDeleteLine)) {
            this.isDeleteLine = Boolean.FALSE;
        }
        this.checkWrap(this.getFontSize().floatValue());
        if (this.getContext().isEqualsComponent(this.getType()) && this.checkPaging()) {
            this.setIsWrap(true);
            this.wrap(this.getFontSize().floatValue());
        }
        this.initText();
        this.initBeginY(TextUtil.getTextRealHeight(this.getTextList().size(), this.getFontSize().floatValue(), this.getLeading().floatValue()));
    }

    @Override
    protected void writeContents() {
        if (this.getContext().getIsVirtualRender().booleanValue()) {
            this.virtualWrite();
        } else {
            this.write();
        }
    }

    @Override
    protected void reset() {
    }

    protected void initText() {
        LinkedList<String> tempTextList = new LinkedList<String>();
        if (Objects.nonNull(this.text)) {
            tempTextList.addAll(this.processText(this.text));
        } else if (Objects.nonNull(this.textList)) {
            this.textList.forEach(text -> tempTextList.addAll(this.processText((String)text)));
        } else {
            this.textList = Collections.emptyList();
            return;
        }
        this.initTextList(tempTextList);
    }

    protected List<String> processText(String text) {
        String temp = TextUtil.filterAll(text);
        temp = temp.replace("${CPN}", this.getPage().getLastNo().toString());
        temp = TextUtil.replaceTab(temp, this.getTabSize());
        return Arrays.asList(temp.split("\n"));
    }

    protected void initTextList(List<String> tempTextList) {
        this.textList = new LinkedList<String>();
        if (tempTextList.isEmpty()) {
            return;
        }
        Context context = this.getContext();
        float firstWidth = context.getWrapWidth().floatValue() + context.getWrapBeginX().floatValue() - this.getBeginX().floatValue();
        float newWidth = context.getWrapWidth().floatValue();
        String text = tempTextList.get(0);
        if (TextUtil.isNotBlank(text)) {
            String firstContent = TextUtil.splitText(context, text, firstWidth, this.getFont(), this.getFontSize().floatValue(), this.getCharacterSpacing().floatValue(), this.getSpecialFontNames());
            if (firstContent == null) {
                this.setBeginX(this.getContext().getWrapBeginX());
                this.setBeginY(Float.valueOf(this.getContext().getCursor().getY().floatValue() - this.getFontSize().floatValue()));
                this.textList.addAll(TextUtil.splitLines(this.getContext(), text, newWidth, this.getFont(), this.getFontSize().floatValue(), this.getCharacterSpacing().floatValue(), this.getSpecialFontNames()));
            } else {
                this.textList.add(firstContent);
                if (firstContent.length() < text.length()) {
                    this.textList.addAll(TextUtil.splitLines(this.getContext(), text.substring(firstContent.length()), newWidth, this.getFont(), this.getFontSize().floatValue(), this.getCharacterSpacing().floatValue(), this.getSpecialFontNames()));
                }
            }
        }
        int count = tempTextList.size();
        for (int i = 1; i < count; ++i) {
            if (!TextUtil.isNotBlank(tempTextList.get(i))) continue;
            this.textList.addAll(TextUtil.splitLines(this.getContext(), tempTextList.get(i), newWidth, this.getFont(), this.getFontSize().floatValue(), this.getCharacterSpacing().floatValue(), this.getSpecialFontNames()));
        }
    }

    protected void initCatalog(Position position) {
        if (Objects.nonNull(this.catalog)) {
            Context context = this.getContext();
            this.catalog.setPage(context.getPage());
            this.catalog.setBeginX(position.getX());
            this.catalog.setBeginY(position.getY());
            context.getCatalogs().add(this.catalog);
        }
    }

    @Override
    protected float getMinWidth() {
        return this.getFontSize().floatValue();
    }

    protected void virtualWrite() {
        Position position = new Position(Float.valueOf(this.getBeginX().floatValue() + this.getRelativeBeginX().floatValue()), Float.valueOf(this.getBeginY().floatValue() - this.getRelativeBeginY().floatValue()));
        if (!this.getTextList().isEmpty()) {
            String text = null;
            Iterator<String> iterator = this.getTextList().iterator();
            while (iterator.hasNext()) {
                text = iterator.next();
                this.virtualWrite(text, position);
                if (!iterator.hasNext()) continue;
                position.reset(this.getContext().getWrapBeginX(), Float.valueOf(position.getY().floatValue() - this.getFontSize().floatValue() - this.getLeading().floatValue()));
            }
            float textWidth = TextUtil.getTextRealWidth(this.getContext(), text, this.getFont(), this.getFontSize().floatValue(), this.getCharacterSpacing().floatValue(), this.getSpecialFontNames());
            this.resetPagePosition(position, textWidth);
        }
        super.reset(this.getType(), position.getX().floatValue(), position.getY().floatValue());
    }

    protected void write() {
        Position position = new Position(Float.valueOf(this.getBeginX().floatValue() + this.getRelativeBeginX().floatValue()), Float.valueOf(this.getBeginY().floatValue() - this.getRelativeBeginY().floatValue()));
        this.initCatalog(position);
        if (!this.getTextList().isEmpty()) {
            float textWidth = 0.0f;
            PDPageContentStream contentStream = this.initContentStream();
            Iterator<String> iterator = this.getTextList().iterator();
            while (iterator.hasNext()) {
                String text = iterator.next();
                textWidth = TextUtil.getTextRealWidth(this.getContext(), text, this.getFont(), this.getFontSize().floatValue(), this.getCharacterSpacing().floatValue(), this.getSpecialFontNames());
                contentStream = this.write(text, textWidth, contentStream, position);
                if (!iterator.hasNext()) continue;
                position.reset(this.getContext().getWrapBeginX(), Float.valueOf(position.getY().floatValue() - this.getFontSize().floatValue() - this.getLeading().floatValue()));
            }
            contentStream.close();
            this.resetPagePosition(position, textWidth);
        }
        super.reset(this.getType(), position.getX().floatValue(), position.getY().floatValue());
    }

    protected void virtualWrite(String text, Position position) {
        if (TextUtil.isNotBlank(text)) {
            this.virtualCheckPaging(position);
        }
    }

    protected PDPageContentStream write(String text, float textWidth, PDPageContentStream contentStream, Position position) {
        if (TextUtil.isNotBlank(text)) {
            contentStream = this.checkPaging(contentStream, position);
            PDRectangle lineRectangle = this.getLineRectangle(textWidth, position);
            this.addHighlight(lineRectangle, contentStream);
            this.addText(text, lineRectangle, contentStream);
            this.addDeleteLine(lineRectangle, contentStream);
            this.addUnderline(lineRectangle, contentStream);
            this.addInnerDest(lineRectangle);
            this.addOuterDest(lineRectangle);
            this.addBorder(lineRectangle, contentStream);
            position.setX(Float.valueOf(lineRectangle.getLowerLeftX()));
        }
        return contentStream;
    }

    protected PDPageContentStream checkPaging(PDPageContentStream contentStream, Position position) {
        if (this.checkPaging(this, position.getY().floatValue())) {
            if (this.getContext().isEqualsComponent(this.getType())) {
                this.getContext().setIsAlreadyPaging(false);
            }
            this.processBreak();
            this.wrap(this.getFontSize().floatValue());
            position.setY(Float.valueOf(this.getBeginY().floatValue() - this.getContext().getOffsetY().floatValue()));
            if (position.getY().floatValue() > 0.0f) {
                this.initAfterPagingPosition(position);
                contentStream.close();
                return this.initContentStream();
            }
            return this.checkPaging(contentStream, position);
        }
        return contentStream;
    }

    protected void virtualCheckPaging(Position position) {
        if (this.checkPaging(this, position.getY().floatValue())) {
            if (this.getContext().isEqualsComponent(this.getType())) {
                this.getContext().setIsAlreadyPaging(false);
            }
            this.processBreak();
            this.wrap(this.getFontSize().floatValue());
            position.setY(Float.valueOf(this.getBeginY().floatValue() - this.getContext().getOffsetY().floatValue()));
            if (position.getY().floatValue() > 0.0f) {
                this.initAfterPagingPosition(position);
            } else {
                this.virtualCheckPaging(position);
            }
        }
    }

    protected void initAfterPagingPosition(Position position) {
        if (this.getVerticalAlignment() == VerticalAlignment.BOTTOM) {
            position.setY(Float.valueOf(position.getY().floatValue() + this.getFontSize().floatValue()));
        } else {
            position.setY(Float.valueOf(Math.min(position.getY().floatValue(), this.getContext().getMaxBeginY() - this.getFontSize().floatValue())));
        }
    }

    protected void addHighlight(PDRectangle rectangle, PDPageContentStream contentStream) {
        if (this.getIsHighlight().booleanValue()) {
            contentStream.addRect(rectangle.getLowerLeftX(), rectangle.getLowerLeftY() - this.getFontSize().floatValue() / 10.0f, rectangle.getWidth(), rectangle.getHeight());
            contentStream.setNonStrokingColor(this.getHighlightColor());
            contentStream.fill();
            contentStream.setNonStrokingColor(this.getContext().getPage().getBackgroundColor());
        }
    }

    protected void addText(String text, PDRectangle rectangle, PDPageContentStream contentStream) {
        CommonUtil.initFontColorAndAlpha(contentStream, this.getPage().getBackgroundColor(), this.getFontStyle(), this.getFontColor(), this.getStrokColor(), this.getFontAlpha().floatValue());
        contentStream.beginText();
        this.initMatrix(contentStream, rectangle.getLowerLeftX(), rectangle.getLowerLeftY());
        TextUtil.writeText(this.getContext(), contentStream, text, this.getSpecialFontNames(), this.getFont(), this.getFontSize());
        contentStream.endText();
    }

    protected void addDeleteLine(PDRectangle rectangle, PDPageContentStream stream) {
        if (this.getIsDeleteLine().booleanValue()) {
            float beginY = rectangle.getLowerLeftY() - this.getDeleteLineWidth().floatValue() / 2.0f + this.getFontSize().floatValue() / 2.0f - this.getFontSize().floatValue() / 10.0f;
            stream.setStrokingColor(this.getDeleteLineColor());
            stream.setLineWidth(this.getDeleteLineWidth().floatValue());
            stream.moveTo(rectangle.getLowerLeftX(), beginY);
            stream.lineTo(rectangle.getUpperRightX(), beginY);
            stream.stroke();
        }
    }

    protected void addUnderline(PDRectangle rectangle, PDPageContentStream stream) {
        if (this.getIsUnderline().booleanValue()) {
            stream.setStrokingColor(this.getUnderlineColor());
            stream.setLineWidth(this.getUnderlineWidth().floatValue());
            stream.moveTo(rectangle.getLowerLeftX(), rectangle.getLowerLeftY());
            stream.lineTo(rectangle.getUpperRightX(), rectangle.getLowerLeftY());
            stream.stroke();
        }
    }

    protected void addInnerDest(PDRectangle rectangle) {
        if (Objects.nonNull(this.getInnerDest())) {
            Objects.requireNonNull(this.getInnerDest().getPage(), "the page of inner destination can not be null");
            PDPageXYZDestination destination = new PDPageXYZDestination();
            destination.setPage(this.getInnerDest().getPage().getTarget());
            Optional.ofNullable(this.getInnerDest().getTopY()).ifPresent(arg_0 -> ((PDPageXYZDestination)destination).setTop(arg_0));
            PDActionGoTo action = new PDActionGoTo();
            action.setDestination((PDDestination)destination);
            this.addLink((PDAction)action, this.getInnerDest().getName(), rectangle, this.getInnerDest().getHighlightMode());
        }
    }

    protected void addOuterDest(PDRectangle rectangle) {
        if (Objects.nonNull(this.getOuterDest())) {
            Objects.requireNonNull(this.getOuterDest().getUrl(), "the url of outer destination can not be null");
            PDActionURI action = new PDActionURI();
            action.setURI(this.getOuterDest().getUrl());
            this.addLink((PDAction)action, this.getOuterDest().getName(), rectangle, this.getOuterDest().getHighlightMode());
        }
    }

    protected void addLink(PDAction action, String name, PDRectangle rectangle, HighlightMode mode) {
        PDPage target = this.getContext().getPage().getTarget();
        PDAnnotationLink link = new PDAnnotationLink();
        link.setAnnotationName(Optional.ofNullable(name).orElse(UUID.randomUUID().toString()));
        Optional.ofNullable(mode).map(HighlightMode::getMode).ifPresent(arg_0 -> ((PDAnnotationLink)link).setHighlightMode(arg_0));
        link.setAction(action);
        link.setRectangle(rectangle);
        target.getAnnotations().add(link);
    }

    protected void addBorder(PDRectangle rectangle, PDPageContentStream stream) {
        rectangle.setLowerLeftY(rectangle.getLowerLeftY() - this.getFontSize().floatValue() / 6.0f);
        BorderUtil.drawNormalBorder(stream, rectangle, new BorderData(this, this.getBorderConfiguration()));
    }

    protected PDPageContentStream initContentStream() {
        float lineWidth = 0.31543f;
        if (this.getFontStyle().isLight()) {
            lineWidth = 0.0f;
        }
        Context context = this.getContext();
        PDPageContentStream contentStream = new PDPageContentStream(context.getTargetDocument(), context.getTargetPage(), this.getContentMode().getMode(), true, true);
        contentStream.setFont(this.getFont(), this.getFontSize().floatValue());
        contentStream.setRenderingMode(this.getFontStyle().getMode(), lineWidth);
        contentStream.setTextRise(this.getRise().floatValue());
        contentStream.setLeading(this.getLeading().floatValue());
        contentStream.setCharacterSpacing(this.getCharacterSpacing().floatValue());
        return contentStream;
    }

    protected void initMatrix(PDPageContentStream stream, float beginX, float beginY) {
        Matrix matrix = new Matrix(1.0f, 0.0f, this.getFontSlope().floatValue(), 1.0f, beginX, beginY);
        stream.setTextMatrix(matrix);
    }

    protected PDRectangle getLineRectangle(float textWidth, Position position) {
        float offsetY = this.getFontSize().floatValue() / 8.0f;
        PDRectangle rectangle = new PDRectangle();
        switch (this.getHorizontalAlignment()) {
            case CENTER: {
                float offset = (this.getContext().getWrapWidth().floatValue() - textWidth) / 2.0f;
                rectangle.setLowerLeftX(position.getX().floatValue() + offset);
                rectangle.setUpperRightX(rectangle.getLowerLeftX() + textWidth);
                break;
            }
            case RIGHT: {
                float offset = this.getContext().getWrapWidth().floatValue() - textWidth - this.getMarginRight().floatValue();
                rectangle.setLowerLeftX(Math.min(this.getBeginX().floatValue() + offset, this.getContext().getMaxBeginX() - textWidth));
                rectangle.setUpperRightX(offset + textWidth);
                break;
            }
            default: {
                rectangle.setLowerLeftX(position.getX().floatValue());
                rectangle.setUpperRightX(position.getX().floatValue() + textWidth);
            }
        }
        rectangle.setLowerLeftY(position.getY().floatValue() + offsetY);
        rectangle.setUpperRightY(position.getY().floatValue() + this.getFontSize().floatValue());
        return rectangle;
    }

    protected void resetPagePosition(Position position, float textWidth) {
        position.setX(Float.valueOf(position.getX().floatValue() + textWidth + this.getMarginRight().floatValue()));
        if (Objects.nonNull(this.getCatalog())) {
            this.getCatalog().setEndX(position.getX());
            this.getCatalog().setEndY(position.getY());
        }
    }

    public FontConfiguration getFontConfiguration() {
        return this.fontConfiguration;
    }

    public CatalogInfo getCatalog() {
        return this.catalog;
    }

    public Integer getTabSize() {
        return this.tabSize;
    }

    public String getText() {
        return this.text;
    }

    public List<String> getTextList() {
        return this.textList;
    }

    public Float getRise() {
        return this.rise;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public Boolean getIsHighlight() {
        return this.isHighlight;
    }

    public Float getUnderlineWidth() {
        return this.underlineWidth;
    }

    public Color getUnderlineColor() {
        return this.underlineColor;
    }

    public Boolean getIsUnderline() {
        return this.isUnderline;
    }

    public Float getDeleteLineWidth() {
        return this.deleteLineWidth;
    }

    public Color getDeleteLineColor() {
        return this.deleteLineColor;
    }

    public Boolean getIsDeleteLine() {
        return this.isDeleteLine;
    }

    public InnerDest getInnerDest() {
        return this.innerDest;
    }

    public OuterDest getOuterDest() {
        return this.outerDest;
    }

    public void setFontConfiguration(FontConfiguration fontConfiguration) {
        this.fontConfiguration = fontConfiguration;
    }

    public void setCatalog(CatalogInfo catalog) {
        this.catalog = catalog;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTextList(List<String> textList) {
        this.textList = textList;
    }

    public void setRise(Float rise) {
        this.rise = rise;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public void setIsHighlight(Boolean isHighlight) {
        this.isHighlight = isHighlight;
    }

    public void setUnderlineColor(Color underlineColor) {
        this.underlineColor = underlineColor;
    }

    public void setIsUnderline(Boolean isUnderline) {
        this.isUnderline = isUnderline;
    }

    public void setDeleteLineColor(Color deleteLineColor) {
        this.deleteLineColor = deleteLineColor;
    }

    public void setIsDeleteLine(Boolean isDeleteLine) {
        this.isDeleteLine = isDeleteLine;
    }

    public void setInnerDest(InnerDest innerDest) {
        this.innerDest = innerDest;
    }

    public void setOuterDest(OuterDest outerDest) {
        this.outerDest = outerDest;
    }

    @Override
    public String toString() {
        return "Textarea(fontConfiguration=" + this.getFontConfiguration() + ", catalog=" + this.getCatalog() + ", tabSize=" + this.getTabSize() + ", text=" + this.getText() + ", textList=" + this.getTextList() + ", rise=" + this.getRise() + ", highlightColor=" + this.getHighlightColor() + ", isHighlight=" + this.getIsHighlight() + ", underlineWidth=" + this.getUnderlineWidth() + ", underlineColor=" + this.getUnderlineColor() + ", isUnderline=" + this.getIsUnderline() + ", deleteLineWidth=" + this.getDeleteLineWidth() + ", deleteLineColor=" + this.getDeleteLineColor() + ", isDeleteLine=" + this.getIsDeleteLine() + ", innerDest=" + this.getInnerDest() + ", outerDest=" + this.getOuterDest() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Textarea)) {
            return false;
        }
        Textarea other = (Textarea)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$tabSize = this.getTabSize();
        Integer other$tabSize = other.getTabSize();
        if (this$tabSize == null ? other$tabSize != null : !((Object)this$tabSize).equals(other$tabSize)) {
            return false;
        }
        Float this$rise = this.getRise();
        Float other$rise = other.getRise();
        if (this$rise == null ? other$rise != null : !((Object)this$rise).equals(other$rise)) {
            return false;
        }
        Boolean this$isHighlight = this.getIsHighlight();
        Boolean other$isHighlight = other.getIsHighlight();
        if (this$isHighlight == null ? other$isHighlight != null : !((Object)this$isHighlight).equals(other$isHighlight)) {
            return false;
        }
        Float this$underlineWidth = this.getUnderlineWidth();
        Float other$underlineWidth = other.getUnderlineWidth();
        if (this$underlineWidth == null ? other$underlineWidth != null : !((Object)this$underlineWidth).equals(other$underlineWidth)) {
            return false;
        }
        Boolean this$isUnderline = this.getIsUnderline();
        Boolean other$isUnderline = other.getIsUnderline();
        if (this$isUnderline == null ? other$isUnderline != null : !((Object)this$isUnderline).equals(other$isUnderline)) {
            return false;
        }
        Float this$deleteLineWidth = this.getDeleteLineWidth();
        Float other$deleteLineWidth = other.getDeleteLineWidth();
        if (this$deleteLineWidth == null ? other$deleteLineWidth != null : !((Object)this$deleteLineWidth).equals(other$deleteLineWidth)) {
            return false;
        }
        Boolean this$isDeleteLine = this.getIsDeleteLine();
        Boolean other$isDeleteLine = other.getIsDeleteLine();
        if (this$isDeleteLine == null ? other$isDeleteLine != null : !((Object)this$isDeleteLine).equals(other$isDeleteLine)) {
            return false;
        }
        FontConfiguration this$fontConfiguration = this.getFontConfiguration();
        FontConfiguration other$fontConfiguration = other.getFontConfiguration();
        if (this$fontConfiguration == null ? other$fontConfiguration != null : !((Object)this$fontConfiguration).equals(other$fontConfiguration)) {
            return false;
        }
        CatalogInfo this$catalog = this.getCatalog();
        CatalogInfo other$catalog = other.getCatalog();
        if (this$catalog == null ? other$catalog != null : !((Object)this$catalog).equals(other$catalog)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        List<String> this$textList = this.getTextList();
        List<String> other$textList = other.getTextList();
        if (this$textList == null ? other$textList != null : !((Object)this$textList).equals(other$textList)) {
            return false;
        }
        Color this$highlightColor = this.getHighlightColor();
        Color other$highlightColor = other.getHighlightColor();
        if (this$highlightColor == null ? other$highlightColor != null : !((Object)this$highlightColor).equals(other$highlightColor)) {
            return false;
        }
        Color this$underlineColor = this.getUnderlineColor();
        Color other$underlineColor = other.getUnderlineColor();
        if (this$underlineColor == null ? other$underlineColor != null : !((Object)this$underlineColor).equals(other$underlineColor)) {
            return false;
        }
        Color this$deleteLineColor = this.getDeleteLineColor();
        Color other$deleteLineColor = other.getDeleteLineColor();
        if (this$deleteLineColor == null ? other$deleteLineColor != null : !((Object)this$deleteLineColor).equals(other$deleteLineColor)) {
            return false;
        }
        InnerDest this$innerDest = this.getInnerDest();
        InnerDest other$innerDest = other.getInnerDest();
        if (this$innerDest == null ? other$innerDest != null : !((Object)this$innerDest).equals(other$innerDest)) {
            return false;
        }
        OuterDest this$outerDest = this.getOuterDest();
        OuterDest other$outerDest = other.getOuterDest();
        return !(this$outerDest == null ? other$outerDest != null : !((Object)this$outerDest).equals(other$outerDest));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Textarea;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $tabSize = this.getTabSize();
        result = result * 59 + ($tabSize == null ? 43 : ((Object)$tabSize).hashCode());
        Float $rise = this.getRise();
        result = result * 59 + ($rise == null ? 43 : ((Object)$rise).hashCode());
        Boolean $isHighlight = this.getIsHighlight();
        result = result * 59 + ($isHighlight == null ? 43 : ((Object)$isHighlight).hashCode());
        Float $underlineWidth = this.getUnderlineWidth();
        result = result * 59 + ($underlineWidth == null ? 43 : ((Object)$underlineWidth).hashCode());
        Boolean $isUnderline = this.getIsUnderline();
        result = result * 59 + ($isUnderline == null ? 43 : ((Object)$isUnderline).hashCode());
        Float $deleteLineWidth = this.getDeleteLineWidth();
        result = result * 59 + ($deleteLineWidth == null ? 43 : ((Object)$deleteLineWidth).hashCode());
        Boolean $isDeleteLine = this.getIsDeleteLine();
        result = result * 59 + ($isDeleteLine == null ? 43 : ((Object)$isDeleteLine).hashCode());
        FontConfiguration $fontConfiguration = this.getFontConfiguration();
        result = result * 59 + ($fontConfiguration == null ? 43 : ((Object)$fontConfiguration).hashCode());
        CatalogInfo $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 43 : ((Object)$catalog).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        List<String> $textList = this.getTextList();
        result = result * 59 + ($textList == null ? 43 : ((Object)$textList).hashCode());
        Color $highlightColor = this.getHighlightColor();
        result = result * 59 + ($highlightColor == null ? 43 : ((Object)$highlightColor).hashCode());
        Color $underlineColor = this.getUnderlineColor();
        result = result * 59 + ($underlineColor == null ? 43 : ((Object)$underlineColor).hashCode());
        Color $deleteLineColor = this.getDeleteLineColor();
        result = result * 59 + ($deleteLineColor == null ? 43 : ((Object)$deleteLineColor).hashCode());
        InnerDest $innerDest = this.getInnerDest();
        result = result * 59 + ($innerDest == null ? 43 : ((Object)$innerDest).hashCode());
        OuterDest $outerDest = this.getOuterDest();
        result = result * 59 + ($outerDest == null ? 43 : ((Object)$outerDest).hashCode());
        return result;
    }
}

