/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.comparator;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.ext.comparator.AbstractComparator;
import org.dromara.pdf.pdfbox.core.info.ImageCompareInfo;
import org.dromara.pdf.pdfbox.util.CommonUtil;

public class ImageComparator
extends AbstractComparator {
    public ImageComparator(Document document) {
        super(document);
    }

    public Map<Integer, List<ImageCompareInfo>> compareTo(Document other, int ... pageIndexes) {
        HashMap<Integer, List<ImageCompareInfo>> result = new HashMap<Integer, List<ImageCompareInfo>>(this.document.getTotalPageNumber());
        if (Objects.nonNull(pageIndexes) && pageIndexes.length > 0) {
            for (int pageIndex : pageIndexes) {
                result.put(pageIndex, this.compareImages(other, pageIndex));
            }
        } else {
            for (int pageIndex = 0; pageIndex < this.document.getTotalPageNumber(); ++pageIndex) {
                result.put(pageIndex, this.compareImages(other, pageIndex));
            }
        }
        return result;
    }

    protected List<ImageCompareInfo> compareImages(Document other, int pageIndex) {
        ArrayList<ImageCompareInfo> results = new ArrayList<ImageCompareInfo>(64);
        List<BufferedImage> list = this.processPageImage(this.document, pageIndex);
        List<BufferedImage> otherList = this.processPageImage(other, pageIndex);
        for (int i = 0; i < list.size(); ++i) {
            BufferedImage image = list.get(i);
            if (Objects.nonNull(otherList) && otherList.size() > i) {
                BufferedImage otherImage = otherList.get(i);
                if (this.compareImage(image, otherImage)) continue;
                results.add(ImageCompareInfo.builder().pageIndex(pageIndex).imageIndex(i).content(image).compareContent(otherImage).build());
                continue;
            }
            results.add(ImageCompareInfo.builder().pageIndex(pageIndex).imageIndex(i).content(image).build());
        }
        return results;
    }

    protected boolean compareImage(BufferedImage image, BufferedImage otherImage) {
        if (Objects.isNull(image) || Objects.isNull(otherImage)) {
            return false;
        }
        if (image.getWidth() != otherImage.getWidth() || image.getHeight() != otherImage.getHeight()) {
            return false;
        }
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (image.getRGB(x, y) == otherImage.getRGB(x, y)) continue;
                return false;
            }
        }
        return true;
    }

    protected List<BufferedImage> processPageImage(Document document, int pageIndex) {
        Page page = document.getPage(pageIndex);
        if (Objects.isNull(page)) {
            return null;
        }
        return CommonUtil.extractImage(page.getTarget());
    }
}

