/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationText;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.enums.ImageType;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;
import org.dromara.pdf.pdfbox.core.info.ReplaceInfo;
import org.dromara.pdf.pdfbox.handler.PdfHandler;
import org.dromara.pdf.pdfbox.support.COSBaseInfo;
import org.dromara.pdf.pdfbox.util.ImageUtil;

public class ReplaceProcessor
extends AbstractProcessor {
    public ReplaceProcessor(Document document) {
        super(document);
    }

    public void replaceText(List<ReplaceInfo> replaceList, int ... pageIndexes) {
        Objects.requireNonNull(replaceList, "the replace list can not be null");
        PDPageTree pageTree = this.getDocument().getPages();
        if (Objects.nonNull(pageIndexes)) {
            for (int pageIndex : pageIndexes) {
                this.replaceText(pageTree.get(pageIndex), replaceList);
            }
        } else {
            for (PDPage page : pageTree) {
                this.replaceText(page, replaceList);
            }
        }
    }

    public void replaceComment(Map<String, String> replaceMap, int ... pageIndexes) {
        PDPageTree pageTree = this.getDocument().getPages();
        if (Objects.nonNull(pageIndexes)) {
            for (int pageIndex : pageIndexes) {
                this.replaceComment(pageTree.get(pageIndex), replaceMap);
            }
        } else {
            for (PDPage page : pageTree) {
                this.replaceComment(page, replaceMap);
            }
        }
    }

    public void replaceImage(BufferedImage image, List<Integer> pageIndexes, int ... imageIndexes) {
        PDPageTree pageTree = this.getDocument().getPages();
        if (Objects.nonNull(pageIndexes)) {
            for (int pageIndex : pageIndexes) {
                this.replaceImage(pageTree.get(pageIndex), image, imageIndexes);
            }
        } else {
            for (PDPage page : pageTree) {
                this.replaceImage(page, image, imageIndexes);
            }
        }
    }

    public void replaceBookmark(Map<String, String> replaceMap, int ... bookmarkIndexes) {
        block7: {
            PDDocumentCatalog documentCatalog = this.getDocument().getDocumentCatalog();
            PDDocumentOutline documentOutline = documentCatalog.getDocumentOutline();
            if (!Objects.nonNull(documentOutline)) break block7;
            int index = 0;
            Iterable items = documentOutline.children();
            if (Objects.nonNull(bookmarkIndexes) && bookmarkIndexes.length > 0) {
                PrimitiveIterator.OfInt iterator = Arrays.stream(bookmarkIndexes).sorted().iterator();
                int bookmarkIndex = 0;
                for (PDOutlineItem outlineItem : items) {
                    if (index < bookmarkIndex) {
                        ++index;
                        continue;
                    }
                    if (iterator.hasNext()) {
                        bookmarkIndex = iterator.next();
                        if (index == bookmarkIndex) {
                            this.replaceBookmark(outlineItem, replaceMap);
                        }
                        ++index;
                        continue;
                    }
                    break;
                }
            } else {
                for (PDOutlineItem outlineItem : items) {
                    this.replaceBookmark(outlineItem, replaceMap);
                    ++index;
                }
            }
        }
    }

    protected void replaceText(PDPage page, List<ReplaceInfo> replaceList) {
        block14: {
            HashMap<Character, Integer> replaceIndexMap = new HashMap<Character, Integer>(replaceList.size());
            replaceList.forEach(info -> replaceIndexMap.put(info.getOriginal(), 0));
            PDFStreamParser parser = new PDFStreamParser((PDContentStream)page);
            List tokens = parser.parse();
            if (!this.replaceTextToken(page.getResources(), tokens, replaceList, replaceIndexMap)) break block14;
            PDStream updatedStream = new PDStream(this.getDocument());
            try (OutputStream outputStream = updatedStream.createOutputStream(COSName.FLATE_DECODE);){
                ContentStreamWriter tokenWriter = new ContentStreamWriter(outputStream);
                tokenWriter.writeTokens(tokens);
                page.setContents(updatedStream);
            }
        }
    }

    protected void replaceComment(PDPage page, Map<String, String> replaceMap) {
        List pdAnnotations = page.getAnnotations();
        for (PDAnnotation annotation : pdAnnotations) {
            PDAnnotationText text;
            String comment;
            String replaceString;
            if (!(annotation instanceof PDAnnotationText) || Objects.equals(replaceString = this.getReplaceString(comment = (text = (PDAnnotationText)annotation).getContents(), replaceMap), comment)) continue;
            text.setContents(replaceString);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Replaced comment: original [\"" + comment + "\"], now [\"" + replaceString + "\"]"));
        }
    }

    protected void replaceImage(PDPage page, BufferedImage image, int ... imageIndexes) {
        block8: {
            PDImageXObject imageObject = null;
            if (Objects.nonNull(image)) {
                imageObject = PDImageXObject.createFromByteArray((PDDocument)this.getDocument(), (byte[])ImageUtil.toBytes(image, ImageType.PNG.getType()), (String)ImageType.PNG.getType());
            }
            PDResources resources = page.getResources();
            Iterable objectNames = resources.getXObjectNames();
            if (Objects.isNull(imageIndexes) || imageIndexes.length == 0) {
                for (COSName cosName : objectNames) {
                    if (!(resources.getXObject(cosName) instanceof PDImage)) continue;
                    resources.put(cosName, (PDXObject)imageObject);
                }
                break block8;
            }
            PrimitiveIterator.OfInt iterator = Arrays.stream(imageIndexes).sorted().iterator();
            int index = 0;
            int replaceIndex = (Integer)iterator.next();
            for (COSName cosName : objectNames) {
                if (!(resources.getXObject(cosName) instanceof PDImage)) continue;
                if (index == replaceIndex) {
                    resources.put(cosName, (PDXObject)imageObject);
                    if (!iterator.hasNext()) break;
                    replaceIndex = (Integer)iterator.next();
                }
                ++index;
            }
        }
    }

    protected void replaceBookmark(PDOutlineItem outlineItem, Map<String, String> replaceMap) {
        String title = this.getReplaceString(outlineItem.getTitle(), replaceMap);
        if (Objects.nonNull(title)) {
            outlineItem.setTitle(title);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Replaced bookmark: original [\"" + outlineItem.getTitle() + "\"], now [\"" + title + "\"]"));
            }
        }
        Iterable children = outlineItem.children();
        for (PDOutlineItem child : children) {
            this.replaceBookmark(child, replaceMap);
        }
    }

    protected boolean replaceTextToken(PDResources resources, List<Object> tokens, List<ReplaceInfo> replaceList, Map<Character, Integer> replaceIndexMap) {
        boolean flag = false;
        Map<COSName, PDFont> resourceFontMap = this.initResourceFontMap(resources);
        COSBaseInfo cosBaseInfo = null;
        ArrayList<COSBaseInfo> infoList = new ArrayList<COSBaseInfo>(tokens.size());
        for (int i = 0; i < tokens.size(); ++i) {
            char[] characters;
            Object token = tokens.get(i);
            if (token instanceof COSName) {
                PDFont resourceFont = resourceFontMap.get(token);
                if (!Objects.nonNull(resourceFont)) continue;
                cosBaseInfo = new COSBaseInfo(i, resourceFont, resourceFont, false, new ArrayList<COSBaseInfo.TokenValue>(16));
                infoList.add(cosBaseInfo);
                continue;
            }
            if (!(token instanceof COSArray) && !(token instanceof COSString) || !Objects.nonNull(cosBaseInfo)) continue;
            String source = this.readFromToken(token, cosBaseInfo.getFont());
            StringBuilder newValue = new StringBuilder();
            if (!Objects.nonNull(source)) continue;
            boolean blank = false;
            for (char character : characters = source.toCharArray()) {
                Integer index = replaceIndexMap.get(Character.valueOf(character));
                if (Objects.nonNull(index)) {
                    for (ReplaceInfo info : replaceList) {
                        if (!Objects.equals(Character.valueOf(character), info.getOriginal())) continue;
                        Set<Integer> indexes = info.getIndexes();
                        if (Objects.nonNull(indexes)) {
                            boolean replaced = false;
                            for (Integer replaceIndex : indexes) {
                                if (!Objects.equals(index, replaceIndex)) continue;
                                replaced = true;
                                cosBaseInfo.setIsReplace(replaced);
                                cosBaseInfo.setReplaceFont(info.getFont());
                                if (!Objects.equals(Character.valueOf('\u0000'), info.getValue())) {
                                    newValue.append(info.getValue());
                                }
                                if (!this.log.isDebugEnabled()) break;
                                this.log.debug((Object)("Replaced character: original ['" + character + "'], now ['" + info.getValue() + "'], index ['" + index + "']"));
                                break;
                            }
                            if (replaced) continue;
                            newValue.append(character);
                            continue;
                        }
                        cosBaseInfo.setIsReplace(true);
                        cosBaseInfo.setReplaceFont(info.getFont());
                        if (!Objects.equals(Character.valueOf('\u0000'), info.getValue())) {
                            newValue.append(info.getValue());
                        }
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)("Replaced character: original ['" + character + "'], now ['" + info.getValue() + "'], index ['" + index + "']"));
                    }
                    replaceIndexMap.put(Character.valueOf(character), index + 1);
                } else {
                    newValue.append(character);
                }
                COSBaseInfo.TokenValue tokenValue = new COSBaseInfo.TokenValue(token, newValue.toString());
                cosBaseInfo.getTokens().add(tokenValue);
            }
        }
        for (COSBaseInfo info : infoList) {
            if (!info.getIsReplace().booleanValue()) continue;
            PDFont font = info.getReplaceFont();
            COSName replaceFontName = COSName.getPDFName((String)font.getName());
            for (COSBaseInfo.TokenValue token : info.getTokens()) {
                Object array;
                PdfHandler.getFontHandler().addToSubset(this.getDocument(), font, token.getValue());
                if (token.getToken() instanceof COSArray) {
                    array = (COSArray)token.getToken();
                    array.clear();
                    array.add((COSBase)new COSString(font.encode(token.getValue())));
                } else {
                    array = font.encode(token.getValue());
                    COSString cosString = (COSString)token.getToken();
                    cosString.setValue((byte[])array);
                }
                if (!Objects.isNull(resources.getFont(replaceFontName))) continue;
                resources.put(replaceFontName, font);
            }
            tokens.set(info.getFontIndex(), replaceFontName);
            flag = true;
        }
        return flag;
    }

    protected String getReplaceString(String content, Map<String, String> replaceMap) {
        if (Objects.isNull(content)) {
            return null;
        }
        if (!content.trim().isEmpty()) {
            for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
                Matcher matcher = Pattern.compile(entry.getKey(), 16).matcher(content);
                if (!matcher.find()) continue;
                content = matcher.replaceAll(entry.getValue());
            }
        }
        return content;
    }

    protected String readFromToken(Object token, PDFont resourceFont) throws IOException {
        StringBuilder builder = new StringBuilder();
        if (token instanceof COSArray) {
            COSArray array = (COSArray)token;
            for (COSBase cosBase : array) {
                if (cosBase instanceof COSInteger) {
                    COSInteger cosInteger = (COSInteger)cosBase;
                    if (cosInteger.intValue() > -199) continue;
                    builder.append(" ");
                    continue;
                }
                this.appendUnicode(builder, token, resourceFont);
            }
        } else {
            this.appendUnicode(builder, token, resourceFont);
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    protected void appendUnicode(StringBuilder builder, Object token, PDFont font) {
        block15: {
            if (!(token instanceof COSString)) break block15;
            COSString cosString = (COSString)token;
            try (ByteArrayInputStream in = new ByteArrayInputStream(cosString.getBytes());){
                while (((InputStream)in).available() > 0) {
                    String unicode = font.toUnicode(font.readCode(in));
                    if (!Objects.nonNull(unicode)) continue;
                    builder.append(unicode);
                }
            }
        }
    }

    protected Map<COSName, PDFont> initResourceFontMap(PDResources resources) {
        HashMap<COSName, PDFont> resourceFontMap = new HashMap<COSName, PDFont>(16);
        if (Objects.nonNull(resources)) {
            for (COSName cosName : resources.getFontNames()) {
                resourceFontMap.put(cosName, resources.getFont(cosName));
            }
        }
        return resourceFontMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceProcessor)) {
            return false;
        }
        ReplaceProcessor other = (ReplaceProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReplaceProcessor;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

