/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor.sign;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.pdmodel.interactive.form.PDTerminalField;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;
import org.dromara.pdf.pdfbox.core.ext.processor.sign.DefaultSigner;
import org.dromara.pdf.pdfbox.core.ext.processor.sign.SignOptions;
import org.dromara.pdf.pdfbox.core.ext.processor.sign.SignPermission;
import org.dromara.pdf.pdfbox.handler.PdfHandler;

public class SignProcessor
extends AbstractProcessor {
    protected SignatureInterface signer;

    public SignProcessor(Document document) {
        super(document);
    }

    public List<PDSignatureField> getFields() {
        return this.getDocument().getSignatureFields();
    }

    public PDSignatureField append(PDSignature signature) {
        PDAcroForm form = Optional.ofNullable(this.getDocument().getDocumentCatalog().getAcroForm(null)).orElse(new PDAcroForm(this.getDocument()));
        PDSignatureField field = new PDSignatureField(form);
        field.setValue(signature);
        List fields = form.getFields();
        fields.add(field);
        form.setFields(fields);
        this.getDocument().getDocumentCatalog().setAcroForm(form);
        return field;
    }

    public void remove(int index) {
        PDAcroForm form = Optional.ofNullable(this.getDocument().getDocumentCatalog().getAcroForm(null)).orElse(new PDAcroForm(this.getDocument()));
        List fields = form.getFields();
        if (fields.size() <= index) {
            this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
            return;
        }
        ArrayList<PDField> newFields = new ArrayList<PDField>(fields.size());
        int i = 0;
        for (PDField field : fields) {
            if (index != i) {
                newFields.add(field);
            }
            ++i;
        }
        form.setFields(newFields);
        this.getDocument().getDocumentCatalog().setAcroForm(form);
    }

    public void sign(PDSignature signature, SignOptions options, OutputStream outputStream) {
        Objects.requireNonNull(signature, "the signature can not be null");
        Objects.requireNonNull(options, "the options can not be null");
        Objects.requireNonNull(outputStream, "the outputStream can not be null");
        if (Objects.isNull(this.signer)) {
            this.signer = new DefaultSigner(options);
        }
        options.init();
        this.setMdpPermission(this.getDocument(), signature, options.getPermission());
        this.lockSignFields(this.getDocument(), signature);
        this.getDocument().addSignature(signature, this.signer, options.createOptions(this.getDocument(), signature));
        this.getDocument().saveIncremental(outputStream);
    }

    public void multiSign(PDSignature signature, SignOptions options, ByteArrayOutputStream outputStream) {
        this.sign(signature, options, outputStream);
        this.release();
        this.document = PdfHandler.getDocumentHandler().load(outputStream.toByteArray());
    }

    public void release() {
        this.document.close();
    }

    protected int getMdpPermission(PDDocument document) {
        COSDictionary signatureDict;
        COSDictionary permsDict;
        COSBase base = document.getDocumentCatalog().getCOSObject().getDictionaryObject(COSName.PERMS);
        if (base instanceof COSDictionary && (base = (permsDict = (COSDictionary)base).getDictionaryObject(COSName.DOCMDP)) instanceof COSDictionary && (base = (signatureDict = (COSDictionary)base).getDictionaryObject("Reference")) instanceof COSArray) {
            COSArray refArray = (COSArray)base;
            for (int i = 0; i < refArray.size(); ++i) {
                COSDictionary sigRefDict;
                base = refArray.getObject(i);
                if (!(base instanceof COSDictionary) || !COSName.DOCMDP.equals((Object)(sigRefDict = (COSDictionary)base).getDictionaryObject("TransformMethod")) || !((base = sigRefDict.getDictionaryObject("TransformParams")) instanceof COSDictionary)) continue;
                COSDictionary transformDict = (COSDictionary)base;
                int accessPermissions = transformDict.getInt(COSName.P, 0);
                if (accessPermissions < 1 || accessPermissions > 3) {
                    accessPermissions = 2;
                }
                return accessPermissions;
            }
        }
        return 0;
    }

    protected void setMdpPermission(PDDocument document, PDSignature signature, SignPermission permission) {
        List<PDSignature> signatureList = document.getSignatureDictionaries();
        for (PDSignature sig : signatureList) {
            if (COSName.DOC_TIME_STAMP.equals((Object)sig.getCOSObject().getItem(COSName.TYPE)) || !sig.getCOSObject().containsKey(COSName.CONTENTS)) continue;
            return;
        }
        COSDictionary sigDict = signature.getCOSObject();
        COSDictionary transformParameters = new COSDictionary();
        transformParameters.setItem(COSName.TYPE, (COSBase)COSName.getPDFName((String)"TransformParams"));
        transformParameters.setInt(COSName.P, permission.getType());
        transformParameters.setName(COSName.V, "1.2");
        transformParameters.setNeedToBeUpdated(true);
        COSDictionary referenceDict = new COSDictionary();
        referenceDict.setItem(COSName.TYPE, (COSBase)COSName.getPDFName((String)"SigRef"));
        referenceDict.setItem("TransformMethod", (COSBase)COSName.DOCMDP);
        referenceDict.setItem("DigestMethod", (COSBase)COSName.getPDFName((String)"SHA1"));
        referenceDict.setItem("TransformParams", (COSBase)transformParameters);
        referenceDict.setNeedToBeUpdated(true);
        COSArray referenceArray = new COSArray();
        referenceArray.add((COSBase)referenceDict);
        sigDict.setItem("Reference", (COSBase)referenceArray);
        referenceArray.setNeedToBeUpdated(true);
        COSDictionary catalogDict = document.getDocumentCatalog().getCOSObject();
        COSDictionary permsDict = new COSDictionary();
        catalogDict.setItem(COSName.PERMS, (COSBase)permsDict);
        permsDict.setItem(COSName.DOCMDP, (COSObjectable)signature);
        catalogDict.setNeedToBeUpdated(true);
        permsDict.setNeedToBeUpdated(true);
    }

    protected void lockSignFields(PDDocument document, PDSignature signature) {
        COSDictionary dictionary = signature.getCOSObject();
        PDAcroForm form = document.getDocumentCatalog().getAcroForm(null);
        if (Objects.nonNull(form)) {
            List<String> fieldNames = this.getLockFieldNames(dictionary);
            COSName action = dictionary.getCOSName(COSName.getPDFName((String)"Action"));
            if (Objects.nonNull(action)) {
                Predicate<PDField> shallBeLocked = action.equals((Object)COSName.getPDFName((String)"Include")) ? f -> fieldNames.contains(f.getFullyQualifiedName()) : (action.equals((Object)COSName.getPDFName((String)"Exclude")) ? f -> !fieldNames.contains(f.getFullyQualifiedName()) : (action.equals((Object)COSName.getPDFName((String)"All")) ? f -> true : f -> false));
                this.lockSignFields(form.getFields(), shallBeLocked);
            }
        }
    }

    protected List<String> getLockFieldNames(COSDictionary dictionary) {
        COSArray fields = dictionary.getCOSArray(COSName.FIELDS);
        if (Objects.isNull(fields)) {
            return Collections.emptyList();
        }
        return fields.toList().stream().filter(c -> c instanceof COSString).map(s -> ((COSString)s).getString()).collect(Collectors.toList());
    }

    protected boolean lockSignFields(List<PDField> fields, Predicate<PDField> shallBeLocked) {
        boolean isUpdated = false;
        if (fields != null) {
            for (PDField field : fields) {
                boolean isUpdatedField = false;
                if (shallBeLocked.test(field)) {
                    field.setFieldFlags(field.getFieldFlags() | 1);
                    if (field instanceof PDTerminalField) {
                        for (PDAnnotationWidget widget : field.getWidgets()) {
                            widget.setLocked(true);
                        }
                    }
                    isUpdatedField = true;
                }
                if (field instanceof PDNonTerminalField && this.lockSignFields(((PDNonTerminalField)field).getChildren(), shallBeLocked)) {
                    isUpdatedField = true;
                }
                if (!isUpdatedField) continue;
                field.getCOSObject().setNeedToBeUpdated(true);
                PDAppearanceDictionary appearance = ((PDAnnotationWidget)field.getWidgets().get(0)).getAppearance();
                appearance.getCOSObject().setNeedToBeUpdated(true);
                appearance.getNormalAppearance().getCOSObject().setNeedToBeUpdated(true);
                isUpdated = true;
            }
        }
        return isUpdated;
    }

    protected void resetSignForm(PDDocument target) {
        PDAcroForm form = target.getDocumentCatalog().getAcroForm(null);
        if (Objects.nonNull(form) && form.getNeedAppearances() && form.getFields().isEmpty()) {
            form.getCOSObject().removeItem(COSName.NEED_APPEARANCES);
        }
    }
}

