/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.handler;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.MemoryPolicy;

public class DocumentHandler {
    private static final DocumentHandler INSTANCE = new DocumentHandler();

    private DocumentHandler() {
    }

    public static DocumentHandler getInstance() {
        return INSTANCE;
    }

    public Document create() {
        return new Document();
    }

    public Document create(MemoryPolicy policy) {
        return new Document(policy);
    }

    public Document load(String path) {
        return this.load(path, MemoryPolicy.setupMainMemoryOnly());
    }

    public Document load(String path, MemoryPolicy policy) {
        return this.load(path, null, null, null, policy);
    }

    public Document load(String path, String password) {
        return this.load(path, password, null, null);
    }

    public Document load(String path, String password, InputStream keyStore, String alias) {
        return this.load(path, password, keyStore, alias, MemoryPolicy.setupMainMemoryOnly());
    }

    public Document load(String path, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        return this.load(Paths.get(path, new String[0]).toFile(), password, keyStore, alias, policy);
    }

    public Document load(File file) {
        return this.load(file, MemoryPolicy.setupMainMemoryOnly());
    }

    public Document load(File file, MemoryPolicy policy) {
        return this.load(file, null, null, null, policy);
    }

    public Document load(File file, String password) {
        return this.load(file, password, null, null);
    }

    public Document load(File file, String password, InputStream keyStore, String alias) {
        return this.load(file, password, keyStore, alias, MemoryPolicy.setupMainMemoryOnly());
    }

    public Document load(File file, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        return new Document(file, password, keyStore, alias, policy);
    }

    public Document load(byte[] bytes) {
        return this.load(bytes, MemoryPolicy.setupMainMemoryOnly());
    }

    public Document load(byte[] bytes, MemoryPolicy policy) {
        return this.load(bytes, null, null, null, policy);
    }

    public Document load(byte[] bytes, String password) {
        return this.load(bytes, password, null, null);
    }

    public Document load(byte[] bytes, String password, InputStream keyStore, String alias) {
        return this.load(bytes, password, keyStore, alias, MemoryPolicy.setupMainMemoryOnly());
    }

    public Document load(byte[] bytes, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        return new Document(bytes, password, keyStore, alias, policy);
    }

    public Document load(InputStream inputStream) {
        return this.load(inputStream, MemoryPolicy.setupMainMemoryOnly());
    }

    public Document load(InputStream inputStream, MemoryPolicy policy) {
        return this.load(inputStream, null, null, null, policy);
    }

    public Document load(InputStream inputStream, String password) {
        return this.load(inputStream, password, null, null);
    }

    public Document load(InputStream inputStream, String password, InputStream keyStore, String alias) {
        return this.load(inputStream, password, keyStore, alias, MemoryPolicy.setupMainMemoryOnly());
    }

    public Document load(InputStream inputStream, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        return new Document(inputStream, password, keyStore, alias, policy);
    }

    public Document loadByResource(String path) {
        return this.loadByResource(path, MemoryPolicy.setupMainMemoryOnly());
    }

    public Document loadByResource(String path, MemoryPolicy policy) {
        return this.loadByResource(path, null, null, null, policy);
    }

    public Document loadByResource(String path, String password) {
        return this.loadByResource(path, password, null, null);
    }

    public Document loadByResource(String path, String password, InputStream keyStore, String alias) {
        return this.loadByResource(path, password, keyStore, alias, MemoryPolicy.setupMainMemoryOnly());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document loadByResource(String path, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        try (InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);){
            Document document = this.load(inputStream, password, keyStore, alias, policy);
            return document;
        }
    }

    public Document loadByRemote(String path) {
        return this.loadByRemote(path, MemoryPolicy.setupMainMemoryOnly());
    }

    public Document loadByRemote(String path, MemoryPolicy policy) {
        return this.loadByRemote(path, null, null, null, policy);
    }

    public Document loadByRemote(String path, String password) {
        return this.loadByRemote(path, password, null, null);
    }

    public Document loadByRemote(String path, String password, InputStream keyStore, String alias) {
        return this.loadByRemote(path, password, keyStore, alias, MemoryPolicy.setupMainMemoryOnly());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document loadByRemote(String path, String password, InputStream keyStore, String alias, MemoryPolicy policy) {
        URLConnection connection = new URL(path).openConnection();
        connection.setConnectTimeout(300000);
        connection.setReadTimeout(300000);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        try (InputStream inputStream = connection.getInputStream();){
            Document document = this.load(inputStream, password, keyStore, alias, policy);
            return document;
        }
    }
}

