/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base.config;

import java.awt.Color;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.dromara.pdf.pdfbox.core.enums.FontStyle;
import org.dromara.pdf.pdfbox.support.Constants;

public class FontConfiguration {
    protected String fontName;
    protected List<String> specialFontNames;
    protected Float fontSize;
    protected Color fontColor;
    protected Color strokColor;
    protected Float fontAlpha;
    protected FontStyle fontStyle;
    protected Float fontSlope;
    protected Float characterSpacing;
    protected Float leading;

    public FontConfiguration() {
        this.init();
    }

    public FontConfiguration(FontConfiguration configuration) {
        this.init(configuration);
    }

    public void setFontSize(float fontSize) {
        if (fontSize < 1.0f) {
            throw new IllegalArgumentException("the font size must be greater than 1");
        }
        this.fontSize = Float.valueOf(fontSize);
    }

    public void setCharacterSpacing(float spacing) {
        if (spacing < 0.0f) {
            throw new IllegalArgumentException("the character spacing must be greater than 0");
        }
        this.characterSpacing = Float.valueOf(spacing);
    }

    public void setLeading(float leading) {
        if (leading < 0.0f) {
            throw new IllegalArgumentException("the leading must be greater than 0");
        }
        this.leading = Float.valueOf(leading);
    }

    public void init() {
        this.fontName = "HarmonyOS Sans SC";
        this.specialFontNames = Constants.DEFAULT_FONT_SPECIAL_NAMES;
        this.fontSize = Constants.DEFAULT_FONT_SIZE;
        this.fontColor = Constants.DEFAULT_FONT_COLOR;
        this.strokColor = Constants.DEFAULT_FONT_COLOR;
        this.fontAlpha = Constants.DEFAULT_FONT_ALPHA;
        this.fontStyle = Constants.DEFAULT_FONT_STYLE;
        this.fontSlope = Constants.DEFAULT_FONT_SLOPE;
        this.characterSpacing = Constants.DEFAULT_CHARACTER_SPACING;
        this.leading = Constants.DEFAULT_LEADING;
    }

    public void init(FontConfiguration configuration) {
        if (Objects.isNull(this.fontName)) {
            this.fontName = configuration.fontName;
        }
        if (Objects.isNull(this.specialFontNames)) {
            this.specialFontNames = configuration.specialFontNames;
        }
        if (Objects.isNull(this.fontSize)) {
            this.fontSize = configuration.fontSize;
        }
        if (Objects.isNull(this.fontColor)) {
            this.fontColor = configuration.fontColor;
        }
        if (Objects.isNull(this.strokColor)) {
            this.strokColor = configuration.strokColor;
        }
        if (Objects.isNull(this.fontAlpha)) {
            this.fontAlpha = configuration.fontAlpha;
        }
        if (Objects.isNull((Object)this.fontStyle)) {
            this.fontStyle = configuration.fontStyle;
        }
        if (Objects.isNull(this.fontSlope)) {
            this.fontSlope = configuration.fontSlope;
        }
        if (Objects.isNull(this.characterSpacing)) {
            this.characterSpacing = configuration.characterSpacing;
        }
        if (Objects.isNull(this.leading)) {
            this.leading = configuration.leading;
        }
    }

    @Generated
    public String getFontName() {
        return this.fontName;
    }

    @Generated
    public List<String> getSpecialFontNames() {
        return this.specialFontNames;
    }

    @Generated
    public Float getFontSize() {
        return this.fontSize;
    }

    @Generated
    public Color getFontColor() {
        return this.fontColor;
    }

    @Generated
    public Color getStrokColor() {
        return this.strokColor;
    }

    @Generated
    public Float getFontAlpha() {
        return this.fontAlpha;
    }

    @Generated
    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    @Generated
    public Float getFontSlope() {
        return this.fontSlope;
    }

    @Generated
    public Float getCharacterSpacing() {
        return this.characterSpacing;
    }

    @Generated
    public Float getLeading() {
        return this.leading;
    }

    @Generated
    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    @Generated
    public void setSpecialFontNames(List<String> specialFontNames) {
        this.specialFontNames = specialFontNames;
    }

    @Generated
    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    @Generated
    public void setStrokColor(Color strokColor) {
        this.strokColor = strokColor;
    }

    @Generated
    public void setFontAlpha(Float fontAlpha) {
        this.fontAlpha = fontAlpha;
    }

    @Generated
    public void setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    @Generated
    public void setFontSlope(Float fontSlope) {
        this.fontSlope = fontSlope;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FontConfiguration)) {
            return false;
        }
        FontConfiguration other = (FontConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$fontSize = this.getFontSize();
        Float other$fontSize = other.getFontSize();
        if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
            return false;
        }
        Float this$fontAlpha = this.getFontAlpha();
        Float other$fontAlpha = other.getFontAlpha();
        if (this$fontAlpha == null ? other$fontAlpha != null : !((Object)this$fontAlpha).equals(other$fontAlpha)) {
            return false;
        }
        Float this$fontSlope = this.getFontSlope();
        Float other$fontSlope = other.getFontSlope();
        if (this$fontSlope == null ? other$fontSlope != null : !((Object)this$fontSlope).equals(other$fontSlope)) {
            return false;
        }
        Float this$characterSpacing = this.getCharacterSpacing();
        Float other$characterSpacing = other.getCharacterSpacing();
        if (this$characterSpacing == null ? other$characterSpacing != null : !((Object)this$characterSpacing).equals(other$characterSpacing)) {
            return false;
        }
        Float this$leading = this.getLeading();
        Float other$leading = other.getLeading();
        if (this$leading == null ? other$leading != null : !((Object)this$leading).equals(other$leading)) {
            return false;
        }
        String this$fontName = this.getFontName();
        String other$fontName = other.getFontName();
        if (this$fontName == null ? other$fontName != null : !this$fontName.equals(other$fontName)) {
            return false;
        }
        List<String> this$specialFontNames = this.getSpecialFontNames();
        List<String> other$specialFontNames = other.getSpecialFontNames();
        if (this$specialFontNames == null ? other$specialFontNames != null : !((Object)this$specialFontNames).equals(other$specialFontNames)) {
            return false;
        }
        Color this$fontColor = this.getFontColor();
        Color other$fontColor = other.getFontColor();
        if (this$fontColor == null ? other$fontColor != null : !((Object)this$fontColor).equals(other$fontColor)) {
            return false;
        }
        Color this$strokColor = this.getStrokColor();
        Color other$strokColor = other.getStrokColor();
        if (this$strokColor == null ? other$strokColor != null : !((Object)this$strokColor).equals(other$strokColor)) {
            return false;
        }
        FontStyle this$fontStyle = this.getFontStyle();
        FontStyle other$fontStyle = other.getFontStyle();
        return !(this$fontStyle == null ? other$fontStyle != null : !((Object)((Object)this$fontStyle)).equals((Object)other$fontStyle));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FontConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $fontSize = this.getFontSize();
        result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
        Float $fontAlpha = this.getFontAlpha();
        result = result * 59 + ($fontAlpha == null ? 43 : ((Object)$fontAlpha).hashCode());
        Float $fontSlope = this.getFontSlope();
        result = result * 59 + ($fontSlope == null ? 43 : ((Object)$fontSlope).hashCode());
        Float $characterSpacing = this.getCharacterSpacing();
        result = result * 59 + ($characterSpacing == null ? 43 : ((Object)$characterSpacing).hashCode());
        Float $leading = this.getLeading();
        result = result * 59 + ($leading == null ? 43 : ((Object)$leading).hashCode());
        String $fontName = this.getFontName();
        result = result * 59 + ($fontName == null ? 43 : $fontName.hashCode());
        List<String> $specialFontNames = this.getSpecialFontNames();
        result = result * 59 + ($specialFontNames == null ? 43 : ((Object)$specialFontNames).hashCode());
        Color $fontColor = this.getFontColor();
        result = result * 59 + ($fontColor == null ? 43 : ((Object)$fontColor).hashCode());
        Color $strokColor = this.getStrokColor();
        result = result * 59 + ($strokColor == null ? 43 : ((Object)$strokColor).hashCode());
        FontStyle $fontStyle = this.getFontStyle();
        result = result * 59 + ($fontStyle == null ? 43 : ((Object)((Object)$fontStyle)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FontConfiguration(fontName=" + this.getFontName() + ", specialFontNames=" + this.getSpecialFontNames() + ", fontSize=" + this.getFontSize() + ", fontColor=" + this.getFontColor() + ", strokColor=" + this.getStrokColor() + ", fontAlpha=" + this.getFontAlpha() + ", fontStyle=" + (Object)((Object)this.getFontStyle()) + ", fontSlope=" + this.getFontSlope() + ", characterSpacing=" + this.getCharacterSpacing() + ", leading=" + this.getLeading() + ")";
    }
}

