/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base.config;

import java.util.Objects;
import lombok.Generated;

public class MarginConfiguration {
    protected Float marginTop;
    protected Float marginBottom;
    protected Float marginLeft;
    protected Float marginRight;

    public MarginConfiguration() {
        this.init();
    }

    public MarginConfiguration(MarginConfiguration configuration) {
        this.init(configuration);
    }

    public void setMargin(float margin) {
        if (margin < 0.0f) {
            throw new IllegalArgumentException("the margin must be positive");
        }
        this.marginTop = Float.valueOf(margin);
        this.marginBottom = Float.valueOf(margin);
        this.marginLeft = Float.valueOf(margin);
        this.marginRight = Float.valueOf(margin);
    }

    public void setMarginTop(float margin) {
        if (margin < 0.0f) {
            throw new IllegalArgumentException("the margin must be positive");
        }
        this.marginTop = Float.valueOf(margin);
    }

    public void setMarginBottom(float margin) {
        if (margin < 0.0f) {
            throw new IllegalArgumentException("the margin must be positive");
        }
        this.marginBottom = Float.valueOf(margin);
    }

    public void setMarginLeft(float margin) {
        if (margin < 0.0f) {
            throw new IllegalArgumentException("the margin must be positive");
        }
        this.marginLeft = Float.valueOf(margin);
    }

    public void setMarginRight(float margin) {
        if (margin < 0.0f) {
            throw new IllegalArgumentException("the margin must be positive");
        }
        this.marginRight = Float.valueOf(margin);
    }

    public void init() {
        if (Objects.isNull(this.marginTop)) {
            this.marginTop = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.marginBottom)) {
            this.marginBottom = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.marginLeft)) {
            this.marginLeft = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.marginRight)) {
            this.marginRight = Float.valueOf(0.0f);
        }
    }

    public void init(MarginConfiguration configuration) {
        if (Objects.isNull(this.marginTop)) {
            this.marginTop = configuration.marginTop;
        }
        if (Objects.isNull(this.marginBottom)) {
            this.marginBottom = configuration.marginBottom;
        }
        if (Objects.isNull(this.marginLeft)) {
            this.marginLeft = configuration.marginLeft;
        }
        if (Objects.isNull(this.marginRight)) {
            this.marginRight = configuration.marginRight;
        }
    }

    @Generated
    public Float getMarginTop() {
        return this.marginTop;
    }

    @Generated
    public Float getMarginBottom() {
        return this.marginBottom;
    }

    @Generated
    public Float getMarginLeft() {
        return this.marginLeft;
    }

    @Generated
    public Float getMarginRight() {
        return this.marginRight;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MarginConfiguration)) {
            return false;
        }
        MarginConfiguration other = (MarginConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$marginBottom = this.getMarginBottom();
        Float other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.getMarginRight();
        Float other$marginRight = other.getMarginRight();
        return !(this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MarginConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MarginConfiguration(marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ")";
    }
}

