/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PagingEvent;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;
import org.dromara.pdf.pdfbox.core.component.BorderInfo;
import org.dromara.pdf.pdfbox.core.component.Component;
import org.dromara.pdf.pdfbox.core.component.DefaultContainerPagingEvent;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;
import org.dromara.pdf.pdfbox.core.enums.HorizontalAlignment;
import org.dromara.pdf.pdfbox.core.enums.VerticalAlignment;
import org.dromara.pdf.pdfbox.util.BorderUtil;
import org.dromara.pdf.pdfbox.util.CommonUtil;

public class Container
extends AbstractComponent {
    protected Color backgroundColor;
    protected Float width;
    protected Float height;
    protected List<Component> components;
    protected PagingEvent pagingEvent;
    protected Boolean isTogether;
    protected Boolean isPagingBorder;
    protected HorizontalAlignment contentHorizontalAlignment;
    protected VerticalAlignment contentVerticalAlignment;

    public Container(Page page) {
        super(page);
    }

    public void setWidth(float width) {
        if (width < 1.0f) {
            throw new IllegalArgumentException("the width can not be less than 1");
        }
        this.width = Float.valueOf(width);
    }

    public void setHeight(float height) {
        if (height < 1.0f) {
            throw new IllegalArgumentException("the height can not be less than 1");
        }
        this.height = Float.valueOf(height);
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    public void setComponents(Component ... components) {
        this.components = Objects.nonNull(components) ? new ArrayList<Component>(Arrays.asList(components)) : null;
    }

    public void addComponents(List<Component> components) {
        if (Objects.nonNull(components)) {
            if (Objects.isNull(this.components)) {
                this.components = new ArrayList<Component>(components);
            } else {
                this.components.addAll(components);
            }
        }
    }

    public void addComponents(Component ... components) {
        if (Objects.nonNull(components)) {
            if (Objects.isNull(this.components)) {
                this.components = new ArrayList<Component>(components.length);
            }
            Collections.addAll(this.components, components);
        }
    }

    @Override
    public ComponentType getType() {
        return ComponentType.CONTAINER;
    }

    @Override
    protected void init() {
        Objects.requireNonNull(this.width, "the width can not be null");
        Objects.requireNonNull(this.height, "the height can not be null");
        super.init();
        this.pagingEvent = new DefaultContainerPagingEvent();
        if (Objects.isNull(this.isTogether)) {
            this.isTogether = Boolean.FALSE;
        }
        if (Objects.isNull(this.isPagingBorder)) {
            this.isPagingBorder = Boolean.FALSE;
        }
        if (Objects.isNull((Object)this.contentHorizontalAlignment)) {
            this.contentHorizontalAlignment = HorizontalAlignment.LEFT;
        }
        if (Objects.isNull((Object)this.contentVerticalAlignment)) {
            this.contentVerticalAlignment = VerticalAlignment.TOP;
        }
        this.checkWrap(this.height.floatValue());
        if (this.checkPaging()) {
            this.setIsWrap(true);
            this.wrap(this.height.floatValue());
        }
        this.initBeginX(this.width.floatValue());
        this.initBeginY(this.height.floatValue());
        this.getContext().setBorderInfo(new BorderInfo(this, this.getBorderConfiguration(), this.getBackgroundColor(), this.getWidth().floatValue(), this.getHeight().floatValue(), this.getBeginX().floatValue(), this.getBeginY().floatValue(), this.getPagingEvent(), this.getIsPagingBorder()));
    }

    @Override
    protected float getMinWidth() {
        return this.getWidth().floatValue();
    }

    @Override
    protected void writeContents() {
        float beginX = this.getBeginX().floatValue() + this.getRelativeBeginX().floatValue();
        float beginY = this.getBeginY().floatValue() + this.getRelativeBeginY().floatValue();
        BorderInfo borderInfo = this.getContext().getBorderInfo();
        Page page = this.getPage();
        Context context = page.getContext();
        context.setPage(page);
        context.getCursor().reset(beginX, beginY);
        float tempY = this.addBorder(Float.valueOf(beginX), Float.valueOf(beginY - borderInfo.getHeight().floatValue()), borderInfo);
        Page tempPage = context.getPage();
        if (!context.getIsVirtualRender().booleanValue() && Objects.nonNull(this.getComponents())) {
            context.setPage(page);
            context.setIsFirstComponent(true);
            context.setHeight(this.getHeight());
            context.getCursor().reset(beginX, beginY);
            for (Component component : this.getComponents()) {
                context.setWrapBeginX(Float.valueOf(beginX));
                context.setWrapWidth(this.getWidth());
                component.setHorizontalAlignment(this.getContentHorizontalAlignment());
                component.setVerticalAlignment(this.getContentVerticalAlignment());
                component.render();
            }
        }
        context.setPage(tempPage);
        context.resetCursorY(Float.valueOf(tempY));
    }

    @Override
    protected void reset() {
        float x = this.getPage().getMarginLeft().floatValue();
        float y = this.getContext().getCursor().getY().floatValue();
        super.reset(this.getType(), x, y);
        this.getContext().resetWrapWidth(null);
        this.getContext().resetHeight(null);
    }

    @Override
    protected Page executeBreak() {
        AtomicReference<Page> page = new AtomicReference<Page>();
        Float beginX = this.getBeginX();
        Float beginY = this.getBeginY();
        Context context = this.getContext();
        if (!context.getIsManualBreak().booleanValue()) {
            Optional.ofNullable(context.getBorderInfo()).map(BorderInfo::getPagingEvent).ifPresent(event -> {
                event.before(this);
                page.set(super.executeBreak());
                event.after(this);
            });
        } else {
            page.set(super.executeBreak());
        }
        this.setBeginX(beginX);
        this.setBeginY(beginY);
        return (Page)page.get();
    }

    protected float addBorder(Float beginX, Float beginY, BorderInfo info) {
        info.setBeginX(beginX);
        if (info.isPaging() && !this.getIsPagingBorder().booleanValue()) {
            info.setIsBorderTop(Boolean.FALSE);
        }
        if (this.isPaging(this, beginY.floatValue())) {
            return this.addBorder(beginX, Float.valueOf(info.getBeginY().floatValue() - info.getHeight().floatValue()), info);
        }
        PDRectangle rectangle = new PDRectangle(info.getBeginX().floatValue(), info.getBeginY().floatValue() - info.getHeight().floatValue(), info.getWidth().floatValue(), info.getHeight().floatValue());
        if (!this.getContext().getIsVirtualRender().booleanValue()) {
            CommonUtil.addBackgroundColor(info.getContext(), info.getContentMode(), info.getIsResetContentStream(), rectangle, info.getBackgroundColor());
            BorderUtil.drawBorderWithData(info, rectangle);
        }
        return rectangle.getLowerLeftY();
    }

    @Generated
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public Float getWidth() {
        return this.width;
    }

    @Generated
    public Float getHeight() {
        return this.height;
    }

    @Generated
    public List<Component> getComponents() {
        return this.components;
    }

    @Generated
    public PagingEvent getPagingEvent() {
        return this.pagingEvent;
    }

    @Generated
    public Boolean getIsTogether() {
        return this.isTogether;
    }

    @Generated
    public Boolean getIsPagingBorder() {
        return this.isPagingBorder;
    }

    @Generated
    public HorizontalAlignment getContentHorizontalAlignment() {
        return this.contentHorizontalAlignment;
    }

    @Generated
    public VerticalAlignment getContentVerticalAlignment() {
        return this.contentVerticalAlignment;
    }

    @Generated
    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Generated
    public void setPagingEvent(PagingEvent pagingEvent) {
        this.pagingEvent = pagingEvent;
    }

    @Generated
    public void setIsTogether(Boolean isTogether) {
        this.isTogether = isTogether;
    }

    @Generated
    public void setIsPagingBorder(Boolean isPagingBorder) {
        this.isPagingBorder = isPagingBorder;
    }

    @Generated
    public void setContentHorizontalAlignment(HorizontalAlignment contentHorizontalAlignment) {
        this.contentHorizontalAlignment = contentHorizontalAlignment;
    }

    @Generated
    public void setContentVerticalAlignment(VerticalAlignment contentVerticalAlignment) {
        this.contentVerticalAlignment = contentVerticalAlignment;
    }

    @Override
    @Generated
    public String toString() {
        return "Container(backgroundColor=" + this.getBackgroundColor() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", components=" + this.getComponents() + ", pagingEvent=" + this.getPagingEvent() + ", isTogether=" + this.getIsTogether() + ", isPagingBorder=" + this.getIsPagingBorder() + ", contentHorizontalAlignment=" + (Object)((Object)this.getContentHorizontalAlignment()) + ", contentVerticalAlignment=" + (Object)((Object)this.getContentVerticalAlignment()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Container)) {
            return false;
        }
        Container other = (Container)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$width = this.getWidth();
        Float other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Boolean this$isTogether = this.getIsTogether();
        Boolean other$isTogether = other.getIsTogether();
        if (this$isTogether == null ? other$isTogether != null : !((Object)this$isTogether).equals(other$isTogether)) {
            return false;
        }
        Boolean this$isPagingBorder = this.getIsPagingBorder();
        Boolean other$isPagingBorder = other.getIsPagingBorder();
        if (this$isPagingBorder == null ? other$isPagingBorder != null : !((Object)this$isPagingBorder).equals(other$isPagingBorder)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        List<Component> this$components = this.getComponents();
        List<Component> other$components = other.getComponents();
        if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
            return false;
        }
        PagingEvent this$pagingEvent = this.getPagingEvent();
        PagingEvent other$pagingEvent = other.getPagingEvent();
        if (this$pagingEvent == null ? other$pagingEvent != null : !this$pagingEvent.equals(other$pagingEvent)) {
            return false;
        }
        HorizontalAlignment this$contentHorizontalAlignment = this.getContentHorizontalAlignment();
        HorizontalAlignment other$contentHorizontalAlignment = other.getContentHorizontalAlignment();
        if (this$contentHorizontalAlignment == null ? other$contentHorizontalAlignment != null : !((Object)((Object)this$contentHorizontalAlignment)).equals((Object)other$contentHorizontalAlignment)) {
            return false;
        }
        VerticalAlignment this$contentVerticalAlignment = this.getContentVerticalAlignment();
        VerticalAlignment other$contentVerticalAlignment = other.getContentVerticalAlignment();
        return !(this$contentVerticalAlignment == null ? other$contentVerticalAlignment != null : !((Object)((Object)this$contentVerticalAlignment)).equals((Object)other$contentVerticalAlignment));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Container;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Boolean $isTogether = this.getIsTogether();
        result = result * 59 + ($isTogether == null ? 43 : ((Object)$isTogether).hashCode());
        Boolean $isPagingBorder = this.getIsPagingBorder();
        result = result * 59 + ($isPagingBorder == null ? 43 : ((Object)$isPagingBorder).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        List<Component> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        PagingEvent $pagingEvent = this.getPagingEvent();
        result = result * 59 + ($pagingEvent == null ? 43 : $pagingEvent.hashCode());
        HorizontalAlignment $contentHorizontalAlignment = this.getContentHorizontalAlignment();
        result = result * 59 + ($contentHorizontalAlignment == null ? 43 : ((Object)((Object)$contentHorizontalAlignment)).hashCode());
        VerticalAlignment $contentVerticalAlignment = this.getContentVerticalAlignment();
        result = result * 59 + ($contentVerticalAlignment == null ? 43 : ((Object)((Object)$contentVerticalAlignment)).hashCode());
        return result;
    }
}

