/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.Objects;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.dromara.pdf.pdfbox.core.base.BorderData;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;
import org.dromara.pdf.pdfbox.util.BorderUtil;
import org.dromara.pdf.pdfbox.util.CommonUtil;

public class Rectangle
extends AbstractComponent {
    protected Float width;
    protected Float height;
    protected Float angle;
    protected Float alpha;
    protected Color backgroundColor;

    public Rectangle(Page page) {
        super(page);
    }

    public void setWidth(float width) {
        if (width < 1.0f) {
            throw new IllegalArgumentException("the width can not be less than 1");
        }
        this.width = Float.valueOf(width);
    }

    public void setHeight(float height) {
        if (height < 1.0f) {
            throw new IllegalArgumentException("the height can not be less than 1");
        }
        this.height = Float.valueOf(height);
    }

    @Override
    public ComponentType getType() {
        return ComponentType.RECTANGLE;
    }

    @Override
    protected void init() {
        Objects.requireNonNull(this.width, "the width can not be null");
        Objects.requireNonNull(this.height, "the height can not be null");
        super.init();
        super.setIsBorder(true);
        if (Objects.isNull(this.angle)) {
            this.angle = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.alpha)) {
            this.alpha = Float.valueOf(1.0f);
        }
        this.initBeginXY(this.width.floatValue(), this.height.floatValue());
    }

    @Override
    protected float getMinWidth() {
        return this.getWidth().floatValue();
    }

    @Override
    protected void writeContents() {
        if (!this.getContext().getIsVirtualRender().booleanValue()) {
            PDPageContentStream contentStream = new PDPageContentStream(this.getContext().getTargetDocument(), this.getContext().getTargetPage(), this.getContentMode().getMode(), true, this.getIsResetContentStream().booleanValue());
            CommonUtil.initMatrix(contentStream, this.getBeginX().floatValue(), this.getBeginY().floatValue(), this.getRelativeBeginX().floatValue(), this.getRelativeBeginY().floatValue(), this.getWidth().floatValue(), this.getHeight().floatValue(), this.getAngle().floatValue(), this.getAlpha().floatValue());
            BorderUtil.drawNormalBorder(contentStream, CommonUtil.getRectangle(this.getWidth().floatValue(), this.getHeight().floatValue()), BorderData.create(this, this.getBorderConfiguration()));
            if (Objects.nonNull(this.getBackgroundColor())) {
                contentStream.addRect(this.getBorderConfiguration().getBorderLineWidth().floatValue() / 2.0f, this.getBorderConfiguration().getBorderLineWidth().floatValue() / 2.0f, this.getWidth().floatValue() - this.getBorderConfiguration().getBorderLineWidth().floatValue(), this.getHeight().floatValue() - this.getBorderConfiguration().getBorderLineWidth().floatValue());
                contentStream.setNonStrokingColor(this.getBackgroundColor());
                contentStream.fill();
            }
            contentStream.restoreGraphicsState();
            contentStream.close();
        }
    }

    @Override
    protected void reset() {
        float x = this.getBeginX().floatValue() + this.getWidth().floatValue() + this.getMarginRight().floatValue();
        float y = this.getBeginY().floatValue();
        super.reset(this.getType(), x, y);
    }

    @Generated
    public Float getWidth() {
        return this.width;
    }

    @Generated
    public Float getHeight() {
        return this.height;
    }

    @Generated
    public Float getAngle() {
        return this.angle;
    }

    @Generated
    public Float getAlpha() {
        return this.alpha;
    }

    @Generated
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public void setAngle(Float angle) {
        this.angle = angle;
    }

    @Generated
    public void setAlpha(Float alpha) {
        this.alpha = alpha;
    }

    @Generated
    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    @Generated
    public String toString() {
        return "Rectangle(width=" + this.getWidth() + ", height=" + this.getHeight() + ", angle=" + this.getAngle() + ", alpha=" + this.getAlpha() + ", backgroundColor=" + this.getBackgroundColor() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rectangle)) {
            return false;
        }
        Rectangle other = (Rectangle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$width = this.getWidth();
        Float other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Float this$angle = this.getAngle();
        Float other$angle = other.getAngle();
        if (this$angle == null ? other$angle != null : !((Object)this$angle).equals(other$angle)) {
            return false;
        }
        Float this$alpha = this.getAlpha();
        Float other$alpha = other.getAlpha();
        if (this$alpha == null ? other$alpha != null : !((Object)this$alpha).equals(other$alpha)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        return !(this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Rectangle;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Float $angle = this.getAngle();
        result = result * 59 + ($angle == null ? 43 : ((Object)$angle).hashCode());
        Float $alpha = this.getAlpha();
        result = result * 59 + ($alpha == null ? 43 : ((Object)$alpha).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        return result;
    }
}

