/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PagingEvent;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;
import org.dromara.pdf.pdfbox.core.component.BorderInfo;
import org.dromara.pdf.pdfbox.core.component.DefaultContainerPagingEvent;
import org.dromara.pdf.pdfbox.core.component.DefaultTablePagingEvent;
import org.dromara.pdf.pdfbox.core.component.TableFooter;
import org.dromara.pdf.pdfbox.core.component.TableHeader;
import org.dromara.pdf.pdfbox.core.component.TableRow;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;
import org.dromara.pdf.pdfbox.core.enums.HorizontalAlignment;
import org.dromara.pdf.pdfbox.core.enums.VerticalAlignment;
import org.dromara.pdf.pdfbox.util.CommonUtil;

public class Table
extends AbstractComponent {
    protected Color backgroundColor;
    protected TableHeader header;
    protected List<TableRow> rows;
    protected TableFooter footer;
    protected List<Float> cellWidths;
    protected PagingEvent pagingEvent;
    protected Boolean isTogether;
    protected Boolean isPagingBorder;
    protected Float contentMarginTop;
    protected Float contentMarginBottom;
    protected Float contentMarginLeft;
    protected Float contentMarginRight;
    protected HorizontalAlignment contentHorizontalAlignment;
    protected VerticalAlignment contentVerticalAlignment;

    public Table(Page page) {
        super(page);
    }

    public void setContentMargin(float margin) {
        this.contentMarginTop = Float.valueOf(margin);
        this.contentMarginBottom = Float.valueOf(margin);
        this.contentMarginLeft = Float.valueOf(margin);
        this.contentMarginRight = Float.valueOf(margin);
    }

    public void setCellWidths(float ... widths) {
        if (Objects.nonNull(widths)) {
            this.cellWidths = new ArrayList<Float>(widths.length);
            float[] fArray = widths;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                Float cellWidth = Float.valueOf(fArray[i]);
                if (Objects.isNull(cellWidth)) {
                    throw new IllegalArgumentException("the cell width can not be null");
                }
                if (cellWidth.floatValue() <= 0.0f) {
                    throw new IllegalArgumentException("the cell width must be greater than zero");
                }
                this.cellWidths.add(cellWidth);
            }
        } else {
            this.cellWidths = null;
        }
    }

    public void setCellWidths(List<Float> widths) {
        if (Objects.nonNull(widths)) {
            this.setCellWidths(CommonUtil.toFloatArray(widths));
        } else {
            this.cellWidths = null;
        }
    }

    public void setRows(List<TableRow> rows) {
        this.rows = rows;
    }

    public void setRows(TableRow ... rows) {
        if (Objects.nonNull(rows)) {
            this.rows = new ArrayList<TableRow>(rows.length);
            Collections.addAll(this.rows, rows);
        } else {
            this.rows = null;
        }
    }

    public void addRows(List<TableRow> rows) {
        if (Objects.nonNull(rows)) {
            if (Objects.isNull(this.rows)) {
                this.rows = new ArrayList<TableRow>(rows);
            } else {
                this.rows.addAll(rows);
            }
        }
    }

    public void addRows(TableRow ... rows) {
        if (Objects.nonNull(rows)) {
            if (Objects.isNull(this.rows)) {
                this.rows = new ArrayList<TableRow>(rows.length);
            }
            Collections.addAll(this.rows, rows);
        }
    }

    public Float getWidth() {
        if (Objects.isNull(this.cellWidths)) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf((float)this.cellWidths.stream().mapToDouble(Float::doubleValue).sum());
    }

    public Float getHeight() {
        if (Objects.isNull(this.rows)) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf((float)this.rows.stream().mapToDouble(TableRow::getHeight).sum());
    }

    @Override
    public ComponentType getType() {
        return ComponentType.TABLE;
    }

    @Override
    protected void init() {
        Objects.requireNonNull(this.cellWidths, "the cell widths can not be null");
        super.init();
        this.pagingEvent = new DefaultContainerPagingEvent();
        if (Objects.isNull(this.isTogether)) {
            this.isTogether = Boolean.FALSE;
        }
        if (Objects.isNull(this.isPagingBorder)) {
            this.isPagingBorder = Boolean.FALSE;
        }
        if (!this.isCustomPosition.booleanValue() && this.relativeBeginY.floatValue() == 0.0f) {
            this.relativeBeginY = Float.valueOf(this.getFirstRowHeight());
        }
        if (Objects.isNull(this.contentMarginTop)) {
            this.contentMarginTop = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.contentMarginBottom)) {
            this.contentMarginBottom = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.contentMarginLeft)) {
            this.contentMarginLeft = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.contentMarginRight)) {
            this.contentMarginRight = Float.valueOf(0.0f);
        }
        if (Objects.isNull((Object)this.contentHorizontalAlignment)) {
            this.contentHorizontalAlignment = HorizontalAlignment.LEFT;
        }
        if (Objects.isNull((Object)this.contentVerticalAlignment)) {
            this.contentVerticalAlignment = VerticalAlignment.TOP;
        }
        this.pagingEvents.add(new DefaultTablePagingEvent());
        this.initRows();
        this.checkWrap(this.getFirstRowHeight());
        if (this.checkPaging()) {
            this.setIsWrap(true);
            this.wrap(this.getFirstRowHeight());
        }
        this.initBeginX(this.getWidth().floatValue());
        this.initBeginY(this.getHeight().floatValue());
    }

    protected void initRows() {
        if (Objects.nonNull(this.rows)) {
            int last = this.rows.size() - 1;
            for (int i = 0; i < this.rows.size(); ++i) {
                TableRow tableRow = this.rows.get(i);
                tableRow.setIndex(i);
                if (i > 0) {
                    tableRow.setPrevious(this.rows.get(i - 1));
                }
                if (i >= last) continue;
                tableRow.setNext(this.rows.get(i + 1));
            }
        }
    }

    @Override
    protected float getMinWidth() {
        return this.getWidth().floatValue();
    }

    @Override
    protected void writeContents() {
        float beginX = this.getBeginX().floatValue() + this.getRelativeBeginX().floatValue();
        float beginY = this.getBeginY().floatValue() + this.getRelativeBeginY().floatValue();
        Page page = this.getPage();
        float top = this.getContext().getMaxBeginY();
        float bottom = this.getBottom() - this.getMarginBottom().floatValue();
        if (Objects.nonNull(this.getHeader())) {
            top -= this.getHeader().getHeight().floatValue();
            beginY = this.getHeader().render(page, beginX, beginY);
        }
        if (Objects.nonNull(this.getRows())) {
            for (TableRow tableRow : this.getRows()) {
                if (this.getContext().getIsVirtualRender().booleanValue()) {
                    tableRow.virtualRender(page, Float.valueOf(beginX), Float.valueOf(beginY));
                } else {
                    tableRow.render(page, Float.valueOf(beginX), Float.valueOf(beginY));
                }
                float height = tableRow.getHeight().floatValue();
                float lastHeight = this.getLastHeight(beginY, height, top, bottom);
                if (tableRow.getIsBreak().booleanValue() || !Objects.equals(Float.valueOf(height), Float.valueOf(lastHeight)) || beginY == 0.0f) {
                    Integer pagingCount = this.getContext().getBorderInfo().getPagingCount();
                    page = pagingCount == 1 || tableRow.getIsBreak() != false ? page.getSubPage() : page.getLastSubPage();
                    beginY = this.getContext().getCursor().getY().floatValue();
                    continue;
                }
                beginY -= tableRow.getHeight().floatValue();
            }
        }
        this.reset(beginX, beginY);
    }

    @Override
    protected Page executeBreak() {
        Float beginX = this.getBeginX();
        PagingEvent borderPagingEvent = Optional.ofNullable(this.getContext().getBorderInfo()).map(BorderInfo::getPagingEvent).orElse(null);
        if (!this.getContext().getIsManualBreak().booleanValue()) {
            Optional.ofNullable(borderPagingEvent).ifPresent(event -> event.before(this));
        }
        Page page = super.executeBreak();
        if (!this.getContext().getIsManualBreak().booleanValue()) {
            Optional.ofNullable(borderPagingEvent).ifPresent(event -> event.after(this));
        }
        this.setBeginX(beginX);
        return page;
    }

    protected float getFirstRowHeight() {
        if (Objects.nonNull(this.header)) {
            return this.header.getHeight().floatValue();
        }
        return Optional.ofNullable(this.rows).map(rows -> ((TableRow)rows.get(0)).getHeight()).orElse(Float.valueOf(0.0f)).floatValue();
    }

    protected float getLastHeight(float beginY, float height, float top, float bottom) {
        if (beginY - height >= bottom) {
            return height;
        }
        height -= beginY - bottom;
        beginY = top;
        return this.getLastHeight(beginY, height, top, bottom);
    }

    @Override
    protected void reset() {
        this.getContext().resetWrapWidth(null);
        this.getContext().resetHeight(null);
    }

    protected void reset(float x, float y) {
        super.reset(this.getType(), x, y);
    }

    @Generated
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Generated
    public TableHeader getHeader() {
        return this.header;
    }

    @Generated
    public List<TableRow> getRows() {
        return this.rows;
    }

    @Generated
    public TableFooter getFooter() {
        return this.footer;
    }

    @Generated
    public List<Float> getCellWidths() {
        return this.cellWidths;
    }

    @Generated
    public PagingEvent getPagingEvent() {
        return this.pagingEvent;
    }

    @Generated
    public Boolean getIsTogether() {
        return this.isTogether;
    }

    @Generated
    public Boolean getIsPagingBorder() {
        return this.isPagingBorder;
    }

    @Generated
    public Float getContentMarginTop() {
        return this.contentMarginTop;
    }

    @Generated
    public Float getContentMarginBottom() {
        return this.contentMarginBottom;
    }

    @Generated
    public Float getContentMarginLeft() {
        return this.contentMarginLeft;
    }

    @Generated
    public Float getContentMarginRight() {
        return this.contentMarginRight;
    }

    @Generated
    public HorizontalAlignment getContentHorizontalAlignment() {
        return this.contentHorizontalAlignment;
    }

    @Generated
    public VerticalAlignment getContentVerticalAlignment() {
        return this.contentVerticalAlignment;
    }

    @Generated
    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Generated
    public void setHeader(TableHeader header) {
        this.header = header;
    }

    @Generated
    public void setFooter(TableFooter footer) {
        this.footer = footer;
    }

    @Generated
    public void setPagingEvent(PagingEvent pagingEvent) {
        this.pagingEvent = pagingEvent;
    }

    @Generated
    public void setIsTogether(Boolean isTogether) {
        this.isTogether = isTogether;
    }

    @Generated
    public void setIsPagingBorder(Boolean isPagingBorder) {
        this.isPagingBorder = isPagingBorder;
    }

    @Generated
    public void setContentMarginTop(Float contentMarginTop) {
        this.contentMarginTop = contentMarginTop;
    }

    @Generated
    public void setContentMarginBottom(Float contentMarginBottom) {
        this.contentMarginBottom = contentMarginBottom;
    }

    @Generated
    public void setContentMarginLeft(Float contentMarginLeft) {
        this.contentMarginLeft = contentMarginLeft;
    }

    @Generated
    public void setContentMarginRight(Float contentMarginRight) {
        this.contentMarginRight = contentMarginRight;
    }

    @Generated
    public void setContentHorizontalAlignment(HorizontalAlignment contentHorizontalAlignment) {
        this.contentHorizontalAlignment = contentHorizontalAlignment;
    }

    @Generated
    public void setContentVerticalAlignment(VerticalAlignment contentVerticalAlignment) {
        this.contentVerticalAlignment = contentVerticalAlignment;
    }

    @Override
    @Generated
    public String toString() {
        return "Table(backgroundColor=" + this.getBackgroundColor() + ", header=" + this.getHeader() + ", rows=" + this.getRows() + ", footer=" + this.getFooter() + ", cellWidths=" + this.getCellWidths() + ", pagingEvent=" + this.getPagingEvent() + ", isTogether=" + this.getIsTogether() + ", isPagingBorder=" + this.getIsPagingBorder() + ", contentMarginTop=" + this.getContentMarginTop() + ", contentMarginBottom=" + this.getContentMarginBottom() + ", contentMarginLeft=" + this.getContentMarginLeft() + ", contentMarginRight=" + this.getContentMarginRight() + ", contentHorizontalAlignment=" + (Object)((Object)this.getContentHorizontalAlignment()) + ", contentVerticalAlignment=" + (Object)((Object)this.getContentVerticalAlignment()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isTogether = this.getIsTogether();
        Boolean other$isTogether = other.getIsTogether();
        if (this$isTogether == null ? other$isTogether != null : !((Object)this$isTogether).equals(other$isTogether)) {
            return false;
        }
        Boolean this$isPagingBorder = this.getIsPagingBorder();
        Boolean other$isPagingBorder = other.getIsPagingBorder();
        if (this$isPagingBorder == null ? other$isPagingBorder != null : !((Object)this$isPagingBorder).equals(other$isPagingBorder)) {
            return false;
        }
        Float this$contentMarginTop = this.getContentMarginTop();
        Float other$contentMarginTop = other.getContentMarginTop();
        if (this$contentMarginTop == null ? other$contentMarginTop != null : !((Object)this$contentMarginTop).equals(other$contentMarginTop)) {
            return false;
        }
        Float this$contentMarginBottom = this.getContentMarginBottom();
        Float other$contentMarginBottom = other.getContentMarginBottom();
        if (this$contentMarginBottom == null ? other$contentMarginBottom != null : !((Object)this$contentMarginBottom).equals(other$contentMarginBottom)) {
            return false;
        }
        Float this$contentMarginLeft = this.getContentMarginLeft();
        Float other$contentMarginLeft = other.getContentMarginLeft();
        if (this$contentMarginLeft == null ? other$contentMarginLeft != null : !((Object)this$contentMarginLeft).equals(other$contentMarginLeft)) {
            return false;
        }
        Float this$contentMarginRight = this.getContentMarginRight();
        Float other$contentMarginRight = other.getContentMarginRight();
        if (this$contentMarginRight == null ? other$contentMarginRight != null : !((Object)this$contentMarginRight).equals(other$contentMarginRight)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        TableHeader this$header = this.getHeader();
        TableHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        List<TableRow> this$rows = this.getRows();
        List<TableRow> other$rows = other.getRows();
        if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
            return false;
        }
        TableFooter this$footer = this.getFooter();
        TableFooter other$footer = other.getFooter();
        if (this$footer == null ? other$footer != null : !((Object)this$footer).equals(other$footer)) {
            return false;
        }
        List<Float> this$cellWidths = this.getCellWidths();
        List<Float> other$cellWidths = other.getCellWidths();
        if (this$cellWidths == null ? other$cellWidths != null : !((Object)this$cellWidths).equals(other$cellWidths)) {
            return false;
        }
        PagingEvent this$pagingEvent = this.getPagingEvent();
        PagingEvent other$pagingEvent = other.getPagingEvent();
        if (this$pagingEvent == null ? other$pagingEvent != null : !this$pagingEvent.equals(other$pagingEvent)) {
            return false;
        }
        HorizontalAlignment this$contentHorizontalAlignment = this.getContentHorizontalAlignment();
        HorizontalAlignment other$contentHorizontalAlignment = other.getContentHorizontalAlignment();
        if (this$contentHorizontalAlignment == null ? other$contentHorizontalAlignment != null : !((Object)((Object)this$contentHorizontalAlignment)).equals((Object)other$contentHorizontalAlignment)) {
            return false;
        }
        VerticalAlignment this$contentVerticalAlignment = this.getContentVerticalAlignment();
        VerticalAlignment other$contentVerticalAlignment = other.getContentVerticalAlignment();
        return !(this$contentVerticalAlignment == null ? other$contentVerticalAlignment != null : !((Object)((Object)this$contentVerticalAlignment)).equals((Object)other$contentVerticalAlignment));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Table;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isTogether = this.getIsTogether();
        result = result * 59 + ($isTogether == null ? 43 : ((Object)$isTogether).hashCode());
        Boolean $isPagingBorder = this.getIsPagingBorder();
        result = result * 59 + ($isPagingBorder == null ? 43 : ((Object)$isPagingBorder).hashCode());
        Float $contentMarginTop = this.getContentMarginTop();
        result = result * 59 + ($contentMarginTop == null ? 43 : ((Object)$contentMarginTop).hashCode());
        Float $contentMarginBottom = this.getContentMarginBottom();
        result = result * 59 + ($contentMarginBottom == null ? 43 : ((Object)$contentMarginBottom).hashCode());
        Float $contentMarginLeft = this.getContentMarginLeft();
        result = result * 59 + ($contentMarginLeft == null ? 43 : ((Object)$contentMarginLeft).hashCode());
        Float $contentMarginRight = this.getContentMarginRight();
        result = result * 59 + ($contentMarginRight == null ? 43 : ((Object)$contentMarginRight).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        TableHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        List<TableRow> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        TableFooter $footer = this.getFooter();
        result = result * 59 + ($footer == null ? 43 : ((Object)$footer).hashCode());
        List<Float> $cellWidths = this.getCellWidths();
        result = result * 59 + ($cellWidths == null ? 43 : ((Object)$cellWidths).hashCode());
        PagingEvent $pagingEvent = this.getPagingEvent();
        result = result * 59 + ($pagingEvent == null ? 43 : $pagingEvent.hashCode());
        HorizontalAlignment $contentHorizontalAlignment = this.getContentHorizontalAlignment();
        result = result * 59 + ($contentHorizontalAlignment == null ? 43 : ((Object)((Object)$contentHorizontalAlignment)).hashCode());
        VerticalAlignment $contentVerticalAlignment = this.getContentVerticalAlignment();
        result = result * 59 + ($contentVerticalAlignment == null ? 43 : ((Object)((Object)$contentVerticalAlignment)).hashCode());
        return result;
    }
}

