/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.util.Matrix;
import org.dromara.pdf.pdfbox.core.base.AbstractBase;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.config.FontConfiguration;
import org.dromara.pdf.pdfbox.core.component.Watermark;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;
import org.dromara.pdf.pdfbox.core.enums.FontStyle;
import org.dromara.pdf.pdfbox.core.ext.handler.AbstractTextHandler;
import org.dromara.pdf.pdfbox.support.Constants;
import org.dromara.pdf.pdfbox.util.CommonUtil;
import org.dromara.pdf.pdfbox.util.TextUtil;

public class TextareaWatermark
extends AbstractBase
implements Watermark {
    protected FontConfiguration fontConfiguration = new FontConfiguration();
    protected AbstractTextHandler textHandler;
    protected Float beginX;
    protected Float beginY;
    protected Integer lines;
    protected Integer countOfLine;
    protected Float spacingOfLine;
    protected Integer tabSize;
    protected List<String> textList;
    protected Float angle;

    public TextareaWatermark(Document document) {
        super.setContext(document.getContext());
        this.setLeading(100.0f);
        this.setFontSize(20.0f);
        this.setFontAlpha(0.5f);
        this.setFontColor(Color.GRAY);
    }

    public void setTextHandler(AbstractTextHandler handler) {
        Objects.requireNonNull(handler, "the handler can not be null");
        this.textHandler = handler;
    }

    public void setTabSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("the size can not be less than 0");
        }
        this.tabSize = size;
    }

    public void setTexts(String ... texts) {
        if (Objects.nonNull(texts)) {
            this.textList = new ArrayList<String>(texts.length);
            Collections.addAll(this.textList, texts);
        }
    }

    @Override
    public ComponentType getType() {
        return ComponentType.WATERMARK;
    }

    public Page getPage() {
        return this.getContext().getPage();
    }

    public PDFont getFont() {
        return this.getContext().getFont(this.fontConfiguration.getFontName());
    }

    public String getFontName() {
        return this.fontConfiguration.getFontName();
    }

    public void setFontName(String fontName) {
        this.fontConfiguration.setFontName(fontName);
        this.getContext().addFontCache(fontName);
    }

    public List<String> getSpecialFontNames() {
        return this.fontConfiguration.getSpecialFontNames();
    }

    public void setSpecialFontNames(String ... fontNames) {
        this.getContext().addFontCache(fontNames);
        Collections.addAll(this.fontConfiguration.getSpecialFontNames(), fontNames);
    }

    public Float getFontSize() {
        return this.fontConfiguration.getFontSize();
    }

    public void setFontSize(float size) {
        this.fontConfiguration.setFontSize(size);
    }

    public Color getFontColor() {
        return this.fontConfiguration.getFontColor();
    }

    public void setFontColor(Color color) {
        this.fontConfiguration.setFontColor(color);
    }

    public Color getStrokColor() {
        return this.fontConfiguration.getStrokColor();
    }

    public void setStrokColor(Color color) {
        this.fontConfiguration.setStrokColor(color);
    }

    public Float getFontAlpha() {
        return this.fontConfiguration.getFontAlpha();
    }

    public void setFontAlpha(float alpha) {
        this.fontConfiguration.setFontAlpha(Float.valueOf(alpha));
    }

    public FontStyle getFontStyle() {
        return this.fontConfiguration.getFontStyle();
    }

    public void setFontStyle(FontStyle style) {
        this.fontConfiguration.setFontStyle(style);
        if (style.isItalic() && this.getFontSlope().floatValue() == 0.0f) {
            this.setFontSlope(Constants.DEFAULT_FONT_ITALIC_SLOPE.floatValue());
        }
    }

    public Float getFontSlope() {
        return this.fontConfiguration.getFontSlope();
    }

    public void setFontSlope(float slope) {
        this.fontConfiguration.setFontSlope(Float.valueOf(slope));
    }

    public Float getCharacterSpacing() {
        return this.fontConfiguration.getCharacterSpacing();
    }

    public void setCharacterSpacing(float spacing) {
        this.fontConfiguration.setCharacterSpacing(spacing);
    }

    public Float getLeading() {
        return this.fontConfiguration.getLeading();
    }

    public void setLeading(float leading) {
        this.fontConfiguration.setLeading(leading);
    }

    @Override
    public void render(Page page) {
        Objects.requireNonNull(page, "the page can not be null");
        this.init(page);
        this.renderText(page);
    }

    @Override
    public void render(Document document) {
        Objects.requireNonNull(document, "the document can not be null");
        document.getPages().forEach(this::render);
    }

    protected void init(Page page) {
        if (Objects.isNull(this.textList) || this.textList.isEmpty()) {
            throw new IllegalArgumentException("the text list can not be empty");
        }
        super.init(page);
        if (Objects.nonNull(this.fontConfiguration.getSpecialFontNames())) {
            for (String specialFontName : this.fontConfiguration.getSpecialFontNames()) {
                this.getContext().addFontCache(specialFontName);
            }
        }
        if (Objects.isNull(this.textHandler)) {
            this.textHandler = this.getContext().getTextHandler();
        }
        if (Objects.isNull((Object)this.getContext().getExecutingComponentType())) {
            this.getContext().setExecutingComponentType(this.getType());
        }
        if (Objects.isNull(this.spacingOfLine)) {
            this.spacingOfLine = Float.valueOf(100.0f);
        }
        if (Objects.isNull(this.countOfLine)) {
            int length = this.textList.get(0).length();
            int characterSpacingLength = length - 1;
            float textWidth = (float)length * this.getFontSize().floatValue() + (float)characterSpacingLength * this.getCharacterSpacing().floatValue() + this.spacingOfLine.floatValue();
            this.countOfLine = (int)Math.ceil(this.getPage().getWidth().floatValue() / textWidth);
        }
        if (Objects.isNull(this.lines)) {
            int count = this.textList.size();
            int leadingCount = count - 1;
            float textHeight = (float)count * this.getFontSize().floatValue() + (float)leadingCount * this.getLeading().floatValue();
            this.lines = (int)Math.ceil(this.getPage().getHeight().floatValue() / textHeight);
        }
        if (Objects.isNull(this.tabSize)) {
            this.tabSize = 2;
        }
        if (Objects.isNull(this.angle)) {
            this.angle = Float.valueOf(45.0f);
        }
        if (Objects.isNull(this.beginX)) {
            this.beginX = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.beginY)) {
            this.beginY = Float.valueOf(page.getHeight().floatValue() - this.getFontSize().floatValue());
        }
    }

    protected void renderText(Page page) {
        float beginX = this.getBeginX().floatValue();
        float beginY = this.getBeginY().floatValue();
        float maxWidth = 0.0f;
        boolean initFlag = true;
        PDPageContentStream stream = this.initContentStream(page);
        for (int i = 0; i < this.getLines(); ++i) {
            float lastBeginY = beginY;
            for (int j = 0; j < this.getCountOfLine(); ++j) {
                for (String text : this.getTextList()) {
                    String writeText = TextUtil.replaceTab(text, this.getTabSize());
                    stream.beginText();
                    CommonUtil.initFontColorAndAlpha(stream, this.getPage().getBackgroundColor(), this.getFontStyle(), this.getFontColor(), this.getStrokColor(), this.getFontAlpha().floatValue());
                    this.initPosition(stream, beginX, beginY);
                    this.getTextHandler().writeText(this.getFontConfiguration(), stream, text);
                    stream.endText();
                    beginY -= this.getFontSize().floatValue();
                    if (!initFlag) continue;
                    maxWidth = Math.max(maxWidth, this.getTextHandler().getTextWidth(this.getFontConfiguration(), writeText));
                }
                beginX = beginX + maxWidth + this.getSpacingOfLine().floatValue();
                if (j < this.getCountOfLine() - 1) {
                    beginY = lastBeginY;
                }
                initFlag = false;
            }
            beginX = this.getBeginX().floatValue();
            beginY -= this.getLeading().floatValue();
        }
        stream.close();
    }

    protected PDPageContentStream initContentStream(Page page) {
        Context context = this.getContext();
        PDPageContentStream contentStream = new PDPageContentStream(context.getTargetDocument(), page.getTarget(), this.getContentMode().getMode(), true, this.getIsResetContentStream().booleanValue());
        contentStream.setFont(this.getFont(), this.getFontSize().floatValue());
        contentStream.setRenderingMode(this.getFontStyle().getMode());
        contentStream.setCharacterSpacing(this.getCharacterSpacing().floatValue());
        contentStream.setLineWidth(CommonUtil.initLineWidth(this.getFontStyle()));
        return contentStream;
    }

    protected void initPosition(PDPageContentStream stream, float beginX, float beginY) {
        Matrix matrix = new Matrix(1.0f, 0.0f, this.getFontSlope().floatValue(), 1.0f, beginX, beginY);
        matrix.rotate(Math.toRadians(this.getAngle().floatValue()));
        stream.setTextMatrix(matrix);
    }

    @Generated
    public FontConfiguration getFontConfiguration() {
        return this.fontConfiguration;
    }

    @Generated
    public AbstractTextHandler getTextHandler() {
        return this.textHandler;
    }

    @Generated
    public Float getBeginX() {
        return this.beginX;
    }

    @Generated
    public Float getBeginY() {
        return this.beginY;
    }

    @Generated
    public Integer getLines() {
        return this.lines;
    }

    @Generated
    public Integer getCountOfLine() {
        return this.countOfLine;
    }

    @Generated
    public Float getSpacingOfLine() {
        return this.spacingOfLine;
    }

    @Generated
    public Integer getTabSize() {
        return this.tabSize;
    }

    @Generated
    public List<String> getTextList() {
        return this.textList;
    }

    @Generated
    public Float getAngle() {
        return this.angle;
    }

    @Generated
    public void setFontConfiguration(FontConfiguration fontConfiguration) {
        this.fontConfiguration = fontConfiguration;
    }

    @Generated
    public void setBeginX(Float beginX) {
        this.beginX = beginX;
    }

    @Generated
    public void setBeginY(Float beginY) {
        this.beginY = beginY;
    }

    @Generated
    public void setLines(Integer lines) {
        this.lines = lines;
    }

    @Generated
    public void setCountOfLine(Integer countOfLine) {
        this.countOfLine = countOfLine;
    }

    @Generated
    public void setSpacingOfLine(Float spacingOfLine) {
        this.spacingOfLine = spacingOfLine;
    }

    @Generated
    public void setTextList(List<String> textList) {
        this.textList = textList;
    }

    @Generated
    public void setAngle(Float angle) {
        this.angle = angle;
    }

    @Override
    @Generated
    public String toString() {
        return "TextareaWatermark(fontConfiguration=" + this.getFontConfiguration() + ", textHandler=" + this.getTextHandler() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", lines=" + this.getLines() + ", countOfLine=" + this.getCountOfLine() + ", spacingOfLine=" + this.getSpacingOfLine() + ", tabSize=" + this.getTabSize() + ", textList=" + this.getTextList() + ", angle=" + this.getAngle() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextareaWatermark)) {
            return false;
        }
        TextareaWatermark other = (TextareaWatermark)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Integer this$lines = this.getLines();
        Integer other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
            return false;
        }
        Integer this$countOfLine = this.getCountOfLine();
        Integer other$countOfLine = other.getCountOfLine();
        if (this$countOfLine == null ? other$countOfLine != null : !((Object)this$countOfLine).equals(other$countOfLine)) {
            return false;
        }
        Float this$spacingOfLine = this.getSpacingOfLine();
        Float other$spacingOfLine = other.getSpacingOfLine();
        if (this$spacingOfLine == null ? other$spacingOfLine != null : !((Object)this$spacingOfLine).equals(other$spacingOfLine)) {
            return false;
        }
        Integer this$tabSize = this.getTabSize();
        Integer other$tabSize = other.getTabSize();
        if (this$tabSize == null ? other$tabSize != null : !((Object)this$tabSize).equals(other$tabSize)) {
            return false;
        }
        Float this$angle = this.getAngle();
        Float other$angle = other.getAngle();
        if (this$angle == null ? other$angle != null : !((Object)this$angle).equals(other$angle)) {
            return false;
        }
        FontConfiguration this$fontConfiguration = this.getFontConfiguration();
        FontConfiguration other$fontConfiguration = other.getFontConfiguration();
        if (this$fontConfiguration == null ? other$fontConfiguration != null : !((Object)this$fontConfiguration).equals(other$fontConfiguration)) {
            return false;
        }
        AbstractTextHandler this$textHandler = this.getTextHandler();
        AbstractTextHandler other$textHandler = other.getTextHandler();
        if (this$textHandler == null ? other$textHandler != null : !((Object)this$textHandler).equals(other$textHandler)) {
            return false;
        }
        List<String> this$textList = this.getTextList();
        List<String> other$textList = other.getTextList();
        return !(this$textList == null ? other$textList != null : !((Object)this$textList).equals(other$textList));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TextareaWatermark;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Integer $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        Integer $countOfLine = this.getCountOfLine();
        result = result * 59 + ($countOfLine == null ? 43 : ((Object)$countOfLine).hashCode());
        Float $spacingOfLine = this.getSpacingOfLine();
        result = result * 59 + ($spacingOfLine == null ? 43 : ((Object)$spacingOfLine).hashCode());
        Integer $tabSize = this.getTabSize();
        result = result * 59 + ($tabSize == null ? 43 : ((Object)$tabSize).hashCode());
        Float $angle = this.getAngle();
        result = result * 59 + ($angle == null ? 43 : ((Object)$angle).hashCode());
        FontConfiguration $fontConfiguration = this.getFontConfiguration();
        result = result * 59 + ($fontConfiguration == null ? 43 : ((Object)$fontConfiguration).hashCode());
        AbstractTextHandler $textHandler = this.getTextHandler();
        result = result * 59 + ($textHandler == null ? 43 : ((Object)$textHandler).hashCode());
        List<String> $textList = this.getTextList();
        result = result * 59 + ($textList == null ? 43 : ((Object)$textList).hashCode());
        return result;
    }
}

