/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.extractor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.extractor.AbstractExtractor;

public abstract class AbstractBookmarkExtractor
extends AbstractExtractor {
    public AbstractBookmarkExtractor(Document document) {
        super(document);
    }

    public abstract Map<Integer, PDOutlineItem> extract(int ... var1);

    protected Map<Integer, PDOutlineItem> processBookmark(int ... bookmarkIndexes) {
        HashMap<Integer, PDOutlineItem> data;
        block7: {
            data = new HashMap<Integer, PDOutlineItem>(32);
            PDDocumentCatalog documentCatalog = this.getDocument().getDocumentCatalog();
            PDDocumentOutline documentOutline = documentCatalog.getDocumentOutline();
            if (!Objects.nonNull(documentOutline)) break block7;
            int index = 0;
            Iterable items = documentOutline.children();
            if (Objects.nonNull(bookmarkIndexes) && bookmarkIndexes.length > 0) {
                PrimitiveIterator.OfInt iterator = Arrays.stream(bookmarkIndexes).sorted().iterator();
                int bookmarkIndex = 0;
                for (PDOutlineItem outlineItem : items) {
                    if (index < bookmarkIndex) {
                        ++index;
                        continue;
                    }
                    if (iterator.hasNext()) {
                        bookmarkIndex = iterator.next();
                        if (index == bookmarkIndex) {
                            data.put(index, outlineItem);
                        }
                        ++index;
                        continue;
                    }
                    break;
                }
            } else {
                for (PDOutlineItem outlineItem : items) {
                    data.put(index, outlineItem);
                    ++index;
                }
            }
        }
        return data;
    }
}

