/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.config.FontConfiguration;
import org.dromara.pdf.pdfbox.core.ext.AbstractExpander;
import org.dromara.pdf.pdfbox.support.CharacterList;
import org.dromara.pdf.pdfbox.support.Constants;

public abstract class AbstractTextHandler
extends AbstractExpander {
    public AbstractTextHandler(Document document) {
        super(document);
    }

    public abstract void writeText(FontConfiguration var1, PDPageContentStream var2, String var3);

    public String splitText(FontConfiguration fontConfiguration, String text, float lineWidth) {
        if (Objects.isNull(text) || lineWidth - fontConfiguration.getFontSize().floatValue() < 0.0f) {
            return null;
        }
        int fontCount = Math.max(1, (int)(lineWidth / (fontConfiguration.getFontSize().floatValue() + fontConfiguration.getCharacterSpacing().floatValue())));
        int beginIndex = 0;
        int len = text.length();
        for (int i = fontCount; i <= len; ++i) {
            String tempText = text.substring(beginIndex, i);
            float lineRealWidth = this.getTextWidth(fontConfiguration, tempText);
            if (!(lineRealWidth > lineWidth)) continue;
            return text.substring(beginIndex, i - 1);
        }
        return text;
    }

    public List<String> splitLines(FontConfiguration fontConfiguration, String text, float lineWidth) {
        if (Objects.isNull(text) || lineWidth - fontConfiguration.getFontSize().floatValue() < 0.0f) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> lineList = new ArrayList<String>(1024);
        int fontCount = Math.max(1, (int)(lineWidth / (fontConfiguration.getFontSize().floatValue() + fontConfiguration.getCharacterSpacing().floatValue())));
        int beginIndex = 0;
        int len = text.length();
        for (int i = fontCount; i <= len; ++i) {
            String tempText = text.substring(beginIndex, i);
            float lineRealWidth = this.getTextWidth(fontConfiguration, tempText);
            if (!(lineRealWidth > lineWidth)) continue;
            lineList.add(text.substring(beginIndex, i - 1));
            beginIndex = i - 1;
            i = i + fontCount - 1;
            if (i < len) continue;
            lineList.add(text.substring(beginIndex));
        }
        if (beginIndex + fontCount < text.length() || lineList.isEmpty()) {
            lineList.add(text.substring(beginIndex));
        }
        return lineList;
    }

    public float getTextWidth(FontConfiguration fontConfiguration, String text) {
        if (Objects.isNull(text)) {
            return 0.0f;
        }
        List<String> specialFontNames = fontConfiguration.getSpecialFontNames();
        PDFont font = this.getContext().getFont(fontConfiguration.getFontName());
        Float fontSize = fontConfiguration.getFontSize();
        Float characterSpacing = fontConfiguration.getCharacterSpacing();
        float width = 0.0f;
        CharacterList list = CharacterList.create(text);
        while (list.hasNext()) {
            list = list.getNext();
            Character character = list.getData();
            try {
                width += font.getCharacterWidth(character);
            }
            catch (Exception e) {
                boolean flag = true;
                if (Objects.nonNull(specialFontNames)) {
                    for (String specialFontName : specialFontNames) {
                        try {
                            width += this.getContext().getFont(specialFontName).getCharacterWidth(character);
                            flag = false;
                            break;
                        }
                        catch (Exception exception) {
                        }
                    }
                    if (flag && list.hasNext()) {
                        Character next = list.getNext().getData();
                        String str = String.valueOf(new char[]{character.charValue(), next.charValue()});
                        for (String specialFontName : specialFontNames) {
                            try {
                                width += this.getContext().getFont(specialFontName).getStringWidth(str);
                                flag = false;
                                break;
                            }
                            catch (Exception exception) {
                            }
                        }
                        if (!flag) {
                            list.skipNext();
                        }
                    }
                }
                if (!flag) continue;
                width += this.getContext().getFont("HarmonyOS Sans SC").getCharacterWidth(Constants.DEFAULT_UNKNOWN_CHARACTER);
            }
        }
        return width == 0.0f ? 0.0f : fontSize.floatValue() * width / 1000.0f + (float)(text.length() - 1) * characterSpacing.floatValue();
    }

    public float getTextHeight(FontConfiguration fontConfiguration, int rowCount) {
        if (rowCount == 0) {
            return 0.0f;
        }
        if (rowCount == 1) {
            return fontConfiguration.getFontSize().floatValue();
        }
        int leadingCount = rowCount - 1;
        return (float)rowCount * fontConfiguration.getFontSize().floatValue() + (float)leadingCount * fontConfiguration.getLeading().floatValue();
    }

    protected Context getContext() {
        return this.document.getContext();
    }

    @Generated
    public String toString() {
        return "AbstractTextHandler()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTextHandler)) {
            return false;
        }
        AbstractTextHandler other = (AbstractTextHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractTextHandler;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

