/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.handler;

import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.config.FontConfiguration;
import org.dromara.pdf.pdfbox.core.ext.handler.AbstractTextHandler;
import org.dromara.pdf.pdfbox.support.CharacterList;
import org.dromara.pdf.pdfbox.support.Constants;

public class TextHandler
extends AbstractTextHandler {
    public TextHandler(Document document) {
        super(document);
    }

    @Override
    public void writeText(FontConfiguration fontConfiguration, PDPageContentStream contentStream, String text) {
        List<String> specialFontNames = fontConfiguration.getSpecialFontNames();
        PDFont font = this.getContext().getFont(fontConfiguration.getFontName());
        Float fontSize = fontConfiguration.getFontSize();
        CharacterList list = CharacterList.create(text);
        while (list.hasNext()) {
            list = list.getNext();
            this.process(contentStream, list, specialFontNames, font, fontSize);
        }
    }

    protected void process(PDPageContentStream contentStream, CharacterList list, List<String> specialFontNames, PDFont font, Float fontSize) {
        block5: {
            Character character = list.getData();
            try {
                contentStream.showCharacter(character);
            }
            catch (Exception e) {
                boolean flag = this.processSingle(contentStream, character, specialFontNames, font, fontSize);
                if (!flag || !list.hasNext()) break block5;
                Character next = list.getNext().getData();
                flag = this.processDouble(contentStream, character, next, specialFontNames, font, fontSize);
                if (flag) {
                    contentStream.setFont(this.getContext().getFont("HarmonyOS Sans SC"), fontSize.floatValue());
                    contentStream.showCharacter(Constants.DEFAULT_UNKNOWN_CHARACTER);
                    contentStream.setFont(font, fontSize.floatValue());
                    break block5;
                }
                list.skipNext();
            }
        }
    }

    protected boolean processSingle(PDPageContentStream contentStream, Character character, List<String> specialFontNames, PDFont font, Float fontSize) {
        boolean flag = true;
        if (Objects.nonNull(specialFontNames)) {
            for (String specialFontName : specialFontNames) {
                try {
                    contentStream.setFont(this.getContext().getFont(specialFontName), fontSize.floatValue());
                    contentStream.showCharacter(character);
                    flag = false;
                    break;
                }
                catch (Exception exception) {
                }
            }
            contentStream.setFont(font, fontSize.floatValue());
        }
        return flag;
    }

    protected boolean processDouble(PDPageContentStream contentStream, Character character, Character next, List<String> specialFontNames, PDFont font, Float fontSize) {
        boolean flag = true;
        if (Objects.nonNull(specialFontNames)) {
            String joinStr = String.valueOf(new char[]{character.charValue(), next.charValue()});
            for (String specialFontName : specialFontNames) {
                try {
                    contentStream.setFont(this.getContext().getFont(specialFontName), fontSize.floatValue());
                    contentStream.showText(joinStr);
                    flag = false;
                    break;
                }
                catch (Exception exception) {
                }
            }
            contentStream.setFont(font, fontSize.floatValue());
        }
        return flag;
    }
}

