/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.AdobePDFSchema;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.schema.XMPMediaManagementSchema;
import org.apache.xmpbox.schema.XMPRightsManagementSchema;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpSerializer;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;

public class MetadataProcessor
extends AbstractProcessor {
    protected PDMetadata metadata;
    protected XMPMetadata xmpMetadata;
    protected AdobePDFSchema adobeSchema;
    protected XMPBasicSchema basicSchema;
    protected DublinCoreSchema dcSchema;
    protected XMPRightsManagementSchema rmSchema;
    protected XMPMediaManagementSchema mmSchema;

    public MetadataProcessor(Document document) {
        super(document);
        this.initMetadata();
    }

    public String getPDFVersion() {
        return Objects.isNull(this.adobeSchema) ? null : this.adobeSchema.getPDFVersion();
    }

    public String getProducer() {
        return Objects.isNull(this.adobeSchema) ? null : this.adobeSchema.getProducer();
    }

    public String getKeywords() {
        return Objects.isNull(this.adobeSchema) ? null : this.adobeSchema.getKeywords();
    }

    public Calendar getCreateDate() {
        return Objects.isNull(this.basicSchema) ? null : this.basicSchema.getCreateDate();
    }

    public Calendar getModifyDate() {
        return Objects.isNull(this.basicSchema) ? null : this.basicSchema.getModifyDate();
    }

    public String getCreatorTool() {
        return Objects.isNull(this.basicSchema) ? null : this.basicSchema.getCreatorTool();
    }

    public String getTitle() {
        return Objects.isNull(this.dcSchema) ? null : this.dcSchema.getTitle();
    }

    public List<String> getAuthors() {
        return Objects.isNull(this.dcSchema) ? null : this.dcSchema.getCreators();
    }

    public String getSubject() {
        return Objects.isNull(this.dcSchema) ? null : this.dcSchema.getDescription();
    }

    public String getFormat() {
        return Objects.isNull(this.dcSchema) ? null : this.dcSchema.getFormat();
    }

    public String getRights() {
        return Objects.isNull(this.dcSchema) ? null : this.dcSchema.getRights();
    }

    public Boolean getRightsMarked() {
        return Objects.isNull(this.rmSchema) ? null : this.rmSchema.getMarked();
    }

    public String getRightsUrl() {
        return Objects.isNull(this.rmSchema) ? null : this.rmSchema.getWebStatement();
    }

    public String getDocumentID() {
        return Objects.isNull(this.mmSchema) ? null : this.mmSchema.getDocumentID();
    }

    public String getOriginalDocumentID() {
        return Objects.isNull(this.mmSchema) ? null : this.mmSchema.getOriginalDocumentID();
    }

    public String getInstanceID() {
        return Objects.isNull(this.mmSchema) ? null : this.mmSchema.getInstanceID();
    }

    public void setPDFVersion(float version) {
        this.document.setVersion(version);
        if (Objects.isNull(this.adobeSchema)) {
            this.adobeSchema = this.xmpMetadata.createAndAddAdobePDFSchema();
        }
        this.adobeSchema.setProducer(String.valueOf(version));
    }

    public void setKeywords(String ... keywords) {
        Objects.requireNonNull(keywords, "the keywords can not be null");
        if (Objects.isNull(this.adobeSchema)) {
            this.adobeSchema = this.xmpMetadata.createAndAddAdobePDFSchema();
        }
        Optional.ofNullable(this.adobeSchema.getKeywordsProperty()).ifPresent(arg_0 -> ((AdobePDFSchema)this.adobeSchema).removeProperty(arg_0));
        if (Objects.isNull(this.dcSchema)) {
            this.dcSchema = this.xmpMetadata.createAndAddDublinCoreSchema();
        }
        Optional.ofNullable(this.dcSchema.getSubjectsProperty()).ifPresent(arg_0 -> ((DublinCoreSchema)this.dcSchema).removeProperty(arg_0));
        Arrays.stream(keywords).forEach(arg_0 -> ((DublinCoreSchema)this.dcSchema).addSubject(arg_0));
    }

    public void setProducer(String producer) {
        Objects.requireNonNull(producer, "the producer can not be null");
        if (Objects.isNull(this.adobeSchema)) {
            this.adobeSchema = this.xmpMetadata.createAndAddAdobePDFSchema();
        }
        this.adobeSchema.setProducer(producer);
    }

    public void setCreateDate(Calendar date) {
        Objects.requireNonNull(date, "the date can not be null");
        if (Objects.isNull(this.basicSchema)) {
            this.basicSchema = this.xmpMetadata.createAndAddXMPBasicSchema();
        }
        this.basicSchema.setCreateDate(date);
    }

    public void setModifyDate(Calendar date) {
        Objects.requireNonNull(date, "the date can not be null");
        if (Objects.isNull(this.basicSchema)) {
            this.basicSchema = this.xmpMetadata.createAndAddXMPBasicSchema();
        }
        this.basicSchema.setModifyDate(date);
    }

    public void setCreatorTool(String creatorTool) {
        Objects.requireNonNull(creatorTool, "the creator tool can not be null");
        if (Objects.isNull(this.basicSchema)) {
            this.basicSchema = this.xmpMetadata.createAndAddXMPBasicSchema();
        }
        this.basicSchema.setCreatorTool(creatorTool);
    }

    public void setTitle(String title) {
        Objects.requireNonNull(title, "the title can not be null");
        if (Objects.isNull(this.dcSchema)) {
            this.dcSchema = this.xmpMetadata.createAndAddDublinCoreSchema();
        }
        this.dcSchema.setTitle(title);
    }

    public void setAuthors(String ... authors) {
        Objects.requireNonNull(authors, "the authors can not be null");
        if (Objects.isNull(this.dcSchema)) {
            this.dcSchema = this.xmpMetadata.createAndAddDublinCoreSchema();
        }
        Optional.ofNullable(this.dcSchema.getCreatorsProperty()).ifPresent(arg_0 -> ((DublinCoreSchema)this.dcSchema).removeProperty(arg_0));
        Arrays.stream(authors).forEach(arg_0 -> ((DublinCoreSchema)this.dcSchema).addCreator(arg_0));
    }

    public void setDescription(String description) {
        Objects.requireNonNull(description, "the description can not be null");
        if (Objects.isNull(this.dcSchema)) {
            this.dcSchema = this.xmpMetadata.createAndAddDublinCoreSchema();
        }
        this.dcSchema.setDescription(description);
    }

    public void setFormat(String mimeType) {
        Objects.requireNonNull(mimeType, "the mime type can not be null");
        if (Objects.isNull(this.dcSchema)) {
            this.dcSchema = this.xmpMetadata.createAndAddDublinCoreSchema();
        }
        this.dcSchema.setFormat(mimeType);
    }

    public void setRights(String rights) {
        Objects.requireNonNull(rights, "the rights can not be null");
        if (Objects.isNull(this.dcSchema)) {
            this.dcSchema = this.xmpMetadata.createAndAddDublinCoreSchema();
        }
        this.dcSchema.addRights(null, rights);
    }

    public void setRightsMarked(Boolean marked) {
        Objects.requireNonNull(marked, "the rights marked not be null");
        if (Objects.isNull(this.rmSchema)) {
            this.rmSchema = this.xmpMetadata.createAndAddXMPRightsManagementSchema();
        }
        this.rmSchema.setMarked(marked);
    }

    public void setRightsUrl(String url) {
        Objects.requireNonNull(url, "the rights url can not be null");
        if (Objects.isNull(this.rmSchema)) {
            this.rmSchema = this.xmpMetadata.createAndAddXMPRightsManagementSchema();
        }
        this.rmSchema.setWebStatement(url);
    }

    public void flush() {
        this.processAdobeSchema();
        this.processBasicSchema();
        this.processDcSchema();
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);){
            new XmpSerializer().serialize(this.xmpMetadata, (OutputStream)outputStream, true);
            this.metadata.importXMPMetadata(outputStream.toByteArray());
            this.getDocument().getDocumentCatalog().setMetadata(this.metadata);
            this.document.setIsFlushMetadata(Boolean.FALSE);
        }
    }

    protected void initMetadata() {
        this.metadata = Optional.ofNullable(this.getDocument().getDocumentCatalog().getMetadata()).orElse(new PDMetadata(this.document.getTarget()));
        try {
            this.xmpMetadata = new DomXmpParser().parse(this.metadata.exportXMPMetadata());
        }
        catch (Exception e) {
            this.xmpMetadata = XMPMetadata.createXMPMetadata();
        }
        this.adobeSchema = this.xmpMetadata.getAdobePDFSchema();
        this.basicSchema = this.xmpMetadata.getXMPBasicSchema();
        this.dcSchema = this.xmpMetadata.getDublinCoreSchema();
        this.rmSchema = this.xmpMetadata.getXMPRightsManagementSchema();
        this.mmSchema = this.xmpMetadata.getXMPMediaManagementSchema();
    }

    protected void processAdobeSchema() {
        if (Objects.isNull(this.adobeSchema)) {
            this.adobeSchema = this.xmpMetadata.createAndAddAdobePDFSchema();
        }
        if (Objects.isNull(this.adobeSchema.getProducer())) {
            this.adobeSchema.setProducer("x-easypdf/pdfbox");
        }
        if (Objects.isNull(this.adobeSchema.getPDFVersion())) {
            this.adobeSchema.setPDFVersion(String.valueOf(this.document.getVersion()));
        }
    }

    protected void processBasicSchema() {
        if (Objects.isNull(this.basicSchema)) {
            this.basicSchema = this.xmpMetadata.createAndAddXMPBasicSchema();
        }
        if (Objects.isNull(this.basicSchema.getCreateDate())) {
            this.basicSchema.setCreateDate(Calendar.getInstance());
        }
        if (Objects.isNull(this.basicSchema.getModifyDate())) {
            this.basicSchema.setModifyDate(Calendar.getInstance());
        }
        if (Objects.isNull(this.basicSchema.getCreatorTool())) {
            this.basicSchema.setCreatorTool("x-easypdf/pdfbox");
        }
    }

    protected void processDcSchema() {
        if (Objects.isNull(this.dcSchema)) {
            this.dcSchema = this.xmpMetadata.createAndAddDublinCoreSchema();
        }
        if (Objects.isNull(this.dcSchema.getFormat())) {
            this.dcSchema.setFormat("application/pdf");
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataProcessor)) {
            return false;
        }
        MetadataProcessor other = (MetadataProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PDMetadata this$metadata = this.metadata;
        PDMetadata other$metadata = other.metadata;
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        XMPMetadata this$xmpMetadata = this.xmpMetadata;
        XMPMetadata other$xmpMetadata = other.xmpMetadata;
        if (this$xmpMetadata == null ? other$xmpMetadata != null : !this$xmpMetadata.equals(other$xmpMetadata)) {
            return false;
        }
        AdobePDFSchema this$adobeSchema = this.adobeSchema;
        AdobePDFSchema other$adobeSchema = other.adobeSchema;
        if (this$adobeSchema == null ? other$adobeSchema != null : !this$adobeSchema.equals(other$adobeSchema)) {
            return false;
        }
        XMPBasicSchema this$basicSchema = this.basicSchema;
        XMPBasicSchema other$basicSchema = other.basicSchema;
        if (this$basicSchema == null ? other$basicSchema != null : !this$basicSchema.equals(other$basicSchema)) {
            return false;
        }
        DublinCoreSchema this$dcSchema = this.dcSchema;
        DublinCoreSchema other$dcSchema = other.dcSchema;
        if (this$dcSchema == null ? other$dcSchema != null : !this$dcSchema.equals(other$dcSchema)) {
            return false;
        }
        XMPRightsManagementSchema this$rmSchema = this.rmSchema;
        XMPRightsManagementSchema other$rmSchema = other.rmSchema;
        if (this$rmSchema == null ? other$rmSchema != null : !this$rmSchema.equals(other$rmSchema)) {
            return false;
        }
        XMPMediaManagementSchema this$mmSchema = this.mmSchema;
        XMPMediaManagementSchema other$mmSchema = other.mmSchema;
        return !(this$mmSchema == null ? other$mmSchema != null : !this$mmSchema.equals(other$mmSchema));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetadataProcessor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        PDMetadata $metadata = this.metadata;
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        XMPMetadata $xmpMetadata = this.xmpMetadata;
        result = result * 59 + ($xmpMetadata == null ? 43 : $xmpMetadata.hashCode());
        AdobePDFSchema $adobeSchema = this.adobeSchema;
        result = result * 59 + ($adobeSchema == null ? 43 : $adobeSchema.hashCode());
        XMPBasicSchema $basicSchema = this.basicSchema;
        result = result * 59 + ($basicSchema == null ? 43 : $basicSchema.hashCode());
        DublinCoreSchema $dcSchema = this.dcSchema;
        result = result * 59 + ($dcSchema == null ? 43 : $dcSchema.hashCode());
        XMPRightsManagementSchema $rmSchema = this.rmSchema;
        result = result * 59 + ($rmSchema == null ? 43 : $rmSchema.hashCode());
        XMPMediaManagementSchema $mmSchema = this.mmSchema;
        result = result * 59 + ($mmSchema == null ? 43 : $mmSchema.hashCode());
        return result;
    }
}

