/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor.form;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.fixup.AcroFormDefaultFixup;
import org.apache.pdfbox.pdmodel.fixup.PDDocumentFixup;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceCharacteristicsDictionary;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDCheckBox;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDPushButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDRadioButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.enums.ImageType;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;
import org.dromara.pdf.pdfbox.core.ext.processor.form.AbstractFormFieldBuilder;
import org.dromara.pdf.pdfbox.handler.PdfHandler;
import org.dromara.pdf.pdfbox.util.ColorUtil;
import org.dromara.pdf.pdfbox.util.ImageUtil;

public class FormProcessor
extends AbstractProcessor {
    protected PDAcroForm form;
    protected String fontName;
    protected Float fontSize;
    protected Color fontColor;

    public FormProcessor(Document document) {
        this(document, false, true);
    }

    public FormProcessor(Document document, boolean isFixForm, boolean isNeedAppearance) {
        super(document);
        this.form = this.initForm(document.getTarget(), isFixForm, isNeedAppearance);
    }

    public List<PDField> getFields() {
        return this.form.getFields();
    }

    public void setFont(String fontName, float fontSize, Color fontColor) {
        this.fontName = fontName;
        this.fontSize = Float.valueOf(fontSize);
        this.fontColor = fontColor;
    }

    public void addField(AbstractFormFieldBuilder ... builders) {
        List<PDField> fields = this.getFields();
        for (AbstractFormFieldBuilder builder : builders) {
            fields.add(builder.build(this.form));
        }
        this.reset();
    }

    public void replaceKey(Map<String, String> keyMap) {
        keyMap.forEach((key, value) -> {
            PDField field = this.form.getField(key);
            if (Objects.nonNull(field)) {
                field.setMappingName(value);
            }
        });
        this.reset();
    }

    public void remove(String ... keys) {
        if (Objects.nonNull(keys) && keys.length > 0) {
            List<PDField> fields = this.getFields();
            for (String key : keys) {
                PDField field = this.form.getField(key);
                if (!Objects.nonNull(field)) continue;
                fields.remove(field);
            }
            this.form.setFields(fields);
        } else {
            this.form.setFields(new ArrayList(0));
        }
        this.reset();
    }

    public void fillText(Map<String, String> formMap) {
        Objects.requireNonNull(formMap, "the form map can not be null");
        PDFont font = null;
        Set<Map.Entry<String, String>> entrySet = formMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            PDField field = this.form.getField(entry.getKey());
            if (Objects.nonNull(field)) {
                if (field instanceof PDTextField) {
                    PDTextField textField = (PDTextField)field;
                    if (this.isAddAppearance()) {
                        font = PdfHandler.getFontHandler().getPDFont(this.getDocument(), this.fontName, true);
                        textField.setDefaultAppearance(this.createDefaultAppearance(font));
                    }
                    textField.setValue(entry.getValue());
                    continue;
                }
                this.log.warn((Object)("the field['" + entry.getKey() + "'] is not text field, will be ignored"));
                continue;
            }
            this.log.warn((Object)("the field['" + entry.getKey() + "'] is not exist, will be ignored"));
        }
        if (Objects.nonNull(font)) {
            this.form.getDefaultResources().put(COSName.getPDFName((String)font.getName()), font);
            font.subset();
        }
        this.reset();
    }

    public void fillImage(Map<String, BufferedImage> formMap) {
        Objects.requireNonNull(formMap, "the form map can not be null");
        Set<Map.Entry<String, BufferedImage>> entrySet = formMap.entrySet();
        for (Map.Entry<String, BufferedImage> entry : entrySet) {
            PDField field = this.form.getField(entry.getKey());
            if (Objects.nonNull(field)) {
                if (field instanceof PDPushButton) {
                    PDAppearanceCharacteristicsDictionary appearanceCharacteristics;
                    List widgets = field.getWidgets();
                    if (widgets.isEmpty() || !Objects.nonNull(appearanceCharacteristics = ((PDAnnotationWidget)field.getWidgets().get(0)).getAppearanceCharacteristics())) continue;
                    BufferedImage image = entry.getValue();
                    if (Objects.nonNull(image)) {
                        appearanceCharacteristics.getCOSObject().setItem(COSName.I, (COSBase)PDImageXObject.createFromByteArray((PDDocument)this.getDocument(), (byte[])ImageUtil.toBytes(image, ImageType.PNG.getType()), (String)ImageType.PNG.getType()).getCOSObject());
                        continue;
                    }
                    appearanceCharacteristics.getCOSObject().setItem(COSName.I, null);
                    continue;
                }
                this.log.warn((Object)("the field['" + entry.getKey() + "'] is not image field, will be ignored"));
                continue;
            }
            this.log.warn((Object)("the field['" + entry.getKey() + "'] is not exist, will be ignored"));
        }
        this.reset();
    }

    public void fillRadio(String key, int index) {
        Objects.requireNonNull(key, "the key can not be null");
        PDField field = this.form.getField(key);
        if (Objects.nonNull(field)) {
            if (field instanceof PDRadioButton) {
                try {
                    ((PDAnnotationWidget)field.getWidgets().get(index)).setAppearanceState(String.valueOf(index));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("the field['" + key + "'] radio index is error");
                }
            } else {
                this.log.warn((Object)("the field['" + key + "'] is not radio field, will be ignored"));
            }
        } else {
            this.log.warn((Object)("the field['" + key + "'] is not exist, will be ignored"));
        }
        this.reset();
    }

    public void fillCheckBox(Map<String, Boolean> formMap) {
        Objects.requireNonNull(formMap, "the form map can not be null");
        Set<Map.Entry<String, Boolean>> entrySet = formMap.entrySet();
        for (Map.Entry<String, Boolean> entry : entrySet) {
            String key = entry.getKey();
            PDField field = this.form.getField(entry.getKey());
            if (Objects.nonNull(field)) {
                if (field instanceof PDCheckBox) {
                    ((PDAnnotationWidget)field.getWidgets().get(0)).setAppearanceState(entry.getValue() != false ? "0" : "off");
                    continue;
                }
                this.log.warn((Object)("the field['" + key + "'] is not checkbox field, will be ignored"));
                continue;
            }
            this.log.warn((Object)("the field['" + key + "'] is not exist, will be ignored"));
        }
        this.reset();
    }

    public void flatten(boolean refreshAppearances, String ... keys) {
        List<PDField> fields = this.getFields();
        if (Objects.nonNull(keys) && keys.length > 0) {
            fields = new ArrayList<PDField>(keys.length);
            for (String key : keys) {
                PDField field = this.form.getField(key);
                if (Objects.nonNull(field)) {
                    fields.add(field);
                    continue;
                }
                this.log.warn((Object)("the field['" + key + "'] is not exist, will be ignored"));
            }
        }
        this.form.flatten(fields, refreshAppearances);
        this.reset();
    }

    public void readOnly(String ... keys) {
        if (Objects.nonNull(keys) && keys.length > 0) {
            for (String key : keys) {
                PDField field2 = this.form.getField(key);
                if (Objects.nonNull(field2)) {
                    field2.setReadOnly(true);
                    continue;
                }
                this.log.warn((Object)("the field['" + key + "'] is not exist, will be ignored"));
            }
        } else {
            this.getFields().forEach(field -> field.setReadOnly(true));
        }
        this.reset();
    }

    protected PDAcroForm initForm(PDDocument document, boolean isFixForm, boolean isNeedAppearance) {
        PDDocumentCatalog documentCatalog = document.getDocumentCatalog();
        PDAcroForm acroForm = isFixForm ? documentCatalog.getAcroForm((PDDocumentFixup)new AcroFormDefaultFixup(document)) : documentCatalog.getAcroForm(null);
        if (Objects.isNull(acroForm)) {
            acroForm = new PDAcroForm(document);
        }
        acroForm.setNeedAppearances(Boolean.valueOf(isNeedAppearance));
        acroForm.setCacheFields(true);
        return acroForm;
    }

    protected boolean isAddAppearance() {
        return Objects.nonNull(this.fontName);
    }

    protected String createDefaultAppearance(PDFont font) {
        Float fontSize = this.fontSize;
        Color fontColor = this.fontColor;
        if (Objects.isNull(fontSize)) {
            fontSize = Float.valueOf(12.0f);
        }
        if (Objects.isNull(fontColor)) {
            fontColor = Color.BLACK;
        }
        return String.format("/%s %d Tf %s", font.getName(), fontSize.intValue(), ColorUtil.toPDColorString(fontColor));
    }

    protected void reset() {
        this.getDocument().getDocumentCatalog().setAcroForm(this.form);
    }

    @Generated
    public PDAcroForm getForm() {
        return this.form;
    }

    @Generated
    public String getFontName() {
        return this.fontName;
    }

    @Generated
    public Float getFontSize() {
        return this.fontSize;
    }

    @Generated
    public Color getFontColor() {
        return this.fontColor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormProcessor)) {
            return false;
        }
        FormProcessor other = (FormProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$fontSize = this.getFontSize();
        Float other$fontSize = other.getFontSize();
        if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
            return false;
        }
        PDAcroForm this$form = this.getForm();
        PDAcroForm other$form = other.getForm();
        if (this$form == null ? other$form != null : !this$form.equals(other$form)) {
            return false;
        }
        String this$fontName = this.getFontName();
        String other$fontName = other.getFontName();
        if (this$fontName == null ? other$fontName != null : !this$fontName.equals(other$fontName)) {
            return false;
        }
        Color this$fontColor = this.getFontColor();
        Color other$fontColor = other.getFontColor();
        return !(this$fontColor == null ? other$fontColor != null : !((Object)this$fontColor).equals(other$fontColor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FormProcessor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $fontSize = this.getFontSize();
        result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
        PDAcroForm $form = this.getForm();
        result = result * 59 + ($form == null ? 43 : $form.hashCode());
        String $fontName = this.getFontName();
        result = result * 59 + ($fontName == null ? 43 : $fontName.hashCode());
        Color $fontColor = this.getFontColor();
        result = result * 59 + ($fontColor == null ? 43 : ((Object)$fontColor).hashCode());
        return result;
    }
}

