/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.support;

import java.util.Objects;
import lombok.Generated;

public class CharacterList {
    private Character data;
    private CharacterList previous;
    private CharacterList next;

    public static CharacterList create(String text) {
        CharacterList root;
        char[] chars = text.toCharArray();
        CharacterList previous = root = new CharacterList();
        for (char c : chars) {
            CharacterList current = new CharacterList();
            current.setData(Character.valueOf(c));
            current.setPrevious(previous);
            previous = current;
        }
        return root;
    }

    public void setPrevious(CharacterList node) {
        this.previous = node;
        node.setNext(this);
    }

    public boolean hasPrevious() {
        return Objects.nonNull(this.previous);
    }

    public boolean hasNext() {
        return Objects.nonNull(this.next);
    }

    public void skipNext() {
        if (Objects.nonNull(this.next)) {
            this.next = this.next.next;
        }
    }

    @Generated
    public CharacterList() {
    }

    @Generated
    public Character getData() {
        return this.data;
    }

    @Generated
    public CharacterList getPrevious() {
        return this.previous;
    }

    @Generated
    public CharacterList getNext() {
        return this.next;
    }

    @Generated
    public void setData(Character data) {
        this.data = data;
    }

    @Generated
    public void setNext(CharacterList next) {
        this.next = next;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CharacterList)) {
            return false;
        }
        CharacterList other = (CharacterList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Character this$data = this.getData();
        Character other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        CharacterList this$previous = this.getPrevious();
        CharacterList other$previous = other.getPrevious();
        if (this$previous == null ? other$previous != null : !((Object)this$previous).equals(other$previous)) {
            return false;
        }
        CharacterList this$next = this.getNext();
        CharacterList other$next = other.getNext();
        return !(this$next == null ? other$next != null : !((Object)this$next).equals(other$next));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CharacterList;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Character $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        CharacterList $previous = this.getPrevious();
        result = result * 59 + ($previous == null ? 43 : ((Object)$previous).hashCode());
        CharacterList $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CharacterList(data=" + this.getData() + ", previous=" + this.getPrevious() + ", next=" + this.getNext() + ")";
    }
}

