/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.handler;

import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.config.FontConfiguration;
import org.dromara.pdf.pdfbox.core.component.TextLineInfo;
import org.dromara.pdf.pdfbox.core.ext.handler.AbstractTextHandler;
import org.dromara.pdf.pdfbox.support.Constants;

public class TextHandler
extends AbstractTextHandler {
    public TextHandler(Document document) {
        super(document);
    }

    @Override
    public void writeText(FontConfiguration fontConfiguration, PDPageContentStream contentStream, TextLineInfo text) {
        List<String> specialFontNames = fontConfiguration.getSpecialFontNames();
        PDFont font = this.getContext().getFont(fontConfiguration.getFontName());
        Float fontSize = fontConfiguration.getFontSize();
        char[] charArray = text.getText().toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char character = charArray[i];
            try {
                contentStream.showCharacter(Character.valueOf(character));
                continue;
            }
            catch (Exception e) {
                boolean flag = this.processSingle(contentStream, Character.valueOf(character), specialFontNames, font, fontSize);
                if (!flag || i + 1 >= charArray.length) continue;
                char next = charArray[i + 1];
                flag = this.processDouble(contentStream, Character.valueOf(character), Character.valueOf(next), specialFontNames, font, fontSize);
                if (flag) {
                    contentStream.setFont(this.getContext().getFont("HarmonyOS Sans SC"), fontSize.floatValue());
                    contentStream.showCharacter(Constants.DEFAULT_UNKNOWN_CHARACTER);
                    contentStream.setFont(font, fontSize.floatValue());
                    continue;
                }
                ++i;
            }
        }
    }

    protected boolean processSingle(PDPageContentStream contentStream, Character character, List<String> specialFontNames, PDFont font, Float fontSize) {
        boolean flag = true;
        if (Objects.nonNull(specialFontNames)) {
            for (String specialFontName : specialFontNames) {
                try {
                    contentStream.setFont(this.getContext().getFont(specialFontName), fontSize.floatValue());
                    contentStream.showCharacter(character);
                    flag = false;
                    break;
                }
                catch (Exception exception) {
                }
            }
            contentStream.setFont(font, fontSize.floatValue());
        }
        return flag;
    }

    protected boolean processDouble(PDPageContentStream contentStream, Character character, Character next, List<String> specialFontNames, PDFont font, Float fontSize) {
        boolean flag = true;
        if (Objects.nonNull(specialFontNames)) {
            String joinStr = String.valueOf(new char[]{character.charValue(), next.charValue()});
            for (String specialFontName : specialFontNames) {
                try {
                    contentStream.setFont(this.getContext().getFont(specialFontName), fontSize.floatValue());
                    contentStream.showText(joinStr);
                    flag = false;
                    break;
                }
                catch (Exception exception) {
                }
            }
            contentStream.setFont(font, fontSize.floatValue());
        }
        return flag;
    }
}

