/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;

public class BookmarkProcessor
extends AbstractProcessor {
    protected List<PDOutlineItem> itemList = new ArrayList<PDOutlineItem>(16);

    public BookmarkProcessor(Document document) {
        super(document);
        this.initOutlineItem();
    }

    public List<PDOutlineItem> getItems() {
        return this.itemList;
    }

    public void insert(int index, PDOutlineItem item) {
        Objects.requireNonNull(item, "the item can not be null");
        try {
            this.itemList.add(index, item);
        }
        catch (Exception e) {
            this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
        }
    }

    public void append(PDOutlineItem item) {
        Objects.requireNonNull(item, "the item can not be null");
        this.itemList.add(item);
    }

    public void set(int index, PDOutlineItem item) {
        Objects.requireNonNull(item, "the item can not be null");
        try {
            this.itemList.set(index, item);
        }
        catch (Exception e) {
            this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
        }
    }

    public void remove(int ... indexes) {
        if (Objects.isNull(indexes)) {
            this.itemList = new ArrayList<PDOutlineItem>(0);
        } else {
            for (int index : indexes) {
                try {
                    this.itemList.remove(index);
                }
                catch (Exception e) {
                    this.log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
                }
            }
        }
    }

    public void flush() {
        PDDocumentOutline root = new PDDocumentOutline();
        this.itemList.forEach(arg_0 -> ((PDDocumentOutline)root).addLast(arg_0));
        this.getDocument().getDocumentCatalog().setDocumentOutline(root);
    }

    protected void initOutlineItem() {
        PDDocumentOutline documentOutline = this.getDocument().getDocumentCatalog().getDocumentOutline();
        if (Objects.nonNull(documentOutline)) {
            documentOutline.children().forEach(this.itemList::add);
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BookmarkProcessor)) {
            return false;
        }
        BookmarkProcessor other = (BookmarkProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<PDOutlineItem> this$itemList = this.itemList;
        List<PDOutlineItem> other$itemList = other.itemList;
        return !(this$itemList == null ? other$itemList != null : !((Object)this$itemList).equals(other$itemList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BookmarkProcessor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<PDOutlineItem> $itemList = this.itemList;
        result = result * 59 + ($itemList == null ? 43 : ((Object)$itemList).hashCode());
        return result;
    }
}

