/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PageSize;
import org.dromara.pdf.pdfbox.core.component.Image;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;
import org.dromara.pdf.pdfbox.util.ImageUtil;

public class ImageProcessor
extends AbstractProcessor {
    public ImageProcessor(Document document) {
        super(document);
    }

    public void toPdf(File ... files) {
        this.toPdf(PageSize.A4, files);
    }

    public void toPdf(PageSize pageSize, File ... files) {
        ArrayList<BufferedImage> list = new ArrayList<BufferedImage>(files.length);
        for (File file : files) {
            list.add(ImageUtil.read(file));
        }
        this.toPdf(pageSize, list);
    }

    public void toPdf(List<BufferedImage> images) {
        this.toPdf(PageSize.A4, images);
    }

    public void toPdf(PageSize pageSize, List<BufferedImage> images) {
        this.toPdf(pageSize, images.toArray(new BufferedImage[0]));
    }

    public void toPdf(BufferedImage ... images) {
        this.toPdf(PageSize.A4, images);
    }

    public void toPdf(PageSize pageSize, BufferedImage ... images) {
        Objects.requireNonNull(pageSize, "the page size can not be null");
        Objects.requireNonNull(images, "the image can not be null");
        if (images.length == 0) {
            throw new IllegalArgumentException("the image can not be empty");
        }
        ArrayList<Page> pages = new ArrayList<Page>(images.length);
        for (BufferedImage image : images) {
            Page page = new Page(this.document, pageSize);
            Image component = new Image(page);
            component.setImage(image);
            component.setWidth(page.getWidth().intValue());
            component.setHeight(page.getHeight().intValue());
            component.render();
            pages.add(page);
        }
        this.document.appendPage(pages);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageProcessor)) {
            return false;
        }
        ImageProcessor other = (ImageProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImageProcessor;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

