/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor.sign;

import java.io.InputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.dromara.pdf.pdfbox.core.ext.processor.sign.DefaultCMSProcessor;
import org.dromara.pdf.pdfbox.core.ext.processor.sign.SignOptions;

public class DefaultSigner
implements SignatureInterface {
    private static final String PROVIDER = "BC";
    private final PrivateKey key;
    private final Certificate[] certificates;
    private final String algorithm;

    public DefaultSigner(SignOptions options) {
        this.key = options.getKey();
        this.certificates = options.getCertificates();
        this.algorithm = options.getAlgorithm();
    }

    public byte[] sign(InputStream content) {
        CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder(this.algorithm).setProvider(PROVIDER).build(this.key);
        generator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(PROVIDER).build()).build(sha1Signer, (X509Certificate)this.certificates[0]));
        generator.addCertificates((Store)new JcaCertStore(Arrays.asList(this.certificates)));
        return generator.generate(this.getCMSData(content), true).getEncoded();
    }

    protected CMSTypedData getCMSData(InputStream content) {
        return new DefaultCMSProcessor(content);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

