/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.handler;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.FontFormat;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.dromara.pdf.pdfbox.core.base.Banner;
import org.dromara.pdf.pdfbox.core.enums.FontType;
import org.dromara.pdf.pdfbox.support.fonts.FontInfo;
import org.dromara.pdf.pdfbox.support.fonts.FontMapperImpl;

public class FontHandler {
    private static final Log log;
    private static final FontHandler INSTANCE;

    private FontHandler() {
        this.addFont(Thread.currentThread().getContextClassLoader().getResourceAsStream("org/dromara/pdf/pdfbox/ttf/HarmonyOS_Sans_SC_Regular.ttf"), "HarmonyOS Sans SC", FontType.TTF);
    }

    public static FontHandler getInstance() {
        return INSTANCE;
    }

    public List<String> getFontNames() {
        return new ArrayList<String>(FontMapperImpl.getInstance().getFontInfoByName().keySet());
    }

    public List<? extends FontInfo> getFontInfos() {
        return FontMapperImpl.getInstance().getProvider().getFontInfo();
    }

    public PDFont getPDFont(PDDocument document, String fontName, boolean embedSubset) {
        FontInfo fontInfo = FontMapperImpl.getInstance().getFontInfoByName().get(fontName);
        if (Objects.nonNull((Object)fontInfo) && fontInfo.getFormat() == FontFormat.OTF) {
            embedSubset = false;
        }
        return PDType0Font.load((PDDocument)document, (TrueTypeFont)this.getTrueTypeFont(fontName), (boolean)embedSubset);
    }

    public PDFont getPDFont(PDDocument document, String fontName) {
        return this.getPDFont(document, fontName, true);
    }

    public TrueTypeFont getTrueTypeFont(String fontName) {
        return (TrueTypeFont)FontMapperImpl.getInstance().getTrueTypeFont(fontName, null).getFont();
    }

    public void addFont(File file, String alias) {
        if (Objects.nonNull(file)) {
            FontMapperImpl.getInstance().getProvider().addFont(file, alias);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added font ['" + alias + "']"));
            }
            FontMapperImpl.getInstance().resetFontInfoByName();
        }
    }

    public void addFont(File ... files) {
        if (Objects.nonNull(files)) {
            Arrays.stream(files).forEach(file -> {
                String fontName = FontMapperImpl.getInstance().getProvider().addFont((File)file);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added font ['" + fontName + "']"));
                }
            });
            FontMapperImpl.getInstance().resetFontInfoByName();
        }
    }

    public void addFont(Collection<File> files) {
        if (Objects.nonNull(files)) {
            files.forEach(file -> {
                String fontName = FontMapperImpl.getInstance().getProvider().addFont((File)file);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added font ['" + fontName + "']"));
                }
            });
            FontMapperImpl.getInstance().resetFontInfoByName();
        }
    }

    public void addFont(InputStream inputStream, String tempName, FontType type) {
        String fontName = FontMapperImpl.getInstance().getProvider().addFont(inputStream, tempName, type);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added font ['" + fontName + "']"));
        }
        FontMapperImpl.getInstance().resetFontInfoByName();
    }

    public void addToSubset(PDDocument document, PDFont font, String text) {
        if (Objects.nonNull(font) && font.willBeSubset()) {
            int codePoint;
            int length = text.length();
            for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
                codePoint = text.codePointAt(offset);
                font.addToSubset(codePoint);
            }
            document.addFontToSubset(font);
        }
    }

    static {
        Banner.print();
        log = LogFactory.getLog(FontHandler.class);
        INSTANCE = new FontHandler();
    }
}

