/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.pdfbox.core.info.ReplaceInfo;
import org.dromara.pdf.pdfbox.core.info.TextTokenInfo;
import org.dromara.pdf.pdfbox.handler.PdfHandler;

public class TextTokenUtil {
    public static boolean replaceTextForToken(Log log, PDDocument document, PDResources resources, List<Object> tokens, List<ReplaceInfo> replaceList, Map<Character, Integer> replaceIndexMap) {
        boolean result = false;
        List<TextTokenInfo> infoList = TextTokenUtil.initTextTokenInfoListForCharacter(log, resources, tokens, replaceList, replaceIndexMap);
        for (TextTokenInfo info : infoList) {
            if (!info.getIsReplace().booleanValue()) continue;
            PDFont font = info.getReplaceFont();
            for (TextTokenInfo.TextValue textValue : info.getTokens()) {
                TextTokenUtil.processReplaceText(document, resources, font, textValue.getToken(), textValue.getValue());
            }
            tokens.set(info.getFontIndex(), COSName.getPDFName((String)font.getName()));
            result = true;
        }
        return result;
    }

    public static boolean replaceTextForToken(Log log, PDDocument document, PDResources resources, List<Object> tokens, PDFont font, Map<String, String> replaceMap) {
        boolean normalFlag = TextTokenUtil.tryReplaceTextForNormal(log, document, resources, tokens, font, replaceMap);
        boolean specialFlag = TextTokenUtil.tryReplaceTextForSpecial(log, document, resources, tokens, font, replaceMap);
        return normalFlag || specialFlag;
    }

    public static boolean tryReplaceTextForNormal(Log log, PDDocument document, PDResources resources, List<Object> tokens, PDFont font, Map<String, String> replaceMap) {
        boolean result = false;
        String blank = " ";
        List<TextTokenInfo> infoList = TextTokenUtil.initTextTokenInfoListForString(resources, tokens);
        for (TextTokenInfo info : infoList) {
            ArrayList<TextTokenInfo.TextValue> children = new ArrayList<TextTokenInfo.TextValue>(info.getTokens().size());
            StringBuilder builder = new StringBuilder();
            TextTokenInfo.TextValue beginValue = null;
            for (TextTokenInfo.TextValue textValue : info.getTokens()) {
                String value;
                if (builder.length() == 0) {
                    beginValue = textValue;
                } else {
                    textValue.setIsReplaced(false);
                    children.add(textValue);
                }
                if (!Objects.nonNull(value = textValue.getValue())) continue;
                if (Objects.nonNull(beginValue) && Objects.equals(value, " ")) {
                    beginValue.setReplaceValue(builder.toString());
                    beginValue.setChildren(children);
                    beginValue.setIsReplaced(true);
                    builder = new StringBuilder();
                    children = new ArrayList();
                    result = true;
                    continue;
                }
                builder.append(value);
            }
            if (!result) {
                for (TextTokenInfo.TextValue textValue : info.getTokens()) {
                    textValue.setIsReplaced(true);
                }
            }
            result = false;
            block5: for (TextTokenInfo.TextValue textValue : info.getTokens()) {
                String allText;
                if (!textValue.isReplaced()) continue;
                String replaceText = allText = textValue.getReplaceValue();
                for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
                    if (!replaceText.contains(entry.getKey())) continue;
                    replaceText = replaceText.replace(entry.getKey(), entry.getValue());
                    TextTokenUtil.processReplaceText(document, resources, font, textValue.getToken(), replaceText);
                    textValue.setIsEmbedSubset(true);
                    if (Objects.nonNull(textValue.getChildren())) {
                        for (TextTokenInfo.TextValue child : textValue.getChildren()) {
                            TextTokenUtil.processReplaceText(document, resources, font, child.getToken(), "");
                            child.setIsEmbedSubset(true);
                        }
                    }
                    result = true;
                    if (!log.isDebugEnabled()) continue block5;
                    log.debug((Object)("Replaced normal text: original [\"" + allText + "\"], now [\"" + replaceText + "\"]"));
                    continue block5;
                }
            }
            if (!result) continue;
            for (TextTokenInfo.TextValue textValue : info.getTokens()) {
                if (!Objects.isNull(textValue.getIsEmbedSubset())) continue;
                TextTokenUtil.processReplaceText(document, resources, font, textValue.getToken(), textValue.getValue());
            }
            tokens.set(info.getFontIndex(), COSName.getPDFName((String)font.getName()));
        }
        return result;
    }

    public static boolean tryReplaceTextForSpecial(Log log, PDDocument document, PDResources resources, List<Object> tokens, PDFont font, Map<String, String> replaceMap) {
        boolean result = false;
        List<TextTokenInfo> infoList = TextTokenUtil.initTextTokenInfoListForString(resources, tokens);
        for (TextTokenInfo info : infoList) {
            String allText;
            boolean isReplace = false;
            String replaceText = allText = TextTokenUtil.getTextForTokenInfo(info);
            for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
                if (!replaceText.contains(entry.getKey())) continue;
                replaceText = replaceText.replace(entry.getKey(), entry.getValue());
                isReplace = true;
                result = true;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Replaced special text: original [\"" + allText + "\"], now [\"" + replaceText + "\"]"));
            }
            if (!isReplace) continue;
            if (info.getTokens().size() == 1) {
                TextTokenUtil.processReplaceText(document, resources, font, info.getTokens().get(0).getToken(), replaceText);
            } else if (allText.length() == replaceText.length()) {
                TextTokenUtil.processSameLengthReplaceText(document, resources, font, info, replaceText);
            } else {
                TextTokenUtil.processNotSameLengthReplaceText(document, resources, font, info, replaceText);
            }
            tokens.set(info.getFontIndex(), COSName.getPDFName((String)font.getName()));
        }
        return result;
    }

    public static void processSameLengthReplaceText(PDDocument document, PDResources resources, PDFont font, TextTokenInfo info, String replaceText) {
        int begin = 0;
        for (TextTokenInfo.TextValue token : info.getTokens()) {
            int end = begin + token.getValue().length();
            String value = replaceText.substring(begin, end);
            TextTokenUtil.processReplaceText(document, resources, font, token.getToken(), value);
            begin = end;
        }
    }

    public static void processNotSameLengthReplaceText(PDDocument document, PDResources resources, PDFont font, TextTokenInfo info, String replaceText) {
        String blank = "";
        if (Objects.equals(replaceText, "")) {
            for (TextTokenInfo.TextValue textValue : info.getTokens()) {
                TextTokenUtil.processReplaceText(document, resources, font, textValue.getToken(), "");
            }
        } else {
            int beginIndex = 0;
            int totalIndex = replaceText.length();
            Iterator<TextTokenInfo.TextValue> iterator = info.getTokens().iterator();
            TextTokenInfo.TextValue textValue = iterator.next();
            int endIndex = textValue.getValue().length();
            String text = replaceText.substring(beginIndex, endIndex);
            beginIndex = endIndex;
            TextTokenUtil.processReplaceText(document, resources, font, textValue.getToken(), text);
            while (iterator.hasNext()) {
                textValue = iterator.next();
                if (beginIndex == totalIndex) {
                    TextTokenUtil.processReplaceText(document, resources, font, textValue.getToken(), "");
                    continue;
                }
                if ((endIndex += textValue.getValue().length()) > totalIndex) {
                    endIndex = totalIndex;
                }
                text = replaceText.substring(beginIndex, endIndex);
                beginIndex = endIndex;
                TextTokenUtil.processReplaceText(document, resources, font, textValue.getToken(), text);
            }
        }
    }

    public static void processReplaceText(PDDocument document, PDResources resources, PDFont font, Object token, String value) {
        PdfHandler.getFontHandler().addToSubset(document, font, value);
        if (token instanceof COSArray) {
            COSArray array = (COSArray)token;
            array.clear();
            array.add((COSBase)new COSString(font.encode(value)));
        } else {
            COSString cosString = (COSString)token;
            cosString.setValue(font.encode(value));
        }
        COSName replaceFontName = COSName.getPDFName((String)font.getName());
        if (Objects.isNull(resources.getFont(replaceFontName))) {
            resources.put(replaceFontName, font);
        }
    }

    public static List<TextTokenInfo> initTextTokenInfoListForCharacter(Log log, PDResources resources, List<Object> tokens, List<ReplaceInfo> replaceList, Map<Character, Integer> replaceIndexMap) {
        Map<COSName, PDFont> resourceFontMap = TextTokenUtil.initResourceFontMap(resources);
        TextTokenInfo tokenInfo = null;
        ArrayList<TextTokenInfo> infoList = new ArrayList<TextTokenInfo>(tokens.size());
        for (int i = 0; i < tokens.size(); ++i) {
            Object token = tokens.get(i);
            if (token instanceof COSName) {
                PDFont resourceFont = resourceFontMap.get(token);
                if (!Objects.nonNull(resourceFont)) continue;
                tokenInfo = new TextTokenInfo(i, resourceFont, resourceFont, false, new ArrayList<TextTokenInfo.TextValue>(16));
                infoList.add(tokenInfo);
                continue;
            }
            if (!(token instanceof COSArray) && !(token instanceof COSString)) continue;
            TextTokenUtil.initTextTokenInfoTextValue(log, tokenInfo, token, i, replaceList, replaceIndexMap);
        }
        return infoList;
    }

    public static List<TextTokenInfo> initTextTokenInfoListForString(PDResources resources, List<Object> tokens) {
        Map<COSName, PDFont> resourceFontMap = TextTokenUtil.initResourceFontMap(resources);
        TextTokenInfo tokenInfo = null;
        ArrayList<TextTokenInfo> infoList = new ArrayList<TextTokenInfo>(tokens.size());
        for (int i = 0; i < tokens.size(); ++i) {
            Object token = tokens.get(i);
            if (token instanceof COSName) {
                PDFont resourceFont = resourceFontMap.get(token);
                if (!Objects.nonNull(resourceFont)) continue;
                tokenInfo = new TextTokenInfo(i, resourceFont, resourceFont, false, new ArrayList<TextTokenInfo.TextValue>(16));
                infoList.add(tokenInfo);
                continue;
            }
            if (!(token instanceof COSArray) && !(token instanceof COSString) || !Objects.nonNull(tokenInfo)) continue;
            String source = TextTokenUtil.getTextForToken(token, tokenInfo.getFont());
            tokenInfo.getTokens().add(new TextTokenInfo.TextValue(i, token, source));
        }
        return infoList;
    }

    public static void initTextTokenInfoTextValue(Log log, TextTokenInfo tokenInfo, Object token, int tokenIndex, List<ReplaceInfo> replaceList, Map<Character, Integer> replaceIndexMap) {
        if (Objects.nonNull(tokenInfo)) {
            String source = TextTokenUtil.getTextForToken(token, tokenInfo.getFont());
            StringBuilder newValue = new StringBuilder();
            if (Objects.nonNull(source)) {
                char[] characters;
                boolean blank = false;
                for (char character : characters = source.toCharArray()) {
                    Integer index = replaceIndexMap.get(Character.valueOf(character));
                    if (Objects.nonNull(index)) {
                        for (ReplaceInfo info : replaceList) {
                            if (!Objects.equals(Character.valueOf(character), info.getOriginal())) continue;
                            Set<Integer> indexes = info.getIndexes();
                            if (Objects.nonNull(indexes)) {
                                boolean replaced = false;
                                for (Integer replaceIndex : indexes) {
                                    if (!Objects.equals(index, replaceIndex)) continue;
                                    replaced = true;
                                    tokenInfo.setIsReplace(replaced);
                                    tokenInfo.setReplaceFont(info.getFont());
                                    if (!Objects.equals(Character.valueOf('\u0000'), info.getValue())) {
                                        newValue.append(info.getValue());
                                    }
                                    if (!log.isDebugEnabled()) break;
                                    log.debug((Object)("Replaced character: original ['" + character + "'], now ['" + info.getValue() + "'], index ['" + index + "']"));
                                    break;
                                }
                                if (replaced) continue;
                                newValue.append(character);
                                continue;
                            }
                            tokenInfo.setIsReplace(true);
                            tokenInfo.setReplaceFont(info.getFont());
                            if (!Objects.equals(Character.valueOf('\u0000'), info.getValue())) {
                                newValue.append(info.getValue());
                            }
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Replaced character: original ['" + character + "'], now ['" + info.getValue() + "'], index ['" + index + "']"));
                        }
                        replaceIndexMap.put(Character.valueOf(character), index + 1);
                    } else {
                        newValue.append(character);
                    }
                    TextTokenInfo.TextValue tokenValue = new TextTokenInfo.TextValue(tokenIndex, token, newValue.toString());
                    tokenInfo.getTokens().add(tokenValue);
                }
            }
        }
    }

    public static String getTextForToken(Object token, PDFont font) {
        StringBuilder builder = new StringBuilder();
        if (token instanceof COSArray) {
            COSArray array = (COSArray)token;
            for (COSBase cosBase : array) {
                if (cosBase instanceof COSInteger) {
                    COSInteger cosInteger = (COSInteger)cosBase;
                    if (cosInteger.intValue() > -199) continue;
                    builder.append(" ");
                    continue;
                }
                if (cosBase instanceof COSArray) {
                    String value = TextTokenUtil.getTextForToken(cosBase, font);
                    if (!Objects.nonNull(value)) continue;
                    builder.append(value);
                    continue;
                }
                TextTokenUtil.joinString(builder, cosBase, font);
            }
        } else {
            TextTokenUtil.joinString(builder, token, font);
        }
        return builder.length() > 0 ? builder.toString() : null;
    }

    public static String getTextForTokenInfo(TextTokenInfo info) {
        StringBuilder builder = new StringBuilder();
        for (TextTokenInfo.TextValue textValue : info.getTokens()) {
            String value = textValue.getValue();
            if (!Objects.nonNull(value)) continue;
            builder.append(value);
        }
        return builder.toString();
    }

    public static Map<COSName, PDFont> initResourceFontMap(PDResources resources) {
        HashMap<COSName, PDFont> resourceFontMap = new HashMap<COSName, PDFont>(16);
        if (Objects.nonNull(resources)) {
            for (COSName cosName : resources.getFontNames()) {
                resourceFontMap.put(cosName, resources.getFont(cosName));
            }
        }
        return resourceFontMap;
    }

    public static void joinString(StringBuilder builder, Object token, PDFont font) {
        block15: {
            if (!(token instanceof COSString)) break block15;
            COSString cosString = (COSString)token;
            try (ByteArrayInputStream in = new ByteArrayInputStream(cosString.getBytes());){
                while (((InputStream)in).available() > 0) {
                    String unicode = font.toUnicode(font.readCode(in));
                    if (!Objects.nonNull(unicode)) continue;
                    builder.append(unicode);
                }
            }
        }
    }
}

