package ord.dronda.scheduling.cronk

import com.cronutils.model.Cron
import java.time.ZoneId
import java.time.ZoneOffset
import java.util.UUID

public class CronJob(
    public val id: String,
    public val name: String,
    public val cron: Cron,
    public val expression: String,
    public val zoneId: ZoneId,
    public val job: suspend () -> Unit
) {

    public companion object {
        public fun of(
            id: String = UUID.randomUUID().toString(),
            expression: String,
            zoneId: ZoneId = ZoneOffset.UTC,
            name: String? = null,
            job: suspend () -> Unit
        ): CronJob {
            return CronJob(
                id = id,
                name = name ?: id,
                cron = CronParser.parse(expression),
                expression = expression,
                zoneId = zoneId,
                job = job
            )
        }
    }
}