package ord.dronda.scheduling.cronk

import com.cronutils.model.Cron
import com.cronutils.model.CronType
import com.cronutils.model.definition.CronDefinitionBuilder
import com.cronutils.parser.CronParser
import ord.dronda.scheduling.cronk.lib.executionTime
import ord.dronda.scheduling.cronk.lib.nextExecution
import java.time.ZonedDateTime

public object CronParser {

    private val definition = CronDefinitionBuilder.instanceDefinitionFor(CronType.UNIX)
    private val parser = CronParser(definition)

    public fun parse(expression: String): Cron {
        return parser.parse(expression)
    }

    public fun nextTime(expression: String): ZonedDateTime {
        return parse(expression).executionTime().nextExecution()
    }
}