package ord.dronda.scheduling.cronk.lib

import com.cronutils.model.Cron
import com.cronutils.model.time.ExecutionTime
import java.time.ZoneId
import java.time.ZoneOffset
import java.time.ZonedDateTime

public fun Cron.executionTime(): ExecutionTime = ExecutionTime.forCron(this)

public fun ExecutionTime.nextExecution(): ZonedDateTime {
    val now = ZonedDateTime.now()
    return nextExecution(now).get()
}

public fun Cron.secondsUntilNextExecution(zone: ZoneId = ZoneOffset.UTC): Long {
    val now = ZonedDateTime.now(zone)
    val executionTime = executionTime()
    val nextExecution = executionTime.nextExecution(now).get()
    return (nextExecution.toInstant().epochSecond - now.toInstant().epochSecond)
}
