package org.dronda.lib.aggregate.internal

import org.dronda.lib.aggregate.Aggregate
import org.dronda.lib.aggregate.ValidatingAggregateEventHandler
import org.dronda.lib.aggregate.Event
import org.dronda.lib.aggregate.NoKnownHandlerException
import org.dronda.lib.aggregate.NonNullAggregateEventHandler
import org.dronda.lib.aggregate.NullableAggregateEventHandler
import org.dronda.lib.aggregate.ValidatingAggregator
import org.dronda.lib.aggregate.Validity
import kotlin.reflect.KClass

internal class ValidatingAggregatorImpl<E : Event, A : Aggregate>(
    private val handlers: Map<KClass<E>, ValidatingAggregateEventHandler<E, A>>
) : ValidatingAggregator<E, A> {
    override fun applyWithValidation(event: E, aggregate: A?): ValidatingAggregator.Result<A> {
        val handler = handlers[event::class] ?: throw NoKnownHandlerException()
        return when (handler) {
            is NonNullAggregateEventHandler -> {
                aggregate ?: return ValidatingAggregator.Result.Invalid(listOf("null"))
                when (val result = handler.validate(event, aggregate)) {
                    is Validity.Invalid -> return ValidatingAggregator.Result.Invalid(listOf(result.reason))
                    is Validity.Valid -> ValidatingAggregator.Result.Valid(handler.apply(event, aggregate))
                }
            }
            is NullableAggregateEventHandler -> {
                when (val result = handler.validate(event, aggregate)) {
                    is Validity.Invalid -> return ValidatingAggregator.Result.Invalid(listOf(result.reason))
                    is Validity.Valid -> ValidatingAggregator.Result.Valid(handler.apply(event, aggregate))
                }
            }
        }
    }
}