package org.dronda.lib.aggregate.processor

import org.dronda.lib.aggregate.Aggregate

public interface DataStore<A : Aggregate> {
    public suspend fun load(modelId: String): A?

    public suspend fun store(modelId: String, aggregate: A) : DataStoreResult
}

public sealed interface DataStoreResult {
    public object Success : DataStoreResult
    public sealed interface Failure: DataStoreResult {
        public object Retry : Failure
        public object Unknown : Failure
    }
}