package org.dronda.lib.aggregate.processor

import org.dronda.lib.aggregate.Aggregate
import org.dronda.lib.aggregate.Event
import org.dronda.lib.aggregate.reactor.EventReactor

internal class ReactorApplier<E: Event, A: Aggregate>(
    private val reactors: List<EventReactor<E, A>>
) {
    val impl: ReactToUpdatedAggregate<E, A> = { (event, aggregate) ->
        reactors.forEach { eventReactor ->
            eventReactor.afterApply(event, aggregate)
        }
    }
}