package org.dronda.lib.aggregate

import org.dronda.lib.aggregate.internal.ValidatingAggregatorBuilderImpl

public interface ValidatingAggregator<E: Event, A : Aggregate> {
    public sealed interface Result<T : Aggregate> {
        public data class Valid<T : Aggregate>(
            val aggregate: T
        ) : Result<T>

        public data class Invalid<T : Aggregate>(
            val invalidItems: List<String>
        ) : Result<T>
    }

    public fun applyWithValidation(event: E, aggregate: A?): Result<A>

    public companion object
}

public fun <E : Event, A : Aggregate> ValidatingAggregator.Companion.builder(): ValidatingAggregatorBuilder<E, A> =
    ValidatingAggregatorBuilderImpl<E, A>()