package org.dronda.lib.aggregate

import kotlin.reflect.KClass

public abstract class ValidatingAggregatorBuilder<E : Event, A : Aggregate> {
    protected val eventHandlers: HashMap<KClass<E>, ValidatingAggregateEventHandler<E, A>> = hashMapOf()
    public fun <SE : E> addHandler(
        klass: KClass<SE>,
        handler: ValidatingAggregateEventHandler<SE, A>
    ): ValidatingAggregatorBuilder<E, A> {
        @Suppress("UNCHECKED_CAST")
        eventHandlers[klass as KClass<E>] = handler as ValidatingAggregateEventHandler<E, A>
        return this
    }

    public abstract fun build(): ValidatingAggregator<E, A>
}
public sealed interface ValidatingAggregateEventHandler<E : Event, A : Aggregate>
public interface NullableAggregateEventHandler<E : Event, A : Aggregate> : ValidatingAggregateEventHandler<E, A> {
    public fun validate(event: E, aggregate: A?): Validity

    public fun apply(event: E, aggregate: A?): A
}

public interface NonNullAggregateEventHandler<E : Event, A : Aggregate> : ValidatingAggregateEventHandler<E, A> {
    public fun validate(event: E, aggregate: A): Validity

    public fun apply(event: E, aggregate: A): A
}
