package org.dronda.lib.aggregate.decorator

import org.dronda.lib.aggregate.Aggregate
import org.dronda.lib.aggregate.Event
import org.dronda.lib.aggregate.ValidatingAggregator

private class DecoratedValidatingAggregator<E : Event, A : Aggregate>(
    val aggregator: ValidatingAggregator<E, A>,
    val decorators: List<Decorator<E, A>>
) : ValidatingAggregator<E, A> by aggregator {

    override fun applyWithValidation(event: E, aggregate: A?): ValidatingAggregator.Result<A> {
        val updatedAggregate = when (val result = aggregator.applyWithValidation(event, aggregate)) {
            is ValidatingAggregator.Result.Invalid -> return result
            is ValidatingAggregator.Result.Valid -> result.aggregate
        }
        return decorators.fold(updatedAggregate) { curr, decorator ->
            decorator.decorateAggregate(event, curr)
        }.let { ValidatingAggregator.Result.Valid(it) }
    }
}

public fun <E : Event, A : Aggregate> ValidatingAggregator<E, A>.decorateWith(decorator: Decorator<E, A>): ValidatingAggregator<E, A> {
    return if (this is DecoratedValidatingAggregator<E, A>) {
        DecoratedValidatingAggregator(aggregator, decorators + decorator)
    } else {
        DecoratedValidatingAggregator(this, listOf(decorator))
    }
}