package org.dronda.lib.aggregate.processor

import org.dronda.lib.aggregate.Aggregate
import org.dronda.lib.aggregate.Event
import org.dronda.lib.aggregate.ValidatingAggregator

internal class AggregateApplier<E : Event, A : Aggregate>(
    private val aggregator: ValidatingAggregator<E, A>
) {
    val impl : EventApplier<E, A> = { event, aggregate ->
        aggregator.applyWithValidation(event, aggregate)
    }
}