package org.dronda.lib.aggregate.processor

import org.dronda.lib.aggregate.Aggregate
import org.dronda.lib.aggregate.Event

public interface Processor<E : Event, A : Aggregate> {
    public suspend fun process(event: E): ProcessorResult
}

public sealed interface ProcessorResult {
    public object Success : ProcessorResult

    public object Failure : ProcessorResult
}
