package org.dronda.lib.jvm.crypto

import java.io.InputStream
import java.security.SecureRandom

public interface Encryptor {
    public fun encryptPayload(payload: ByteArray): AESEncryptionData

    public fun encryptPayload(payload: InputStream): AESInputStreamData

    public fun decryptPayload(encryption: AESEncryptionData): ByteArray

    public fun decryptPayload(encryption: AESInputStreamData): InputStream

}
public class AESEncryptionData(
    public val value: ByteArray,
    public val iv: ByteArray
)
public class AESInputStreamData(
    public val value: InputStream,
    public val iv: ByteArray,
)

internal fun createInitializationVector(size: Int): ByteArray {
    val iv = ByteArray(size)
    SecureRandom().apply {
        nextBytes(iv)
    }
    return iv
}

