package org.dronda.lib.domain.error

public abstract class DomainError(
    /**
     * Error message that includes information appropriate for logging, but should not be exposed to the user.
     */
    public val internalMessage: String? = null,

    /**
     * Error message that is appropriate to be included in the response and seen by the user.
     */
    public val externalMessage: String? = null,

    /**
     * Cause of the error, if any. Useful for debugging and should not be exposed by the user.
     */
    public val rootException: Throwable? = null,

    /**
     * The type of generic error that is most closely associated to this error. Useful for mapping to http statuses
     */
    public val errorType: DomainErrorType? = null,
) {
    public fun debugInformation(): String = buildString {
        appendLine("error_type=${this@DomainError::class.simpleName}")
        internalMessage?.let { appendLine("message=${internalMessage}") }
        rootException?.let { appendLine("stack_trace=${it.stackTraceToString()}") }
    }
}